'use strict'

import debug from '../utils/debug'
import serialize from '../form/serialize'
import * as steps from './steps'

window.$ = window.jQuery
window.Utillz_Core = window.Utillz_Core || {};

class Submission {

    constructor() {

        debug.log('submission', 'Constructor')

        $(document).ready(() => this.init())

	}

	init() {

        this.index = 0

        this.$ = $('.ulz-submission')
        this.$steps = $('.ulz-submission-steps')
        this.$step = $('.ulz-submission-step')
        this.$wizard = $('.ulz-wizard')

        this.navigate()

        $(document).on('click', `[data-action='submission-continue']`, () => {
            this.call()
        })

        $(document).on('click', `[data-action='submission-back']`, e => {
            this.back(e)
        })

        $(document).on('click', '.ulz-submission-types .ulz--type', e => {
            $('.ulz-submission-types .ulz--type').removeClass('ulz-active')
            $(e.currentTarget).addClass('ulz-active')
        })

	}

    submit_type() {

        let type = $('[name="type"]:checked').val()

        if( typeof type == 'undefined' ) {
            $('.ulz-submission-error').addClass('ulz-block')
            window.scrollTo({
                top: $('.ulz-submission-error').position().top - 70,
                left: null,
                behavior: 'smooth'
            })
        }else{
            this.$.addClass('ulz-ajaxing')
            $('[name="ulz-submit-type"]').submit()
        }

    }

    navigate() {

        let $current_li = this.$wizard.find('li').eq( this.index )
        let $next_step = this.$step.eq( this.index )

        // progress
        let total = this.$wizard.find('li').length
        let current = this.index + 1
        let length = 100 / total * current

        this.$step.removeClass('ulz-active')
        $next_step.addClass('ulz-active')

        $current_li.addClass('ulz-active ulz-current')
        $current_li.prevAll().removeClass('ulz-current')
        $current_li.nextAll().removeClass('ulz-active ulz-current')

        $('.ulz--steps-total').html( total )
        $('.ulz--steps-current').html( current )
        $('.ulz--progress').css( 'width', `${length}%` )

        return $next_step.attr('data-id')

    }

    back(e) {

        if( this.$.hasClass('ulz-ajaxing') ) {
            return
        }

        if( this.index <= 0 ) {
            return
        }

        if( $( e.currentTarget ).hasClass('ulz--mutted') ) {
            return
        }

        // first
        if( this.index == 1 ) {
            $(`[data-action='submission-back']`).addClass('ulz--mutted')
        }

        this.index -= 1
        this.navigate()

    }

    call() {

        if( this.$.hasClass('ulz-ajaxing') ) {
            return;
        }

        if( $('.ulz-submission-types').length ) {
            this.submit_type()
            return;
        }

        let $current = this.$step.eq( this.index )
        let id = $current.data('id')

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-submission-next',
                group: $current.attr('data-group'),
                id: $current.attr('data-id'),
                input: serialize( $( 'form', this.$ ) )
            },
            beforeSend: () => {

                this.$.addClass('ulz-ajaxing')

                $('.ulz-form-group-error', $current).removeClass('ulz-form-group-error')
                $('.ulz-error-holder', $current).remove()

                $('.ulz-select-plan-error', this.$).removeClass('ulz-block')

            },
            complete: () => {
                this.$.removeClass('ulz-ajaxing')
            },
            success: ( response ) => {

                // success
                if( response.success ) {

                    window.scrollTo({
                        top: 0,
                        left: null,
                        behavior: 'smooth'
                    })

                    this.index += 1

                    $(`[data-action='submission-back']`).removeClass('ulz--mutted')

                    id = this.navigate()

                    /**/

                }
                // error
                else{

                    let $first_error = null

                    for( var field_name in response.errors ) {

                        let $error = $('[data-id="' + field_name.replace(/^ulz_/, '') + '"]', $current).first()

                        $error.addClass('ulz-form-group-error')
                            .append('<p class="ulz-error-holder"><span class="ulz-error">' + response.errors[ field_name ] + '</span></p>')

                        if( ! $first_error ) {
                            $first_error = $error
                        }
                    }

                    // scroll to first error on screen
                    if( $first_error.length ) {

                        let top = $first_error.position().top - $('.ulz--top').outerHeight() - 20

                        window.scrollTo({
                            top: top,
                            left: null,
                            behavior: 'smooth'
                        })

                    }

                }

                let step_id = id.split('-').join('_');

                if( typeof steps[ step_id ] == 'function' ) {

                    let fallback = new steps[ step_id ]( this.$step.filter(( index, element ) => {
                        return element.getAttribute('data-id') == id
                    }), response )

                    response.success ? fallback.init() : fallback.error()

                }

            }

        })

    }

}

window.Utillz_Core.submission = new Submission()
