'use strict'

import debug from '../utils/debug'

window.$ = window.jQuery

class step {

    constructor( element, response ) {

        this.$ = element
        this.response = response

    }

    init() {}
    error() {}

}

/*
 * success
 *
 */
export class success extends step {

    init() {

        $('.ulz-submission').addClass('ulz--success')

        $(`[data-action='submission-continue']`)
            .attr( 'href', this.response.listing.button_url )
            .removeAttr('data-action')
            .find('.ulz--text')
                .html( this.response.listing.button_text )

        $(`[data-action='submission-back']`)
            .addClass('ulz--mutted')
            .removeAttr('data-action')

    }

}

/*
 * select plan
 *
 */
export class select_plan extends step {

    init() {

    }

    error() {

        $('.ulz-select-plan-error', this.$).addClass('ulz-block')
            .find('span').html( this.response.errors.ulz_plan )

        $(window).scrollTop( $('.ulz-select-plan-error', this.$).position().top )

    }

}
