'use strict'

import debug from '../utils/debug'

window.$ = window.jQuery

export default class Standard {

    constructor() {

        debug.log('sigin', 'Social: standard')

        $(document).ready(() => this.init())

	}

	init() {

        this.$ = $(`.ulz-signin-section[data-id='sign-in']`)
        this.$button = $(`[data-action='sign-in-standard']`)

        $(document).on('utillz:signin/standard', () => this.request())

        this.$.on( 'submit', e => {
            e.preventDefault()
            this.request()
        })

	}

    request() {

        let $modal = $('.ulz-modal-signin')

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-signin-standard',
                user_email: $('[name="user_email"]', this.$).val(),
                user_password: $('[name="user_password"]', this.$).val(),
                security: window.utillz_core_vars.nonce,
            },
			beforeSend: () => {
                $('.ulz-modal-button').addClass('ulz-ajaxing')
                $('.ulz-signin-errors', this.$).html('').removeClass('ulz-active')
			},
			complete: () => {

            },
			success: ( response ) => {

				if( response.success ) {

                    window.location.reload()

                }else{

                    $('.ulz-modal-container', $modal).scrollTop(999)
                    $('.ulz-modal-button').removeClass('ulz-ajaxing')

                    $('.ulz-signin-errors', this.$).html( `<ul><li>${response.error_string}</li></ul>` )
                        .addClass('ulz-active')

                }

			}
        })

    }

}
