'use strict'

import debug from '../utils/debug'

window.$ = window.jQuery

export default class Signup {

    constructor() {

        debug.log('site', 'Signin: constructor')

        $(document).ready(() => this.init())

	}

	init() {

        this.$ = $(`.ulz-signin-section[data-id='create-account']`)
        this.$button = $(`[data-action='sign-up']`)

        $(document).on('utillz:signin/create-account', () => this.request())

        this.$.on( 'submit', e => {
            e.preventDefault()
            this.request()
        })

	}

    request() {

        let $modal = $('.ulz-modal-signin')
        let signup_type = $modal.attr('data-signup')

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-signup',
                username: $('[name="username"]', this.$).val(),
                first_name: $('[name="first_name"]', this.$).val(),
                last_name: $('[name="last_name"]', this.$).val(),
                email: $('[name="email"]', this.$).val(),
                phone: $('[name="phone"]', this.$).val(),
                password: $('[name="password"]', this.$).val(),
                repeat_password: $('[name="repeat_password"]', this.$).val(),
                terms: $('[name="terms"]', this.$).prop('checked') ? 1 : 0,
                role: $('[name="role"]', this.$).val(),
                security: window.utillz_core_vars.nonce,
            },
			beforeSend: () => {

                $('.ulz-modal-button').addClass('ulz-ajaxing')
                $('.ulz-signin-errors', this.$).html('').removeClass('ulz-active')

                if( signup_type == 'email' ) {
                    $('.ulz-signin-success', this.$).removeClass('ulz-active')
                }

			},
			complete: () => {

            },
			success: ( response ) => {

				if( response.success ) {

                    if( signup_type == 'email' ) {

                        $('.ulz-signin-success', this.$).addClass('ulz-active')
                        $(`[name='first_name'], [name='last_name'], [name='email'], [name='password'], [name='repeat_password']`, this.$).val('')

                        $('.ulz-modal-container', $modal).scrollTop(999)
                        $('.ulz-modal-button').removeClass('ulz-ajaxing')

                    }else{
                        window.location.reload()
                    }

                }else{

                    $('.ulz-modal-container', $modal).scrollTop(999)
                    $('.ulz-modal-button').removeClass('ulz-ajaxing')

                    $('.ulz-signin-errors', this.$).html( `<ul><li>${response.error_string}</li></ul>` )
                        .addClass('ulz-active')

                }

			}
        })

    }

}
