'use strict'

import Signup from './signup'
import Standard from './standard'
import Reset from './reset'
import Facebook from './social/facebook'
import Google from './social/google'

window.$ = window.jQuery
window.Utillz_Core = window.Utillz_Core || {};

class Signin {

    constructor() {

        $(document).ready(() => this.init())

	}

	init() {

        this.action = 'sign-in'

        new Signup()
        new Standard()
        new Reset()

        let $fb_button = $(`[data-action='sign-in-facebook']`)
        if( $fb_button.length ) {
            this.facebook = new Facebook()
        }

        let $gg_button = $(`[data-action='sign-in-google']`)
        if( $gg_button.length ) {
            this.google = new Google()
        }

        $(document).on('click', '.ulz-signin-tabs li, .ulz-lost-pass-link', e => {

			let $e = $(e.currentTarget)
			let id = $e.attr('data-for')
			let label = $e.attr('data-label')

            this.action = id

            if( $('.ulz-standard-role').length ) {
                $('.ulz-modal-signin .ulz-modal-footer')[ id == 'create-account' ? 'addClass' : 'removeClass' ]('ulz-none')
                $('.ulz-signin-container').addClass('ulz-none')
                $('.ulz-standard-role').removeClass('ulz-none')
            }

            $('.ulz-modal-signin .ulz-modal-button span').html( label )

			$('.ulz-signin-tabs li').removeClass('ulz-active')
			$e.addClass('ulz-active')

			$('.ulz-signin-section').removeClass('ulz-active')
			$(`.ulz-signin-section[data-id='${id}']`).addClass('ulz-active')



		})

        $('.ulz-modal-signin form').on('submit', e => {
            e.preventDefault()
            this.target()
        })

        $(document).on('utillz:signin/target', () => this.target())

        // role
        let $role = $('.ulz-standard-role a')
        $role.on('click', e => {

            let $e = $(e.currentTarget)

            $role.removeClass('ulz--active')
            $e.addClass('ulz--active')

            $('.ulz-standard-role input').val( $e.attr('data-role') )

            $('.ulz-signin-container').removeClass('ulz-none')
            $('.ulz-standard-role').addClass('ulz-none')

            $('.ulz-modal-signin .ulz-modal-footer').removeClass('ulz-none')

        })

	}

    target() {

        if( $('.ulz-modal-signin .ulz-modal-button').hasClass('ulz-ajaxing') ) {
            return;
        }

        switch( this.action ) {
            case 'sign-in':
                $(document).trigger('utillz:signin/standard')
                break;
            case 'create-account':
                $(document).trigger('utillz:signin/create-account')
                break;
            case 'reset-password':
                $(document).trigger('utillz:signin/reset-password')
                break;
        }

    }

}

window.Utillz_Core.signin = new Signin()

// gapis fallback
window.ulz_gapis_init = function() {
    window.Utillz_Core.signin.google.gapis_init()
}
