'use strict'

import debug from '../utils/debug'

window.$ = window.jQuery

export default class Reset {

    constructor() {

        debug.log('site', 'Sign in: reset password')

        $(document).ready(() => this.init())

	}

	init() {

        this.$ = $(`.ulz-signin-section[data-id='reset-password']`)
        this.$button = $(`[data-action='reset-password']`)

        $(document).on('utillz:signin/reset-password', () => this.request())

        this.$.on( 'submit', e => {
            e.preventDefault()
            this.request()
        })

	}

    request() {

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-reset-password',
                user_email: $('[name="email"]', this.$).val(),
                security: window.utillz_core_vars.nonce,
            },
			beforeSend: () => {
				$('.ulz-modal-button').addClass('ulz-ajaxing')
				// $('.ulz-form-group-error', this.$).removeClass('ulz-form-group-error')
                $('.ulz-signin-errors', this.$).html('').removeClass('ulz-active')
			},
			complete: () => {
                $('.ulz-modal-button').removeClass('ulz-ajaxing')
            },
			success: ( response ) => {

				if( response.success ) {

                    $('.ulz-signin-success', this.$).addClass('ulz-active')
                    $(`[name='email']`, this.$).val('')

                }else{

                    let error_strings = '<ul><li>' + response.error_strings.join('</li><li>') + '</li></ul>'
                    $('.ulz-signin-errors', this.$).html( error_strings ).addClass('ulz-active')

                }

			}
        })

    }

}
