'use strict'

import debug from '../utils/debug'

window.$ = window.jQuery
window.Utillz_Core = window.Utillz_Core || {}

class Modal {

    constructor() {

        this.base = require('./_base.js').default
        this.modules = require('./_modules.js')

        $(document).ready(() => this.ready())

    }

	ready() {

        debug.log('site', 'Modal: ready')

        this.$b = $('body')
        this.$overlay = $('.ulz-overlay')

        $(document).on('click', '[data-modal]', e => this.request(e))
        $(document).on('utillz:modal/close', () => this.close())
        $(document).on('click', `[data-action='modal-close']`, () => {
            $(document).trigger('utillz:modal/close')
        })

	}

    request(e) {

        e.preventDefault()

        let $e = $( e.currentTarget )
        let id = $e.data('modal')
        let params = $e.data('params')

        if( id ) {
            this.open( id, params, e )
        }

    }

    add_module( id, module ) {
        this.modules[ id ] = module
    }

    open( id, params, e ) {

        let $e = $(`.ulz-modal[data-id='${id}']`)

        if( $e.length ) {

            let type = id.split('-').join('_')
            let data = {
                'id': id,
                'element': $e,
                'params': params,
                'event': e,
                'type': type
            }

            if( typeof this.modules[ type ] == 'function' ) {
                // re-use existing modal instance
                if( typeof this.instance !== 'undefined' && this.instance.type == type ) {
                    this.instance.init( data )
                }
                // create new instance
                else{
                    this.close()
                    this.instance = new this.modules[ type ]( data )
                    this.instance.init()
                }
            }
            // static
            else{
                $e.addClass('ulz-visible')
                $('body').addClass(`ulz-modal-open ulz-modal-open--${id}`)
            }

        }else{
            console.log(`Modal '${id}' doesn't exists.`);
        }

    }

    close() {

        $('.ulz-modal.ulz-visible').each(( index, element ) => {

            let $e = $( element )
            let id = $e.data('id')

            if( id ) {
                let type = id.split('-').join('_');

                if( typeof this.modules[ type ] == 'function' ) {
    				this.instance.close()
    			}

                delete( this.instance )
            }

            $e.removeClass('ulz-visible')
            this.$b.removeClass(`ulz-modal-open--${id}`)

        })

        this.$b.removeClass('ulz-modal-open')

    }

    flush() {
        delete( this.instance )
    }

}

window.Utillz_Core.modal = new Modal()
