'use strict'

import debug from '../utils/debug'
import base from './_base'
import serialize from '../form/serialize'

window.$ = window.jQuery

/*
 * listing edit
 *
 */
export class listing_edit extends base {

    init() {

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-listing-edit',
                listing_id: this.params
            },
            beforeSend: () => {
                this.ajaxing()
            },
            success: response => {

                this.$append.html( response.html )
                this.$.removeClass('ulz-ajaxing')

                window.Utillz_Core.form.fields() // init fields

                $(`[data-action='listing-save']`, this.$).on('click', () => { this.save() } )

            }
        })

    }

    save() {

        if( this.$.hasClass('ulz-modal-ajaxing') ) {
            return;
        }

        let data = serialize( $( 'form', this.$ ) )
        data['action'] = 'utillz-listing-update'

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: data,
            beforeSend: () => {

                this.$.addClass('ulz-modal-ajaxing')
                $('.ulz-error-holder', this.$).remove()

            },
            complete: () => {
                // ..
            },
            success: ( response ) => {

                if( response.success ) {

                    window.location.reload()

                }else{

                    let $first_error = null

                    this.$.removeClass('ulz-modal-ajaxing')

                    for( var field_name in response.errors ) {

                        let $error = $('[data-id="' + field_name.replace(/^ulz_/, '') + '"]', this.$).first()

                        $error.addClass('ulz-form-group-error')
                            .append('<p class="ulz-error-holder"><span class="ulz-error">' + response.errors[ field_name ] + '</span></p>')

                        if( ! $first_error ) {
                            $first_error = $error
                        }

                    }

                    // scroll to first error on screen
                    if( $first_error.length ) {

                        let top = $first_error.position().top + $('.ulz-modal-container', this.$).scrollTop() - 20

                        $('.ulz-modal-container', this.$).get(0).scrollTo({
                            top: top,
                            left: null,
                            behavior: 'smooth'
                        })

                    }

                }

            }
        })

    }

    close() {}

}

/*
 * promote
 *
 */
export class promote extends base {

    init() {

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-get-promotions',
                listing_id: this.params
            },
            beforeSend: () => {
                this.ajaxing()
            },
            success: ( response ) => {

                this.$append.html( response.html )
                this.$.removeClass('ulz-ajaxing')

                $(document).on('click', '[data-action="promote-listing"]', () => this.promote_listing())

            }
        })

    }

    promote_listing() {

        if( this.$.hasClass('ulz-modal-ajaxing') ) {
            return;
        }

		$.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-promote-listing',
				security: $('#utillz_promote_listing').val(),
				listing_id: $('#promote-listing-id').val(),
				package_id: $('[name="package_id"]:checked', this.$).val()
            },
            beforeSend: () => {

                this.$.addClass('ulz-modal-ajaxing')
                $('.ulz-error-holder', this.$).remove()

            },
            complete: () => {



            },
			success: ( response ) => {

				// success
				if( response.success ) {
					if( response.cart_url ) {
						window.location.href = response.cart_url
					}
				}
				// error
				else{

					this.$.removeClass('ulz-modal-ajaxing')

					$('.ulz-modal-container', this.$)
						.append('<div class="ulz-error-holder ulz-text-center"><p class="ulz-error">' + response.error + '</p></div>');
				}

			}
        })

	}

    close() {}

}

/*
 * favorites
 *
 */
export class favorites extends base {

    init() {

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-get-favorites',
                listing_id: this.params
            },
            beforeSend: () => {
                this.ajaxing()
            },
            success: ( response ) => {

                this.$append.html( response.html )
                this.$.removeClass('ulz-ajaxing')

            }
        })

    }

    close() {}

}

/*
 * action type application
 *
 */
export class action_application extends base {

    init() {

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-action-application-form',
                listing_id: window.utillz_core_vars.post_id
            },
            beforeSend: () => {
                this.ajaxing()
            },
            success: ( response ) => {

                this.$append.html( response.html )

                $('[data-action="send-application"]', this.$).on('click', e => this.send_application(e))

                this.$.removeClass('ulz-ajaxing')

                window.Utillz_Core.form.fields()

            }
        })

    }

    send_application(e) {

        if( this.$.hasClass('ulz-modal-ajaxing') ) {
            return;
        }

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-action-application-send',
                listing_id: window.utillz_core_vars.post_id,
                input: serialize( $( 'form', this.$ ) )
            },
            beforeSend: () => {

                this.$.addClass('ulz-modal-ajaxing')
                $('.ulz-error-holder', this.$).remove()

            },
            complete: () => {

                this.$.removeClass('ulz-modal-ajaxing')

            },
            success: ( response ) => {

                if( response.success ) {

                    $('.ulz--icon', this.$).removeClass('ulz-none')
                    $('.ulz-form, .ulz-modal-footer', this.$).addClass('ulz-none')

                }else{

                    for( var field_name in response.errors ) {

                        $('[data-id="' + field_name.replace(/^ulz_/, '') + '"]', this.$)
                            .addClass('ulz-form-group-error')
                            .append('<p class="ulz-error-holder"><span class="ulz-error">' + response.errors[ field_name ] + '</span></p>');
                    }

                }

            }
        })
    }

    close() {
        this.$append.empty()
        this.$.removeClass('ulz-modal-ajaxing')
    }

}

/*
 * payout
 *
 */
export class payout extends base {

    init() {

        window.Utillz_Core.form.fields()

        $('[data-action="payout"]').on('click', () => this.call() )

    }

    close() {

        $('[data-action="payout"]').off()

    }

    call() {

        if( this.$.hasClass('ulz-modal-ajaxing') ) {
            return;
        }

        let data = serialize( $( 'form', this.$ ) )
        data['action'] = 'utillz-action-payout'

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: data,
            beforeSend: () => {

                this.$.addClass('ulz-modal-ajaxing')
                $('.ulz-error-holder', this.$).remove()

            },
            complete: () => {

                this.$.removeClass('ulz-modal-ajaxing')

            },
            success: ( response ) => {

                if( response.success ) {

                    $('.ulz--icon', this.$).removeClass('ulz-none')
                    $('.ulz-form, .ulz-modal-footer').addClass('ulz-none')

                    setTimeout(() => {
                        window.location.reload()
                    }, 1000 )

                }else{

                    for( var field_name in response.errors ) {

                        $('[data-id="' + field_name.replace(/^ulz_/, '') + '"]', this.$)
                            .addClass('ulz-form-group-error')
                            .append('<p class="ulz-error-holder"><span class="ulz-error">' + response.errors[ field_name ] + '</span></p>');
                    }

                }

            }
        })

    }

}

/*
 * submit review
 *
 */
export class review_submit extends base {

    init() {

        this.reload = false

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-review-get',
                listing_id: this.params
            },
            beforeSend: () => {
                this.ajaxing()
            },
            success: ( response ) => {

                this.$append.html( response.html )
                this.$.removeClass('ulz-ajaxing')
                window.Utillz_Core.form.fields()

                $('#ulz-review-submit').on('click', e => this.submit(e))
        		$('.ulz-rating-stars i', this.$).on('click', e => this.rate(e))

            }
        })

    }

	rate(e) {

		let $star = $( e.currentTarget )
		let $review = $star.parent()
		let $stars = $( 'i', $review )

		$stars.removeClass('ulz-active')
        $star.addClass('ulz-active')

		$review.parent().find('input').val( 5 - $stars.index( $star ) )

	}

	submit(e) {

		e.preventDefault()

        if( this.$.hasClass('ulz-modal-ajaxing') ) {
            return;
        }

		$.ajax({
			type: 'post',
			dataType: 'json',
			url: window.utillz_core_vars.admin_ajax,
			data: {
    			action: 'utillz-review-submit',
    			review: serialize( $( 'input, textarea, select', this.$ ), false, true )
    		},
			beforeSend: () => {

                this.$.addClass('ulz-modal-ajaxing')
                $('.ulz-form-group-error', this.$).removeClass('ulz-form-group-error')
        		$('.ulz-error-holder', this.$).remove()

            },
            complete: () => {

                this.$.removeClass('ulz-modal-ajaxing')

            },
			success: ( response ) => {

				if( response.success ) {

                    $('.ulz-reviews-form', this.$).addClass('ulz-none')
                    $('.ulz-success', this.$).removeClass('ulz-none')

                    $('.ulz-modal-footer', this.$).hide()

                    this.reload = true
                    // setTimeout(() => {
                    //     window.location.reload()
                    // }, 1000 )

				}else{

					this.$.removeClass('ulz-ajaxing')

					for( var field_name in response.errors ) {
                        $('.ulz-form-group[data-id="' + field_name + '"]', this.$)
							.addClass('ulz-form-group-error')
                            .append('<p class="ulz-error-holder"><span class="ulz-error">' + response.errors[ field_name ] + '</span></p>')
                    }

				}

			}
		});

	}

    close() {
        this.$append.html('')

        if( this.reload ) {
            window.location.reload()
        }
    }

}

/*
 * review reply
 *
 */
export class review_reply extends base {

    init() {

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-review-reply-get',
                comment_id: this.params
            },
            beforeSend: () => {
                this.ajaxing()
            },
            success: ( response ) => {

                this.$append.html( response.html )
                this.$.removeClass('ulz-ajaxing')
                window.Utillz_Core.form.fields()

                $('#ulz-review-submit-reply').on('click', e => this.submit(e))

            }
        })

    }

	submit(e) {

		e.preventDefault()

        if( this.$.hasClass('ulz-modal-ajaxing') ) {
            return;
        }

		$.ajax({
			type: 'post',
			dataType: 'json',
			url: window.utillz_core_vars.admin_ajax,
			data: {
    			action: 'utillz-review-reply-submit',
    			reply: serialize( $( 'input, textarea, select', this.$ ), false, true )
    		},
			beforeSend: () => {

                this.$.addClass('ulz-modal-ajaxing')
                $('.ulz-form-group-error', this.$).removeClass('ulz-form-group-error')
        		$('.ulz-error-holder', this.$).remove()

            },
            complete: () => {

                this.$.removeClass('ulz-modal-ajaxing')

            },
			success: ( response ) => {

				if( response.success ) {

                    $('.ulz-reviews-form', this.$).addClass('ulz-none')
                    $('.ulz-success', this.$).removeClass('ulz-none')

                    setTimeout(() => {
                        window.location.reload()
                    }, 1000 )

				}else{

                    this.$.removeClass('ulz-ajaxing')

					for( var field_name in response.errors ) {
                        $('.ulz-form-group[data-id="' + field_name + '"]', this.$)
							.addClass('ulz-form-group-error')
                            .append('<p class="ulz-error-holder"><span class="ulz-error">' + response.errors[ field_name ] + '</span></p>')
                    }

				}

			}
		});

	}

    close() {
        this.$append.html('')
    }

}

/*
 * more filters
 *
 */
export class filters extends base {

    init() {

        $('.ulz-modal-button', this.$).on('click', () => {
            window.Utillz_Core.modal.close()
        })

    }

    close() {}

}

/*
 * signin
 *
 */
export class signin extends base {

    init() {

        this.enque()

        $('.ulz-modal-footer', this.$).on('click', () => {
            $(document).trigger('utillz:signin/target')
        })
    }

    enque() {

        if( $(`meta[name='utillz-signin-scripts-ready']`).length ) {
            return;
        }

        if( window.utillz_core_vars.sdk.facebook.enabled ) {
            $('head').append(`<script type="text/javascript" src="https://connect.facebook.net/en_US/sdk.js?ver=${window.utillz_core_vars.version}"><\/script>`)
        }
        if( window.utillz_core_vars.sdk.google.enabled ) {
            $('head').append(`<script type="text/javascript" src="https://apis.google.com/js/platform.js?onload=ulz_gapis_init&ver=${window.utillz_core_vars.version}"><\/script>`)
        }
        
        $('head').append(`<script type="text/javascript" src="${window.utillz_core_vars.uri}assets/dist/js/signin.js?ver=${window.utillz_core_vars.version}"><\/script>`)
        $('head').append('<meta name="utillz-signin-scripts-ready" content="true">')

    }

    close() {
        // ..
    }

}

/*
 * account edit entry
 *
 */
export class entry_edit extends base {

    init() {

        this.params = Object.assign({
            id: null,
            type: '',
        }, this.params )

        this.call()

    }

    close() {

        this.$append.html('')

        if( this.params.type !== '' ) {
            window.location.reload()
        }

    }

    call() {

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-entry-edit',
                id: this.params.id,
                type: this.params.type,
            },
            beforeSend: () => {
                this.ajaxing()
            },
            success: ( response ) => {

                if( response.redirect_url ) {

                    window.location.href = response.redirect_url

                }else{

                    this.$append.html( response.html )
                    this.$.removeClass('ulz-ajaxing')

                }

            }
        })

    }

    entry_action( e ) {

        let $e = $(e.currentTarget)
        let type = $e.attr('data-type')
        if( type ) {
            this.params.type = type
        }

        this.call()

    }

}

/*
 * conversation
 *
 */
export class conversation extends base {

    init() {

        this.params.action = 'utillz-get-conversation'

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: this.params,
            beforeSend: () => {
                this.ajaxing()
            },
            success: ( response ) => {

                this.count = response.count
                this.$append.html( response.html )

                let $messages = $('.ulz-messages', this.$)
                let $container = $('.ulz-modal-container', this.$)

                setTimeout(() => {
                    $container.scrollTop( $container.prop('scrollHeight') )
                }, 1 )

                let $input = $('#ulz_message')
                $input.on('focus', () => {
                    this.$.removeClass('ulz--error')
                    $input.addClass('ulz--focus')
                    $container.scrollTop( $container.prop('scrollHeight') )
                })

                $('[data-action="send-message"]', this.$).on('click', e => this.send_message(e))

                this.$.removeClass('ulz-ajaxing')

            }
        })

    }

    send_message(e) {

        if( this.$.hasClass('ulz-ajaxing-message') ) {
            return;
        }

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-send-message',
                security: window.utillz_core_vars.nonce,
                listing_id: $('#ulz_message_listing_id').val(),
                conversation_id: $('#ulz_message_conversation_id').val(),
                direct_user_id: $('#ulz_message_direct_user_id').val(),
                message: $( '[name="ulz_message"]', this.$ ).val()
            },
            beforeSend: () => {

                this.$
                    .removeClass('ulz--error')
                    .addClass('ulz-ajaxing-message')

            },
            success: ( response ) => {

                // success
				if( response.success ) {

                    $('.ulz-message-submit').addClass('ulz-none')
                    $( '[name="ulz_message"]', this.$ ).val('')

                    $('.ulz-messages').replaceWith( $( response.html ).find('.ulz-messages') )
                    this.message_ready()

				}
                // error
                else{

                    this.$
                        .addClass('ulz--error')
                        .removeClass('ulz-ajaxing-message')

                }

            }
        })
    }

    message_ready() {

        setTimeout(() => {
            let $container = $('.ulz-modal-container', this.$)
            $container.scrollTop( $container.prop('scrollHeight') )
            this.$.removeClass('ulz-ajaxing-message')
        }, 10 )

    }

    close() {

        this.$append.empty()
        this.$.removeClass('ulz-ajaxing-message')

        clearInterval( this.tracker )
        this.tracker = null

    }

}
