'use strict'

import debug from '../utils/debug'
import url from '../utils/url'
import serialize from '../form/serialize'
import map_styles from '../explore/map/styles'
// import Marker from '../explore/map/marker'

window.$ = window.jQuery

class mod {

    constructor( module ) {

        this.$ = module
        this.init()

        module.addClass('ulz-ready')

    }

    ajaxing() {

        if( this.$.hasClass('ulz-ajaxing') ) {
            return
        }
		this.$.addClass('ulz-ajaxing')

    }

    init() {}

}

/*
 * location
 *
 */
export class location extends mod {

    init() {

        if( typeof window.google == 'undefined' ) {
            return;
        }

        let $map = $('.ulz-map', this.$)

        if( ! $map.length ) {
            return;
        }

        let marker_html = $('.ulz-mod-listing-marker-content', this.$).html()

        let marker_position = {
            lat: parseFloat( $map.data('lat') ),
            lng: parseFloat( $map.data('lng') )
        }

        let map = new google.maps.Map( $map.get(0), {
            zoom: 15,
            center: marker_position,
            mapTypeControl: false,
            fullscreenControl: false,
            streetViewControl: false,
            scrollwheel: false,
            zoomControl: false,
            clickableIcons: false,
            styles: map_styles()
        })

        if( ! this.$.children().hasClass('ulz--has-address') ) {
            new google.maps.Circle({
                strokeColor: '#111',
                strokeOpacity: 0,
                strokeWeight: 0,
                fillColor: '#111',
                fillOpacity: 0.125,
                map: map,
                center: marker_position,
                radius: 300
            })
        }

        const Marker = require('../explore/map/marker.js')

        var marker = new Marker.default({
            id: null,
            position: new google.maps.LatLng( marker_position ),
            content: marker_html,
            map: map,
        })

        $(`[data-action='explore-map-zoom-in']`, this.$).on('click', () => {
            var currentZoomLevel = map.getZoom()
            if( currentZoomLevel !== 21 ) {
                map.setZoom( currentZoomLevel + 1 )
            }
        })

        $(`[data-action='explore-map-zoom-out']`, this.$).on('click', () => {
            var currentZoomLevel = map.getZoom()
            if( currentZoomLevel !== 0 ) {
                map.setZoom( currentZoomLevel - 1 )
            }
        })

    }

}

/*
 * menu
 *
 */
export class menu extends mod {

    init() {

        $('.ulz--tabs li', this.$).on('click', e => {

            let $e = $(e.currentTarget)
            let index = $('.ulz--tabs li', this.$).index( $e )

			$('.ulz--tabs li', this.$).removeClass('ulz-active')
            $e.addClass('ulz-active')

            $('.ulz--section', this.$).removeClass('ulz-active')
                .eq( index ).addClass('ulz-active')

		});

    }

}

/*
 * content
 *
 */
export class content extends mod {

    init() {

        if( ! this.$.hasClass('ulz--has-more') ) {
            return;
        }

        let $inner = $('.ulz--inner', this.$)
        let $content = $('.ulz--content', this.$)

        if( $content.height() > $inner.height() ) {
            this.$.addClass('ulz--has-height')

            $('.ulz--more a', this.$).on('click', this.$, e => {

                TweenLite.to(
					$inner,
					.3,
					{ maxHeight: $content.height(), ease: Power3.easeOut }
				)

                TweenLite.to(
					$('.ulz--more, .ulz--shadow', this.$),
					.3,
					{ opacity: 0, onComplete: () => {
                        this.$.removeClass('ulz--has-height')
                    }}
				)

            })
        }

    }

}
