'use strict'

import debug from '../utils/debug'
import * as mods from './mods'
import * as actions from './actions'

window.$ = window.jQuery
window.Utillz_Core = window.Utillz_Core || {}

class Listing {

    constructor() {

        debug.log('listing', 'Constructor')

        $(document).ready(() => this.init())

	}

    init() {

        this.xhr = null
        this.reviews_page = 1;

        this.fields()
        this.comments()

        $(document).on('utillz:listing/init', () => this.modules())
            .trigger('utillz:listing/init')

        $(document).on('utillz:listing/action', () => this.action())
            .trigger('utillz:listing/action')

        $('#ulz-send-report').on('click', () => this.send_report())

        $(document).on('click', '[data-action="load-more-reviews"]', e => this.load_more_reviews(e))

    }

    load_more_reviews(e) {

        let $e = $(e.currentTarget)
        let $comments = $('.ulz-reviews-comments')

        if( $comments.hasClass('ulz-ajaxing') ) {
            return;
        }

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-action-load-more-reviews',
                listing_id: window.utillz_core_vars.post_id,
                onpage: ++this.reviews_page,
            },
			beforeSend: () => {
                $comments.addClass('ulz-ajaxing')
			},
			complete: () => {
                $comments.removeClass('ulz-ajaxing')
            },
			success: ( response ) => {

				if( response.success ) {

                    if( response.html ) {

                        let $html = $( response.html ).contents()

                        $('.ulz-comments', $comments).append( $html )

                        if( response.max_num_pages <= this.reviews_page ) {
                            $e.addClass('ulz-disabled').removeAttr('data-action')
                        }

                    }


				}

			}
        })

    }

    comments() {

        $(document).on('click', '.ulz-comment-more', e => this.get_comment(e))

    }

    get_comment(e) {

        if( $('.ulz-comment-more.ulz-ajaxing').length ) {
            return;
        }

        let $e = $(e.currentTarget)
        let comment_id = $e.data('id')

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-action-get-comment',
                comment_id: comment_id,
            },
			beforeSend: () => {
                $e.addClass('ulz-ajaxing')
			},
			complete: () => {
                $e.removeClass('ulz-ajaxing')
            },
			success: ( response ) => {

				if( response.success ) {

                    $(`.ulz-comment-text[data-id='${comment_id}']`).html( response.comment_text )
                    $e.remove()

				}

			}
        })

    }

    fields() {

        window.Utillz_Core.form.fields()

    }

    modules() {

        $('.ulz-mod-listing').not('.ulz-ready').each(( index, element ) => {

            let $e = $( element )
            let type = $e.data('type')

			if( typeof mods[ type ] == 'function' ) {
				new mods[ type ]( $e )
			}

        })

    }

    action() {

        debug.log('listing', 'Action: init')

        $('.ulz-mod-action').each((i, e) => {

            let $e = $(e)
            let type = $e.data('type').replace( /-/g, '_' )

    		if( typeof actions[ type ] == 'function' ) {
    			new actions[ type ]( $e )
    		}

        })

    }

    send_report() {

        let $report = $('.ulz-modal-action-report')
        let $content = $('.ulz-modal-content', $report)

        if( $content.hasClass('ulz-ajaxing') ) {
            return
        }
		$content.addClass('ulz-ajaxing')

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-send-report',
				security: $('#utillz_report').val(),
				listing_id: $('#ulz_listing_id').val(),
				report_reason: $( '[name="ulz_report_reason"]:checked', this.$ ).val()
            },
			beforeSend: () => {
				$content.addClass('ulz-ajaxing')
				$('.ulz-error-holder', $report).remove()
			},
			complete: () => {
                $content.removeClass('ulz-ajaxing')
            },
			success: ( response ) => {

				// success
				if( response.success ) {

                    $('.ulz-reported').removeClass('ulz-none')
                    $('.ulz-report-submit, .ulz-modal-footer', $report).addClass('ulz-none')

				}else{

                    for( var field_name in response.errors ) {
                        $(`.ulz-form-group[data-id="${field_name}"]`, $report)
							.addClass('ulz-form-group-error')
                            .append('<p class="ulz-error-holder"><span class="ulz-error">' + response.errors[ field_name ] + '</span></p>')
                    }

                }

			}
        })

    }

}

window.Utillz_Core.listing = new Listing()
