'use strict'

import debug from '../utils/debug'
import map_styles from '../explore/map/styles'

// import Marker from '../explore/map/marker'

window.$ = window.jQuery

class action {

    constructor( action ) {

        this.$ = action
        this.init()

        action.addClass('ulz-ready')

    }

    ajaxing() {

        if( this.$.hasClass('ulz-ajaxing') ) {
            return
        }
		this.$.addClass('ulz-ajaxing')

    }

    init() {}

}

/*
 * location
 *
 */
export class location extends action {

    init() {

        this.$map = $('.ulz-action-map')

        if( typeof window.google == 'undefined' ) {
            $( 'span', this.$map ).removeClass('ulz-none')
            return;
        }

        if( ! this.$map.length ) {
            return;
        }

        this.location = {
            lat: parseFloat( this.$map.attr('data-lat') ),
            lng: parseFloat( this.$map.attr('data-lng') )
        }

        this.map = new google.maps.Map( this.$map.get(0), {
            zoom: 16,
            center: this.location,
            mapTypeControl: false,
            fullscreenControl: false,
            streetViewControl: false,
            scrollwheel: false,
            zoomControl: false,
            clickableIcons: false,
            // disableDoubleClickZoom: true,
            styles: map_styles()
        })

        const Marker = require('../explore/map/marker.js')

        let marker = new Marker.default({
            id: 1,
            position: new google.maps.LatLng( this.location.lat, this.location.lng ),
            content: $('.ulz--marker').html(),
            map: this.map
        })

        this.init_zoom_controls()

	}

    init_zoom_controls() {

        $(`[data-action='explore-map-zoom-in']`, this.$).on('click', () => {
            var currentZoomLevel = this.map.getZoom()
            if( currentZoomLevel !== 21 ) {
                this.map.setZoom( currentZoomLevel + 1 )
            }
        })

        $(`[data-action='explore-map-zoom-out']`, this.$).on('click', () => {
            var currentZoomLevel = this.map.getZoom()
            if( currentZoomLevel !== 0 ) {
                this.map.setZoom( currentZoomLevel - 1 )
            }
        })

    }

}

/*
 * purchase
 *
 */
export class purchase extends action {

    init() {

        this.xhr = null

        $(`[data-id='addons']`).on('input', () => this.changed())
        $(`[data-action='purchase']`).on('click', () => this.purchase())

        this.changed()

	}

    changed() {

        if( this.xhr !== null ) {
            this.xhr.abort()
        }

        let addons = $(`[data-id='addons'] input`)
            .map(( index, e ) => {
                let $e = $(e)
                if( $e.is(':checked') ) {
                    let val = $e.val()
                    if( val.length ) {
                        return val;
                    }
                }
            }).get()

        this.xhr = $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-action-purchase-pricing',
                security: $('#security-action', this.$).val(),
                listing_id: window.utillz_core_vars.post_id,
                addons: addons,
            },
			beforeSend: () => {
                this.ajaxing()
                $('.ulz-action-pricing', this.$).html('')
				$('.ulz-error-holder', this.$).remove()
			},
			complete: () => {
                this.$.removeClass('ulz-ajaxing')
            },
			success: ( response ) => {

                this.xhr = null

				// success
				if( response.success ) {
                    $('.ulz-action-pricing', this.$).html( response.html )
				}

			}
        })

    }

    purchase() {

        if( this.$.hasClass('ulz-ajaxing') ) {
            return;
        }

        let data = {
            action: 'utillz-purchase',
            security: $('#security-action', this.$).val(),
            listing_id: window.utillz_core_vars.post_id,
        }

        let addons = $(`[data-id='addons'] input`)
            .map(( index, e ) => {
                let $e = $(e)
                if( $e.is(':checked') ) {
                    let val = $e.val()
                    if( val.length ) {
                        return val;
                    }
                }
            }).get()

        if( addons ) {
            data['addons'] = addons
        }

        $.ajax({
			type: 'post',
			dataType: 'json',
			url: window.utillz_core_vars.admin_ajax,
			data: data,
            beforeSend: () => {

                $('.ulz-action-success', this.$).removeClass('ulz-block')

                $('.ulz-error-holder', this.$).remove()
                this.ajaxing()

            },
            complete: () => {},
			success: response => {

                // success
                if( response.success ) {
                    if( response.redirect_url ) {
                        window.location.href = response.redirect_url
                    }else if( response.message ) {

                        this.$.removeClass('ulz-ajaxing')

                        // display success message
                        $('.ulz-action-success', this.$).addClass('ulz-block')
                            .html( response.message )

                    }
                }
                // error
                else{

                    this.$.removeClass('ulz-ajaxing')

                    // display error
                    $('.ulz-action-footer', this.$).append()
                        .append('<p class="ulz-error-holder"><span class="ulz-error">' + response.message + '</span></p>')

                }

			}
		})

    }

}
