'use strict'

import debug from '../utils/debug'
import escape from './escape'
import serialize from './serialize'
import dependency from './dependency'
// import * as _modules from './_modules'

window.$ = window.jQuery
window.Utillz_Core = window.Utillz_Core || {};

class Form {

	constructor() {

		debug.log('form', 'Constructor')

		this.base = require('./_base.js').default
        this.modules = require('./_modules.js')

		this.events()
	}

	events() {

		$(document).on('utillz:form/changed', () => this.collect())
		$(document).on('utillz:form/labels', () => this.labels())
		$(document).on('utillz:form/init', () => this.fields())

	}

	fields() {

		debug.log('form', 'Fields: init')

        $('.ulz-field').not('.ulz-field-ready').each(( index, element ) => {

            let $e = $( element )
            let type = $e.data('type')

			if( typeof type !== 'undefined' ) {
				type = type.replace(/-/ig, '_')
			}

            if( typeof this.modules[ type ] == 'function' ) {
				new this.modules[ type ]( $e ).start()
			}

			new dependency( $e )

        })

		$(document).trigger('utillz:form/labels')

    }

	truncate_string( str, num ) {
		num = num || 15
		if( str.length <= num || typeof str !== 'string' ) {
			return str
		}
		return str.slice( 0, num ) + '... '
	}

	labels() {

		debug.log('form', 'Collecting labels')

		$('.ulz-filter-tab').each(( index, e ) => {

			let labels = {}
			let field
			let $e = $(e)
			let $title = $('.ulz-tab-title', $e)
			let $flyout = $('.ulz-tab-flyout', $e)
			let label = null
			let heading = null

			$('.ulz-field', $flyout).each(( index, e ) => {

				let $field = $(e)
				let id = $field.data('id')

				if( typeof id !== 'undefined' ) {
					let type = $field.data('type')

					if( typeof type !== 'undefined' ) {
						type = type.replace(/-/ig, '_')
					}

					if( typeof this.modules[ type ] == 'function' ) {
						field = new this.modules[ type ]( $field )

						if( label = field.get_label() ) {
							heading = $field.find('.ulz-heading label:first').html()
							labels[ id ] = ( heading ? ( `<strong>${heading}:</strong>&nbsp;` ) : '' ) + this.truncate_string( label )
						}
					}
				}

			})

			let text = ''
			let more = 0
		    for( const [ key, val ] of Object.entries( labels ) ) {
		        if( val.length ) {
					if( ! text.length ) {
						text += `${val}`
					}else{
						more += 1
					}
		        }
		    }

			if( more > 0 ) {
				text += ` +${more}`;
			}

			if( Object.keys( labels ).length > 0 ) {
				$('span', $title).html( text )
				$e.addClass('ulz--selected')
			}else{
				$('span', $title).html( $title.data('label') )
				$e.removeClass('ulz--selected')
			}

		})

	}

	add_module( id, module ) {
        this.modules[ id ] = module
    }

	collect() {

		debug.log('form', 'Fields: collect data')

		$('.ulz-repeater-collect').each((index, element) => {

			let $repeater = $(element)
			let $input = $('>.ulz-repeater-value', $repeater)

			$input
				.val( JSON.stringify( this.repeater_items( $repeater ) ) )
				.trigger('input')

			$input.get(0).dispatchEvent( new Event('input') )

		})

	}

	repeater_items( repeater ) {

		let values = []

		$('>.ulz-repeater-items >.ulz-repeater-item', repeater).each(( index, element ) => {

			let item = $( element )

			values.push({
				template: {
					id: item.attr('data-id'),
					name: item.attr('data-name'),
					heading: item.attr('data-heading'),
					heading_text: escape( item.find('[name="' + item.attr('data-heading') + '"]:first').val() ),
				},
				fields: this.repeater_item_fields( item )
			})

		})

		return values

	}

	repeater_item_fields( item ) {

		let values = {}

		$('>.ulz-repeater-content >.ulz-form-group', item).each(( index, element ) => {

			let field = $( element )
			let id = field.attr('data-id')
			let type = field.attr('data-type')

			if( typeof type !== 'undefined' ) {
				type = type.replace(/-/ig, '_')
			}

			if( type == 'repeater' ) {
				values[ id ] = this.repeater_items( $('>.ulz-repeater', field) )
			}else{
				Object.assign( values, serialize( $('select, textarea, input', field), false, true ) )
			}

		})

		return values

	}

}

window.Utillz_Core.form = new Form()
