'use strict'

import debug from '../utils/debug'
import serialize from '../form/serialize'
import url from '../utils/url'
import inView from 'in-view'
import Map from './map/map'
import Box from './box'
import Dynamic from './dynamic'

window.$ = window.jQuery
window.Utillz_Core = window.Utillz_Core || {}

class Explore {

    constructor() {

        debug.log('explore', 'Constructor')

        $(document).ready(() => this.init())

	}

    init() {

        this.init_dynamic()
        this.init_map()
        this.init_listings()
        this.init_fields()
        this.init_paging()

        this.listings_in_view()

        $(document).on('click', '.ulz-action-filter', () => this.filtering())
        $(document).on('click', '[data-action="add-favorite"]', e => this.add_favorite(e))
        $(document).on('click', '.ulz-favorites-list .ulz-remove', e => this.remove_favorite(e))

		$(document).on('utillz:dynamic:done', () => this.load_more_popstate() )

    }

    init_map() {
        this.map = new Map
        $(window).trigger('utillz:explore/map')
    }

    init_dynamic() {
        this.dynamic = new Dynamic()
    }

    init_listings() {

        if( $('.ulz-listings').length ) {

            $('.ulz-listing').each(( index, e ) => {
                new Box( e )
            })
        }

    }

    init_fields() {
        window.Utillz_Core.form.fields()
    }

    get_filters() {
        let filters = serialize( $( 'input, textarea, select', $('.ulz-search-filter') ), true, true )
        let more = serialize( $( 'input, textarea, select', $('.ulz-modal-filters') ), true, true )
        return { ...filters, ...more }
    }

    filtering() {

        if( this.dynamic.is_explore ) {

            let all = this.get_filters()

            if( $(`.ulz-dynamic[data-dynamic='listings']`).length ) {

                this.dynamic.explore( all )

            }else{

                url.generate( all, window.utillz_core_vars.pages.explore )
                url.reload()

            }
        }

    }

    add_favorite(e) {

        e.preventDefault()

        let $e = $( e.currentTarget )

        if( $e.attr('href') !== '#' ) {
            return;
        }

        if( $e.hasClass('ulz-ajaxing') ) {
            return;
        }

        let id = $e.data('id')

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-add-favorite',
				id: id,
            },
			beforeSend: () => {

                $e.addClass('ulz-ajaxing')

			},
			complete: () => {

                $e.removeClass('ulz-ajaxing')

            },
			success: ( response ) => {

                $(`[data-action='add-favorite'][data-id='${id}']`).toggleClass('ulz--active')
                $(`.ulz-marker[data-id='${id}']`).toggleClass('ulz--is-fav')

			}
        })

    }

    remove_favorite(e) {

        let $trash = $( e.currentTarget )
        let id = $trash.data('id')
        let $list = $trash.closest('ul')
        let $listing = $(`.ulz-listing[data-id="${id}"]`)

        $trash.closest('li').remove()

        // empty
        if( ! $list.find('li').length ) {
            $('.ulz-modal[data-id="favorites"] .ulz--empty').removeClass('ulz-none')
        }
    }

    init_paging() {

        // load more
		$(document).on('click', `[data-action='load-more']`, e => {

			e.preventDefault()

			let $e = $(e.currentTarget)
			let page = parseInt( $e.attr('data-page') ) + 1
			this.$listings_loading = $e.closest('.ulz-explore-listings')

			if( $e.hasClass('ulz-ajaxing') ) {
				return;
			}

			let params = window.Utillz_Core.explore.get_filters()
			params.onpage = page

			let results = window.Utillz_Core.explore.dynamic.explore( params, null, true )

			$e.attr('data-page', page)

		})

		// infinity scroll
		let $infinity = $(`[data-action='infinity-scroll']`)
		if( $infinity.length ) {
			this.infinity_in_view()
			$(document).on('utillz:dynamic:done', () => {
				setTimeout(() => {
					this.infinity_in_view()
				}, 300 )
			})
		}

    }

	infinity_in_view() {
		inView( `[data-action='infinity-scroll']` )
			.once('enter', e => {
				let $button = $('.ulz-button:not(.ulz--disabled)', e)
				if( $button.length ) {
					$button.trigger('click')
				}
			})
	}

	load_more_popstate() {
        this.listings_in_view()
	}

    get_last_index() {

        let items = $('.ulz-listing-item')

        if( items.length ) {
            return items.length - 1
        }

        return 0;

    }

	handle_columns( response ) {

		let $column
        let index = this.get_last_index()
        let i = 0

		// masonry
		if( response.listings.includes('ulz-listings-columns') ) {
			$('.ulz-listing-item', response.listings).each(( i, e ) => {

				let $e = $(e)

                $e.attr('data-index', index + i + 1)
				$column = this.get_shortest_column()
				$column.find('.ulz-listings').append( $e )

			})
		}
		// grid
		else{
			$('.ulz-listings').append( $('.ulz-listing-item', response.listings) )
		}

		$('.ulz-load-more').replaceWith( $('.ulz-load-more', response.listings) )

	}

    get_shortest_column() {
		let cols = []
		$('.ulz-listings-column', this.$listings_loading).each((i, e) => {
			let $e = $(e)
			cols.push( $e.outerHeight() )
		})
		let max_index = cols.reduce(( max, x, i, arr ) => x < arr[max] ? i : max, 0 )
		return $('.ulz-listings-column', this.$listings_loading).eq( max_index )
	}

	listings_in_view() {

		inView('.ulz-listing-item .ulz--img:not(.ulz--ready)')
		    .on('enter', e => {
				let $e = $(e)
				let source = $e.attr('data-image')
				$(`<img scr="${source}">`).imagesLoaded(() => {
					$e.css('background-image', `url('${source}')`)
						.css('opacity', 1)
				})
				$e.addClass('ulz--ready')
			})
	}

}

window.Utillz_Core.explore = new Explore()
