'use strict'

import debug from '../utils/debug'
import url from '../utils/url'
import serialize from '../form/serialize'

export default class Dynamic {

	constructor() {

		debug.log('dynamic', 'Constructor')

		this.$b = $('body')
		this.is_back = false
		this.is_explore = !! $(`.ulz-dynamic[data-dynamic='listings']`).length

        $(document).on('click', 'a.ulz-action-dynamic-explore, li.ulz-action-dynamic-explore > a', e => this.request(e) )
        $(document).on('ulz-explore:request', () => this.request() )

		this.popstate()

    }

	popstate() {

		window.addEventListener('popstate', e => {
			this.is_back = true
			this.request()
		})

	}

    request(e) {

		if( this.is_explore ) {

            if(e) {
				e.preventDefault()
			}

			this.explore( url.query( e ? $( e.currentTarget ).attr('href') : window.location.href ) )

		}

	}

	explore( params, _url, _return ) {

		debug.log('dynamic', 'Dynamic: start')

		_url = _url || null
		_return = _return || false

		// this.is_type_present = params.type || null

		if( $('#ulz-explore').hasClass('ulz-ajaxing') ) {
            return
        }

		// inject listing type
        if( typeof params.type == 'undefined' && url.get('type') ) {
			params.type = url.get('type')
        }

		let is_explore_generated = url.generate( params, _url, false, this.is_back ) // set url with new params
		if( ! is_explore_generated ) {
			return
		}

		this.is_back = false

		// close infobox
		if(
			window.Utillz_Core.explore.map &&
			window.Utillz_Core.explore.map.infobox &&
			window.Utillz_Core.explore.map.infobox.is_open
		) {
			window.Utillz_Core.explore.map.infobox.close()
		}

		// close mobile expanded filter
        if( this.$b.hasClass('ulz--expand-search-filters') ) {
            this.$b.removeClass('ulz--expand-search-filters')
        }

		// primary
		if( $('.ulz-search-form').length ) {
			params.search_form_id = $('.ulz-search-form').attr('data-form-id')
		}

        params.action = 'utillz-dynamic-explore'
        params.post_id = window.utillz_core_vars.post_id

		$.ajax({
			type: 'get',
			dataType: 'json',
			url: window.utillz_core_vars.admin_ajax,
			data: params,
			beforeSend: () => {
                $('#ulz-explore').addClass('ulz-ajaxing')
            },
			success: ( response ) => {

				// if there is no map, create one
				if( ! window.Utillz_Core.explore.map ) {
					window.Utillz_Core.explore.init_map()
				}

				/*
				 * welcome
				 *
				 */
				if( window.Utillz_Core.explore.map ) {
					window.Utillz_Core.explore.map.show()
				}

				if( ! _return ) {

					/*
					 * title
					 *
					 */
					$(`.ulz-dynamic[data-dynamic='title']`).replaceWith( response.title )

					/*
					 * listings
					 *
					 */
					this.$listings = response.listings

					$(`.ulz-dynamic[data-dynamic='listings']`).empty().replaceWith( this.$listings )

					this.$listings = null

					if( response.listings ) {
						window.Utillz_Core.explore.init_listings()
					}

					/*
					 * map
					 *
					 */
					$(`.ulz-dynamic[data-dynamic='infoboxes']`).replaceWith( response.infoboxes )
					if( response.infoboxes ) {
						window.Utillz_Core.explore.map.init_infobox()
					}

					/*
					 * markers
					 *
					 */
					$(`.ulz-dynamic[data-dynamic='markers']`).replaceWith( response.markers )

					/*
					 * search forms
					 *
					 */

					// dynamic search forms
					$(`.ulz-dynamic[data-dynamic='filters']`).replaceWith( response.filters )

					// primary search form
					if( response.search_form ) {
						$(`.ulz-search-form[data-form-id='${response.search_form.form_id}']`).html( response.search_form.html )
					}

					// init fields
					window.Utillz_Core.form.fields()

				}

				/*
				 * finish
				 *
				 */
				$(document).trigger('utillz:dynamic/changed')

				// remove preloaders
				setTimeout(() => {

					$('#ulz-explore').removeClass('ulz-ajaxing')

					$('.ulz-search-form').removeClass('ulz-ajaxing')

					window.Utillz_Core.explore.map.init_markers()

				}, 20 )

				// set explore type
				this.$b.removeClass(( index, css ) => {
					return ( css.match(/(^|\s)ulz-explore-type--\S+/g) || [] ).join(' ')
				}).addClass(`ulz-explore-type--${response.type}`)

				// set explore columns
				this.$b.removeClass(( index, css ) => {
					return ( css.match(/(^|\s)ulz-explore-columns--\S+/g) || [] ).join(' ')
				}).addClass(`ulz-explore-columns--${response.columns}`)

				// set explore geo
				$('body')[ url.get('geo') ? 'addClass' : 'removeClass' ]('ulz--explore-geo')

				if( _return ) {
					window.Utillz_Core.explore.handle_columns( response )
				}

				// trigger
				$(document).trigger('utillz:dynamic:done')

			}
		});

	}

}
