'use strict'

import Mobile from './mobile'
import Modal from './modal/modal'
import url from './utils/url'
import serialize from './form/serialize'

window.$ = window.jQuery
window.Utillz_Core = window.Utillz_Core || {}

class Utillz_Core {

	constructor() {

		$(document).ready(() => this.ready())

	}

	ready() {

		this.init()

	}

	init() {

		this.bind()
		this.filters()
		this.search_form()

	}

	bind() {

		$(document).on('click', 'a[href="#"]', e => { e.preventDefault(); })
		$(document).on('click', '.ulz-toggler', e => this.toggle(e))

	}

	search_form() {

		$(document).on('submit', '.ulz-search-form form', e => {

			e.preventDefault()

			$(e.currentTarget).closest('.ulz-search-form').addClass('ulz-ajaxing')

			let params = serialize( $( 'input, textarea, select', $( e.currentTarget ) ), true, true )

			window.Utillz_Core.explore.dynamic.explore( params, window.utillz_core_vars.pages.explore )

			return

		})

	}

	toggle(e) {

		let $toggler = $( e.currentTarget )
		let $area = $(`[data-toggler="${$toggler.attr('data-for')}"]`)

		$toggler.toggleClass('ulz-open')

		if( $area.length ) {

			$area.toggleClass('ulz-area-closed')

			// open
			if( ! $area.hasClass('ulz-area-closed') ) {
				TweenLite.to(
					$area,
					.4,
					{ height: $area.children().outerHeight(), ease: Power3.easeOut, onComplete: () => {
						$area.css('height', 'auto')
					}}
				);
			}
			// close
			else{
				TweenLite.to(
					$area,
					.4,
					{ height: 0, ease: Power3.easeOut }
				)
			}

		}

	}

	filters() {

		this.tabs_init()

		$(document).on('ulz-filter-tabs:init, utillz:dynamic/changed', () => this.tabs_init() )
		$(document).on('click', '.ulz-tab-footer a', e => this.tabs_close(e) )

	}

	tabs_close(e) {
		$( e.currentTarget ).closest('.ulz-filter-tab').removeClass('ulz-expand')
		$('body').removeClass('ulz--is-flyout-expanded')
	}

	tabs_init() {

		$('.ulz-filter-tab').each(( index, element ) => {

			let $tab = $(element)

			$('.ulz-tab-title', $tab).on('click', e => {

				let $e = $( e.currentTarget )
				let $tab = $e.parent()

				$('.ulz-filter-tab .ulz-tab-title').not( $e ).parent().removeClass('ulz-expand')

				$tab.toggleClass('ulz-expand')
				$('body')[ $tab.hasClass('ulz-expand') ? 'addClass' : 'removeClass' ]('ulz--is-flyout-expanded')

				// close on click outside
				if( $tab.hasClass('ulz-expand') ) {
					$(document).on('mousedown.outside', e => {

						if ( ! $tab.is( e.target ) && $tab.has( e.target ).length === 0 ) {

							$tab.removeClass('ulz-expand')
							$('body').removeClass('ulz--is-flyout-expanded')
							$(document).off('mousedown.outside')

						}

					})
				}

			})

			$tab.addClass('ulz-ready')

		})

	}

}

new Utillz_Core()
