'use strict'

import debug from '../utils/debug'
window.Utillz_Core = window.Utillz_Core || {};

class Panel {

    constructor() {

        debug.log('panel', 'Constructor')

        Vue.config.devtools = window.utillz_core_vars.debug

        if( ! $('#ulz-panel').length ) {
            window.Utillz_Core.form.fields()
            return
        }

        this.components()
        this.app()
		this.gradient()
		this.development()
		this.split()
		this.webhooks()

    }

    app() {

        let _this = this

        new Vue({

            el: '#ulz-panel',

            data() {
                return {
                    ready: false,

                    tab: null,
                    tabMain: null,
                    tabSub: null,
                }
            },

            created() {

                if( window.location.hash ) {
                    this.tabClick( window.location.hash.substr(1), true )
                }

            },

            mounted() {

                if( this.tab == null ) {
                    this.tab = this.$el.getAttribute('data-tab-start')
                }

                this.tabClick( this.tab, true )
                this.parse()

                this.ready = true

            },

            methods: {

                parse: function() {

                    window.Utillz_Core.form.fields()

                },

                tabClick: function ( id, anchor ) {

                    if( id.includes('/') ) {

                        let splitted = id.split('/')
                        this.tab = splitted.join('/')
                        this.tabMain = splitted[0]
                        this.tabSub = splitted[1]

                    }else{

                        this.tab = id
                        this.tabMain = id
                        this.tabSub = null

                    }

                    if( typeof anchor == 'undefined' ) {
                        window.location.hash = id
                    }

                },

            }

        });

    }

    components() {

        Vue.component('ulz-preview-listing', {

            props: {
        		props: Object,
        	},

        	data () {

        		return {
                    type: this.props.type,
        			cover: this.props.cover,
        			style: this.props.style,
        			hide_listing_details: this.props.hide_listing_details,
        			favorite: this.props.favorite,
        			review: this.props.review,
        			title: this.props.title,
        			tagline: this.props.tagline,
        			bottom_labels: this.props.bottom_labels,
        			content: this.props.content,
        		}
        	},

            methods: {
                format_heading( format, text ) {
                    if( ! format ) {
                        return text
                    }
                    return format.replace( /%s/g, '<strong>' + text + '</strong>' )
                }
            }

        });

        Vue.component('ulz-preview-marker', {

            props: {
        		props: Object,
        	},

        	data () {
        		return {

                    type: this.props.type,
                    icon: this.props.icon,
                    image: this.props.image,
                    image_width: this.props.image_width,
                    field: this.props.field,
                    field_format: this.props.field_format,

        		}
        	},

            methods: {
                format_heading( format, text ) {
                    return format.replace( /%s/g, '<strong>' + text + '</strong>' )
                },
                get_image_thumb() {
                    return this.image
                },
            }

        });

    }

	gradient() {

        $(document).on('mousemove', '.ulz-shade', e => {
			let rect = e.currentTarget.getBoundingClientRect(),
				x = e.clientX - rect.left,
				y = e.clientY - rect.top

			e.currentTarget.style.setProperty('--x', `${x}px`)
			e.currentTarget.style.setProperty('--y', `${y}px`)
		})

	}

    development() {

        $(`[data-action='dev-export-options']`).on('click', e => {

            let $dev = $('.ulz-development')

            if( $dev.hasClass('ulz-ajaxing') ) {
                return;
            }

            $.ajax({
                type: 'post',
                dataType: 'json',
                url: window.utillz_core_vars.admin_ajax,
                data: {
                    action: 'utillz-dev-export-options',
                    perform: 'prepare',
    				demo: $(`input[name='demo']:checked`).val(),
                },
    			beforeSend: () => {
                    $dev.addClass('ulz-ajaxing')
    			},
    			complete: () => {
                    $dev.removeClass('ulz-ajaxing')
                },
    			success: ( response ) => {

                    $('#ulz-input-options-export').removeClass('ulz-none').find('textarea').val( response.output )

    			}
            })

        })

    }

    split() {

        let $splits = $('.ulz-settings-split')

        if( $splits.length ) {

            $splits.each(( index, element ) => {

                let $split = $(element)

                let $li = $('.ulz--sidebar li', $split)

                $li.on('click', e => {

                    let $e = $(e.currentTarget)
                    let id = $e.attr('data-for')

                    $li.removeClass('ulz--active')
                    $e.addClass('ulz--active')

                    $(`.ulz--section`, $split).removeClass('ulz--active')
                    $(`.ulz--section[data-id='${id}']`, $split).addClass('ulz--active')

                })

            })



        }

    }

    webhooks() {

        $(document).on('click', '[data-action="trigger-webhook"]', e => {

            let $e = $(e.currentTarget)

            if( $e.hasClass('ulz-ajaxing') ) {
                return;
            }

            let webhook_id = $e.attr('data-for')
            let webhook_url = $(`[name="ulz_${webhook_id}"]`).val()

            if( ! webhook_url.length ) {
                alert('Please enter a valid webhook url!')
                return;
            }

            $.ajax({
                type: 'post',
                dataType: 'json',
                url: window.utillz_core_vars.admin_ajax,
                data: {
                    action: 'utillz-trigger-webhook',
    				webhook_id: webhook_id,
    				webhook_url: webhook_url,
                },
    			beforeSend: () => {
                    $e.addClass('ulz-ajaxing')
    			},
    			complete: () => {
                    $e.removeClass('ulz-ajaxing')
                },
    			success: ( response ) => {

                    $('#ulz-input-options-export').removeClass('ulz-none').find('textarea').val( response.output )

    			}
            })

        })

    }

}

window.Utillz_Core.panel = new Panel()
