'use strict'

window.$ = window.jQuery

class Admin_Request {

    constructor( modal, params ) {

        this.$ = modal
        this.params = params
        this.$append = $('.ulz-modal-append', this.$)

    }

    init() {}
    close() {}

    ajaxing() {

        if( this.$.hasClass('ulz-ajaxing') ) {
            return
        }
		this.$.addClass('ulz-ajaxing')
        this.$append.html('')

    }

}

/*
 * listing edit
 *
 */
export class listing_edit extends Admin_Request {

    init() {}

    close() {}

}

/*
 * field icon
 *
 */
export class field_icon extends Admin_Request {

    init() {

        this.xhr = null

        if( this.$.hasClass('ulz-ajaxing') ) {
            return;
        }

        $(this.$).on('click', '.ulz--list li', e => this.select(e))

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-field-icon-content',
                set: this.params.set,
                icon: this.params.icon
            },
            beforeSend: () => {
                this.ajaxing()
            },
            success: response => {

                this.$append.html( response.html )
                this.$.removeClass('ulz-ajaxing')

                $(`input[type='radio']`).on('input', e => this.change_set(e))
                $(`input[type='text']`, this.$).on('input', e => this.search(e))
                $(`[data-action='icon-save']`, this.$).on('click', e => this.save(e))

                this.count_results()

            }
        })
    }

    select(e) {

        let $e = $(e.currentTarget)
        let icon = $e.attr('data-icon')

        $('li', this.$).removeClass('ulz--selected')
        $e.addClass('ulz--selected')

        $(`input[name='icon']`, this.$).val( icon )

    }

    change_set(e) {

        if( this.xhr !== null ) {
            this.xhr.abort()
        }

        $(`input[name='s']`, this.$).val('')

        this.xhr = $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.utillz_core_vars.admin_ajax,
            data: {
                action: 'utillz-field-icon-change-set',
                set: e.target.value,
                icon: $(`input[name='icon']`, this.$).val()
            },
            beforeSend: () => {
                this.$.addClass('ulz--loading-set')
            },
            success: response => {

                $('.ulz--list ul', this.$).html( response.html )
                this.$.removeClass('ulz--loading-set')

                this.count_results()

            }
        })

    }

    search(e) {

        let $icons = $('.ulz--list li', this.$)

        $icons[ e.target.value ? 'addClass' : 'removeClass' ]('ulz-none')
        if( e.target.value ) {
            $('li[data-icon*="' + e.target.value.toLowerCase() + '"]', this.$).removeClass('ulz-none')
        }

        this.count_results()

    }

    count_results() {

        let $e = $('.ulz--results', this.$)
        let results = $('.ulz--list li:not(.ulz-none)', this.$).length

        $e.html( $e.attr('data-text').replace('%s', results) )

    }

    save() {

        let set = $(`input[type='radio']:checked`, this.$).val()
        let icon = $(`input[name='icon']`, this.$).val()

        if( set.length && icon.length ) {
            $(document).trigger('utillz:icon/push', {
                set: set,
                icon: icon,
                preview: $('.ulz--list .ulz--selected').html()
            })
        }

        window.Utillz_Core.modal.close()

    }

    close() {
        this.$append.html('')
    }

}
