'use strict'

import debug from '../../utils/debug'
import * as Admin_Requests from './requests'

window.$ = window.jQuery
window.Utillz_Core = window.Utillz_Core || {}

class Admin_Modal {

    constructor() {

        this.requests = {}

        $(document).ready(() => this.ready())

    }

	ready() {

        debug.log('site', 'Admin modal: ready')

        this.$b = $('body')
        this.$overlay = $('.ulz-overlay')

        $(document).on('click', '[data-modal]', e => this.request(e))
        $(document).on('click', `[data-action='modal-close']`, () => this.close())

	}

    request(e) {

        e.preventDefault()

        let $e = $( e.currentTarget )
        let id = $e.data('modal')
        let params = $e.data('params')

        if( id ) {
            this.open( id, params )
        }

    }

    open( id, params ) {

        let $e = $(`.ulz-modal[data-id='${id}']`)

        if( $e.length ) {

            let request_id = id.split('-').join('_')

            // built-in
            if( typeof Admin_Requests[ request_id ] == 'function' ) {
                this.instance = new Admin_Requests[ request_id ]( $e, params )
                this.instance.init()
            }
            // external
            else if( typeof window.Utillz_Core.modal.requests[ request_id ] == 'function' ) {
                new window.Utillz_Core.modal.requests[ request_id ]( $e, params ).init()
            }

            $e.addClass('ulz-visible')
            $('body').addClass('ulz-modal-open')

        }else{
            console.log(`Modal '${id}' doesn't exists.`);
        }

    }

    close() {

        $('.ulz-modal.ulz-visible').each(( index, element ) => {

            let $e = $( element )
            let id = $e.data('id')

            if( id ) {
                let request_id = id.split('-').join('_');
                if( typeof Admin_Requests[ request_id ] == 'function' ) {
    				this.instance.close()
    			}
            }

            $e.removeClass('ulz-visible')

        })

        this.$b.removeClass('ulz-modal-open')

    }

}

window.Utillz_Core.modal = new Admin_Modal()
