'use strict'

import debug from '../utils/debug'
import Admin_Modal from './modal/modal'
import Queue from '../utils/queue'

window.$ = window.jQuery
window.Utillz_Core = window.Utillz_Core || {};

class Admin {

    constructor() {

        debug.log('admin', 'Constructor')

		$(document).ready(() => this.ready())

	}

	ready() {

        this.init()

	}

    init() {

		this.bind()
		this.importer()
		this.icon_set()

    }

	bind() {

		$(document).on('click', 'a[href="#"]', (e) => {
			e.preventDefault()
		})

        $(`[data-action='action-confirmation']`).on('click', e => {

            if( ! confirm( $(e.currentTarget).attr('data-confirmation-msg') ) ) {
                e.preventDefault()
            }
        })

	}

    importer() {

        let $import = $('.ulz-import')

        $(`[data-action='import-demos']`).on('click', e => {

            if( $import.hasClass('ulz-ajaxing') || $('body').hasClass('ulz-demo-importing') ) {
                return;
            }

            $.ajax({
                type: 'post',
                dataType: 'json',
                url: window.utillz_core_vars.admin_ajax,
                data: {
                    action: 'utillz-demo-import',
                    perform: 'prepare',
    				demo: $(`input[name='demo']:checked`).val(),
                },
    			beforeSend: () => {
                    $import.addClass('ulz-ajaxing')
    				$('.ulz--error', $import).remove()
                    $('.ulz-importer-progress').addClass('ulz-ajaxing')
                    $('.ulz-importer-progress .ulz--bar').css( 'width', 0 )
    			},
    			complete: () => {},
    			success: response => {

    				// success
    				if( response.success ) {

                        let call_index = 1

        				$('body').css('overflow-y', 'hidden')
                            .addClass('ulz-demo-importing')

                        let _queue = new Queue({
                            timeout: 3000,
                            ajaxSettings: {
                                type: 'post',
                                dataType: 'json',
                                url: window.utillz_core_vars.admin_ajax,
                            },
                            onStop: () => {

                                // ready
                                $('body').addClass('ulz--import-ready')
                                $('.ulz-importer-progress .ulz--title').html('All done!')

                            }
                        })

                        let i = 0
                        if( typeof response.queue !== 'undefined' && response.queue.length ) {
                            for( const call of response.queue ) {
                                _queue.add({
                                    beforeSend: () => {
                                        // ..
                                    },
                                    data: {
                                        action: 'utillz-demo-import',
                                        perform: call.perform,
                                        demo: $(`input[name='demo']:checked`).val(),
                                        index: i++
                                    },
                                    beforeSend: () => {
                                        this.progress( response.queue.length, call_index++ )
                                        $('.ulz-importer-progress .ulz--title').html( call.message )

                                    },
                                    success: res => {
                                        this.progress( response.queue.length, call_index )
                                    }
                                })
                            }
                        }
    				}
    				// error
    				else{

                        $('.ulz-importer-progress').removeClass('ulz-ajaxing')
                        $import.removeClass('ulz-ajaxing')

    					$('.ulz-demos ul').after(`<div class="ulz--error">
                            <div class="ulz--icon">
                                <i class="fas fa-frown-open"></i>
                            </div>
                            <div class="ulz--content">
                                ${response.error}
                            </div>
                        </div>`)

    				}

    			}
            })

        })

    }

    progress( index, length ) {
        $('.ulz-importer-progress .ulz--bar').css( 'width', ( 100 / index ) * length + '%' )
    }

    icon_set() {

        let $e = $('.ulz-upload-inline'),
            $label = $('.ulz--label', $e),
            $file = $('.ulz--file', $e)

        $('.ulz-button', $e).on('click', (e) => {
			$label.click()
		})

        $file.on('change', e => {
            $(`[name='icon-package-name']`, $e).val( e.target.files[0].name )
        })

		$(`[data-action='re-upload-set']`).on('click', (e) => {
			$('.ulz-reload-set').remove()
            $('.ulz-upload-inline').removeClass('ulz-none')
		})

    }

}

window.Utillz_Core.admin = new Admin()
