'use strict'

import debug from '../utils/debug'
import ApexCharts from 'apexcharts'
import chart_options from './chart-options'

window.$ = window.jQuery
window.Utillz_Core = window.Utillz_Core || {}

class Account {

    constructor() {

        debug.log('account', 'Constructor')

        $(document).ready(() => this.init())

	}

    init() {

        this.bind()
        this.dashboard_chart()
        this.table_click()

    }

    bind() {

        $('.ulz--toggle-active').on('click', (e) => {
            $(e.currentTarget).closest('.ulz-box').removeClass('ulz-active')
        })

        $(`[data-action='account-listing-delete']`).on('click', e => {

            if( ! confirm( $(e.currentTarget).attr('data-confirmation') ) ) {
                e.preventDefault()
            }
        })

    }

    dashboard_chart() {

        let $e = $('.ulz-chart[data-id="dashboard"]')

        if( $e.length ) {

            $.ajax({
                type: 'post',
                dataType: 'json',
                url: window.utillz_core_vars.admin_ajax,
                data: {
                    action: 'utillz-account-get-chart-views',
                },
    			beforeSend: () => {
    				$e.addClass('ulz-ajaxing')
    			},
    			complete: () => {
                    $e.removeClass('ulz-ajaxing')
                },
    			success: ( response ) => {

                    chart_options.series.push({
                        name: window.utillz_core_vars.localize.listing_views,
                        data: response.views
                    })
                    chart_options.xaxis.categories = response.dates
                    chart_options.chart.height = 260
                    chart_options.chart.type = 'bar'
                    chart_options.fill = {
                        type: 'gradient',
                        gradient: {
                            type: "vertical",
                            shadeIntensity: 0,
                            gradientToColors: [ 'var( --primary )' ],
                            inverseColors: true,
                            opacityFrom: .2,
                            opacityTo: .2,
                            stops: [0, 100],
                        }
                    }
                    chart_options.stroke = {
                        show: true,
                        width: 2,
                        colors: ['var( --primary )'],
                    }

                    let chart = new ApexCharts( $e.get(0), chart_options )
                    chart.render()

    			}
            })

        }

    }

    table_click() {

        $('.ulz-boxes-table tr').on('click', e => {
            let $click = $(e.currentTarget).find('.ulz--click')
            if( $click.length && typeof $(e.target).attr('href') == 'undefined' && ! $(e.target).closest('a').length ) {

                e.preventDefault()
                $click.trigger('click')
            }
        })

    }

}

window.Utillz_Core.account = new Account()
