'use strict'

import 'jquery-debouncedresize'

window.$ = window.jQuery
window.Utillz_Enhance = window.Utillz_Enhance || {}

class Utillz_Enhance {

	constructor() {

		$(document).ready(() => this.ready())

	}

	ready() {

		this.$body = $('body')
		this.$w = $(window)
		this.logged_in = this.$body.hasClass('logged-in')

		this.init()

	}

	init() {

		this.bind()
		this.actions()
		this.collections()

		this.elementor()

	}

	bind() {

		$(document).on('click', 'a[href="#"]', e => { e.preventDefault() })

	}

	ajaxing( $e ) {

        if( $e.hasClass('ulz-ajaxing') ) {
            return
        }
		$e.addClass('ulz-ajaxing')

    }

	actions() {

		$(document).on('change', `[name='ulz_download_plan']`, e => {

			let $action = $('.ulz-mod-action-download')
			let download_data = window.utilities_vars.action_download_data[ e.target.value ]

			$('.ulz-action-price', $action)[ download_data.price == 0 ? 'addClass' : 'removeClass' ]('ulz--free')
			$('.ulz--price', $action).html( download_data.price_html )
			$('.ulz--info', $action).html( download_data.description )

		})

		// plans toggle
		$(document).on('click', '.ulz-download-plans .ulz-section-toggle', e => {

			let $toggle = $(e.currentTarget)
			let section_primary = $toggle.attr('data-section-primary')
			let section_secondary = $toggle.attr('data-section-secondary')
			let $plans = $(`.ulz--section[data-id='${section_primary}']`)
			let $subscriptions = $(`.ulz--section[data-id='${section_secondary}']`)

			$toggle.toggleClass('ulz--active')
			$plans.toggleClass('ulz--active')
			$subscriptions.toggleClass('ulz--active')

		})

		$(document).on('click', `[data-action='action-download']`, () => {

			let $action = $('.ulz-mod-action-download')

			// if you are not logged in, then
			// request user account for not-freebies
			if( ! this.logged_in && ! $(`[name='download_plan']:checked`).closest('label').hasClass('freebie') ) {
				window.Utillz_Core.modal.open('signin')
				return
			}

			$.ajax({
				type: 'post',
				dataType: 'json',
				url: window.utillz_core_vars.admin_ajax,
				data: {
		            action: 'utillz-action-download',
		            security: window.utillz_core_vars.nonce,
		            listing_id: parseInt( $(`[name='ulz_download_listing_id']`).val() ),
		            plan: $(`[name='download_plan']:checked`).val(),
		        },
	            beforeSend: () => {

	                $('.ulz-error-holder', this.$).remove()
	                this.ajaxing( $action )

	            },
	            complete: () => {
					 $action.removeClass('ulz-ajaxing')
				},
				success: response => {

	                // success
	                if( response.success ) {
	                    if( response.redirect_url ) {
	                        window.location.href = response.redirect_url
	                    }else if( response.message ) {

	                        $action.removeClass('ulz-ajaxing')

	                        /*
							 * push to download
							 *
							 */
							$('#ulz-download-iframe').remove()

							let $iframe = $('<iframe id="ulz-download-iframe" class="ulz-none">')
							$iframe.attr('src', response.download_url)
							$iframe.appendTo( this.$body )

	                    }
	                }
	                // error
	                else{

	                    $action.removeClass('ulz-ajaxing')

						let txt = document.createElement('textarea');
					    txt.innerHTML = response.message

						alert( txt.value )

	                }

				}
			})

		})

	}

	collections() {
		this.collection_thumbs()
	}

	collection_thumbs() {

		let calculate_width = function( $thumbs ) {

			let rail_width = 0
			$('.ulz--cell', $thumbs).each((i, e ) => {
				rail_width += $(e).outerWidth()
			})

			if( $thumbs.outerWidth() < rail_width ) {
				$thumbs.addClass('ulz--is-first')
			}

			$thumbs[ $thumbs.outerWidth() < rail_width ? 'addClass' : 'removeClass' ]('ulz--scroll')

		}

		$('.ulz-collections--thumbs').each((index, element) => {
			let $thumbs = $(element)
			let $scroll = $('.ulz--inner', $thumbs)
			let $nav = $('.ulz-nav-shadow', $thumbs)

			calculate_width( $thumbs )
			this.$w.on('debouncedresize', () => {
				calculate_width( $thumbs )
			})

			$nav.on('click', e => {
				let $e = $(e.currentTarget)
				let direction = $e.attr('data-direction')
				let scroll = $scroll.scrollLeft()
				let displacement = 600

				let length = $scroll.get(0).scrollWidth
				let left = length - $scroll.width() - scroll

				// $thumbs.removeClass('ulz--is-last ulz--is-first')

				if( direction == 'next' && left <= displacement ) {
					displacement = left
					// $thumbs.addClass('ulz--is-last')
				}

				if( direction == 'prev' && scroll <= displacement ) {
					displacement = scroll
					// $thumbs.addClass('ulz--is-first')
				}

				TweenMax.to(
					$scroll,
					.5,
					{ scrollTo: { x: $scroll.scrollLeft() + ( displacement * ( direction == 'next' ? 1 : -1 ) ) }, ease: Circ.easeOut }
				)

			})

			$scroll.on('scroll', e => {
				let $e = $(e.currentTarget)
				let scroll = $scroll.scrollLeft()

				let length = $scroll.get(0).scrollWidth
				let left = length - $scroll.width() - scroll

				if( scroll <= 0 ) {
					$thumbs.addClass('ulz--is-first')
					$thumbs.removeClass('ulz--is-last')
				}else{
					$thumbs.addClass('ulz--is-last')
				}

				if( left <= 0 ) {
					$thumbs.addClass('ulz--is-last')
					$thumbs.removeClass('ulz--is-first')
				}else{
					$thumbs.addClass('ulz--is-first')
				}

			})
		})

	}

	elementor() {

		this.elementor_toggle()

	}

	elementor_toggle() {

		$('.elementor-page .ulz-section-toggle').each((index, e) => {

			let $toggle = $(e)
			let section_primary = $toggle.attr('data-section-primary')
			let section_secondary = $toggle.attr('data-section-secondary')
			let $primary = $(`#${section_primary}`)
			let $secondary = $(`#${section_secondary}`)

			$secondary.addClass('ulz-none')

			$toggle.on('click', () => {
				$toggle.toggleClass('ulz--active')
				$primary.toggleClass('ulz-none')
				$secondary.toggleClass('ulz-none')
			})
		})

	}

}

window.Utillz_Enhance = new Utillz_Enhance()
