/*!
 * SyntaxHighlighter
 * https://github.com/syntaxhighlighter/syntaxhighlighter
 * 
 * SyntaxHighlighter is donationware. If you are using it, please donate.
 * http://alexgorbatchev.com/SyntaxHighlighter/donate.html
 * 
 * @version
 * 4.0.1 (Fri, 19 May 2017 16:29:38 GMT)
 * 
 * @copyright
 * Copyright (C) 2004-2016 Alex Gorbatchev.
 * 
 * @license
 * Dual licensed under the MIT and GPL licenses.
 */
(function(c){var d={};function __webpack_require__(a){if(d[a])return d[a].exports;var b=d[a]={exports:{},id:a,loaded:false};c[a].call(b.exports,b,b.exports,__webpack_require__);b.loaded=true;return b.exports}__webpack_require__.m=c;__webpack_require__.c=d;__webpack_require__.p="";return __webpack_require__(0)})([(function(d,e,f){'use strict';Object.defineProperty(e,"__esModule",{value:true});var g=f(1);Object.keys(g).forEach(function(a){if(a==="default"||a==="__esModule")return;Object.defineProperty(e,a,{enumerable:true,get:function get(){return g[a]}})});var h=f(52);var i=_interopRequireDefault(h);var j=_interopRequireDefault(g);var k=f(53);var l=_interopRequireWildcard(k);function _interopRequireWildcard(a){if(a&&a.__esModule){return a}else{var b={};if(a!=null){for(var c in a){if(Object.prototype.hasOwnProperty.call(a,c))b[c]=a[c]}}b.default=a;return b}}function _interopRequireDefault(a){return a&&a.__esModule?a:{default:a}}if(false){require('./compatibility_layer_v3')}(0,i.default)(function(){return j.default.highlight(l.object(window.syntaxhighlighterConfig||{}))})}),(function(f,g,h){'use strict';Object.defineProperty(g,"__esModule",{value:true});var j=h(2),match=h(5),Renderer=h(9).default,utils=h(10),transformers=h(11),dom=h(17),config=h(18),defaults=h(19),HtmlScript=h(20);var k={Match:match.Match,Highlighter:h(22),config:h(18),regexLib:h(3).commonRegExp,vars:{discoveredBrushes:null,highlighters:{}},brushes:{},findElements:function findElements(a,b){var c=b?[b]:utils.toArray(document.getElementsByTagName(k.config.tagName)),conf=k.config,result=[];c=c.concat(dom.getSyntaxHighlighterScriptTags());if(c.length===0)return result;for(var i=0,l=c.length;i<l;i++){var d={target:c[i],params:j.defaults(j.parse(c[i].className),a)};if(d.params['brush']==null)continue;result.push(d)}return result},highlight:function highlight(a,b){var c=k.findElements(a,b),propertyName='innerHTML',brush=null,renderer,conf=k.config;if(c.length===0)return;for(var i=0,l=c.length;i<l;i++){var b=c[i],target=b.target,params=b.params,brushName=params.brush,brush,matches,code;if(brushName==null)continue;brush=findBrush(brushName);if(!brush)continue;params=j.defaults(params||{},defaults);params=j.defaults(params,config);if(params['html-script']==true||defaults['html-script']==true){brush=new HtmlScript(findBrush('xml'),brush);brushName='htmlscript'}else{brush=new brush()}code=target[propertyName];if(conf.useScriptTags)code=stripCData(code);if((target.title||'')!='')params.title=target.title;params['brush']=brushName;code=transformers(code,params);matches=match.applyRegexList(code,brush.regexList,params);renderer=new Renderer(code,matches,params);b=dom.create('div');b.innerHTML=renderer.getHtml();if(params.quickCode)dom.attachEvent(dom.findElement(b,'.code'),'dblclick',dom.quickCodeHandler);if((target.id||'')!='')b.id=target.id;target.parentNode.replaceChild(b,target)}}};function alert(a){window.alert('SyntaxHighlighter\n\n'+a)};function findBrush(a,b){var c=k.vars.discoveredBrushes,result=null;if(c==null){c={};for(var d in k.brushes){var e=k.brushes[d],aliases=e.aliases;if(aliases==null){continue}e.className=e.className||e.aliases[0];e.brushName=e.className||d.toLowerCase();for(var i=0,l=aliases.length;i<l;i++){c[aliases[i]]=d}}k.vars.discoveredBrushes=c}result=k.brushes[c[a]];if(result==null&&b)alert(k.config.strings.noBrush+a);return result};function stripCData(a){var b='<![CDATA[',right=']]>',copy=utils.trim(a),changed=false,leftLength=b.length,rightLength=right.length;if(copy.indexOf(b)==0){copy=copy.substring(leftLength);changed=true}var c=copy.length;if(copy.indexOf(right)==c-rightLength){copy=copy.substring(0,c-rightLength);changed=true}return changed?copy:a};var m=0;g.default=k;var n=g.registerBrush=function n(a){return k.brushes['brush'+m++]=a.default||a};var o=g.clearRegisteredBrushes=function o(){k.brushes={};m=0};n(h(23));n(h(24));n(h(22));n(h(25));n(h(26));n(h(27));n(h(28));n(h(29));n(h(30));n(h(31));n(h(32));n(h(33));n(h(34));n(h(35));n(h(36));n(h(37));n(h(38));n(h(39));n(h(40));n(h(41));n(h(42));n(h(43));n(h(44));n(h(45));n(h(46));n(h(47));n(h(48));n(h(49));n(h(50));n(h(51))}),(function(d,e,f){'use strict';var g=f(3).XRegExp;var h={'true':true,'false':false};function camelize(c){return c.replace(/-(\w+)/g,function(a,b){return b.charAt(0).toUpperCase()+b.substr(1)})}function process(a){var b=h[a];return b==null?a:b}d.exports={defaults:function defaults(a,b){for(var c in b||{}){if(!a.hasOwnProperty(c))a[c]=a[camelize(c)]=b[c]}return a},parse:function parse(a){var b,key,result={},arrayRegex=g("^\\[(?<values>(.*?))\\]$"),pos=0,regex=g("(?<name>[\\w-]+)"+"\\s*:\\s*"+"(?<value>"+"[\\w%#-]+|"+"\\[.*?\\]|"+'".*?"|'+"'.*?'"+")\\s*;?","g");while((b=g.exec(a,regex,pos))!=null){var c=b.value.replace(/^['"]|['"]$/g,'');if(c!=null&&arrayRegex.test(c)){var m=g.exec(c,arrayRegex);c=m.values.length>0?m.values.split(/\s*,\s*/):[]}c=process(c);result[b.name]=result[camelize(b.name)]=c;pos=b.index+b[0].length}return result}}}),(function(b,c,d){'use strict';Object.defineProperty(c,"__esModule",{value:true});c.commonRegExp=c.XRegExp=undefined;var e=d(4);var f=_interopRequireDefault(e);function _interopRequireDefault(a){return a&&a.__esModule?a:{default:a}}c.XRegExp=f.default;var g=c.commonRegExp={multiLineCComments:(0,f.default)('/\\*.*?\\*/','gs'),singleLineCComments:/\/\/.*$/gm,singleLinePerlComments:/#.*$/gm,doubleQuotedString:/"([^\\"\n]|\\.)*"/g,singleQuotedString:/'([^\\'\n]|\\.)*'/g,multiLineDoubleQuotedString:(0,f.default)('"([^\\\\"]|\\\\.)*"','gs'),multiLineSingleQuotedString:(0,f.default)("'([^\\\\']|\\\\.)*'",'gs'),xmlComments:(0,f.default)('(&lt;|<)!--.*?--(&gt;|>)','gs'),url:/\w+:\/\/[\w-.\/?%&=:@;#]*/g,phpScriptTags:{left:/(&lt;|<)\?(?:=|php)?/g,right:/\?(&gt;|>)/g,'eof':true},aspScriptTags:{left:/(&lt;|<)%=?/g,right:/%(&gt;|>)/g},scriptScriptTags:{left:/(&lt;|<)\s*script.*?(&gt;|>)/gi,right:/(&lt;|<)\/\s*script\s*(&gt;|>)/gi}}}),(function(h,j){'use strict';var k='xregexp';var l={astral:false,natives:false};var m={exec:RegExp.prototype.exec,test:RegExp.prototype.test,match:String.prototype.match,replace:String.prototype.replace,split:String.prototype.split};var o={};var q={};var s={};var u=[];var v='default';var w='class';var x={'default':/\\(?:0(?:[0-3][0-7]{0,2}|[4-7][0-7]?)?|[1-9]\d*|x[\dA-Fa-f]{2}|u(?:[\dA-Fa-f]{4}|{[\dA-Fa-f]+})|c[A-Za-z]|[\s\S])|\(\?[:=!]|[?*+]\?|{\d+(?:,\d*)?}\??|[\s\S]/,'class':/\\(?:[0-3][0-7]{0,2}|[4-7][0-7]?|x[\dA-Fa-f]{2}|u(?:[\dA-Fa-f]{4}|{[\dA-Fa-f]+})|c[A-Za-z]|[\s\S])|[\s\S]/};var y=/\$(?:{([\w$]+)}|(\d\d?|[\s\S]))/g;var z=m.exec.call(/()??/,'')[1]===undefined;var A=function(){var a=true;try{new RegExp('','u')}catch(exception){a=false}return a}();var B=function(){var a=true;try{new RegExp('','y')}catch(exception){a=false}return a}();var C=/a/.flags!==undefined;var D={g:true,i:true,m:true,u:A,y:B};var toString={}.toString;function augment(a,b,c,d,e){var p;a[k]={captureNames:b};if(e){return a}if(a.__proto__){a.__proto__=XRegExp.prototype}else{for(p in XRegExp.prototype){a[p]=XRegExp.prototype[p]}}a[k].source=c;a[k].flags=d?d.split('').sort().join(''):d;return a}function clipDuplicates(a){return m.replace.call(a,/([\s\S])(?=[\s\S]*\1)/g,'')}function copyRegex(a,b){if(!XRegExp.isRegExp(a)){throw new TypeError('Type RegExp expected');}var c=a[k]||{},flags=getNativeFlags(a),flagsToAdd='',flagsToRemove='',xregexpSource=null,xregexpFlags=null;b=b||{};if(b.removeG){flagsToRemove+='g'}if(b.removeY){flagsToRemove+='y'}if(flagsToRemove){flags=m.replace.call(flags,new RegExp('['+flagsToRemove+']+','g'),'')}if(b.addG){flagsToAdd+='g'}if(b.addY){flagsToAdd+='y'}if(flagsToAdd){flags=clipDuplicates(flags+flagsToAdd)}if(!b.isInternalOnly){if(c.source!==undefined){xregexpSource=c.source}if(c.flags!=null){xregexpFlags=flagsToAdd?clipDuplicates(c.flags+flagsToAdd):c.flags}}a=augment(new RegExp(a.source,flags),hasNamedCapture(a)?c.captureNames.slice(0):null,xregexpSource,xregexpFlags,b.isInternalOnly);return a}function dec(a){return parseInt(a,16)}function getNativeFlags(a){return C?a.flags:m.exec.call(/\/([a-z]*)$/i,RegExp.prototype.toString.call(a))[1]}function hasNamedCapture(a){return!!(a[k]&&a[k].captureNames)}function hex(a){return parseInt(a,10).toString(16)}function indexOf(a,b){var c=a.length,i;for(i=0;i<c;++i){if(a[i]===b){return i}}return-1}function isType(a,b){return toString.call(a)==='[object '+b+']'}function isQuantifierNext(a,b,c){return m.test.call(c.indexOf('x')>-1?/^(?:\s+|#.*|\(\?#[^)]*\))*(?:[?*+]|{\d+(?:,\d*)?})/:/^(?:\(\?#[^)]*\))*(?:[?*+]|{\d+(?:,\d*)?})/,a.slice(b))}function pad4(a){while(a.length<4){a='0'+a}return a}function prepareFlags(c,d){var i;if(clipDuplicates(d)!==d){throw new SyntaxError('Invalid duplicate regex flag '+d);}c=m.replace.call(c,/^\(\?([\w$]+)\)/,function(a,b){if(m.test.call(/[gy]/,b)){throw new SyntaxError('Cannot use flag g or y in mode modifier '+a);}d=clipDuplicates(d+b);return''});for(i=0;i<d.length;++i){if(!D[d.charAt(i)]){throw new SyntaxError('Unknown regex flag '+d.charAt(i));}}return{pattern:c,flags:d}}function prepareOptions(b){var c={};if(isType(b,'String')){XRegExp.forEach(b,/[^\s,]+/,function(a){c[a]=true});return c}return b}function registerFlag(a){if(!/^[\w$]$/.test(a)){throw new Error('Flag must be a single character A-Za-z0-9_$');}D[a]=true}function runTokens(a,b,c,d,e){var i=u.length,leadChar=a.charAt(c),result=null,match,t;while(i--){t=u[i];if(t.leadChar&&t.leadChar!==leadChar||t.scope!==d&&t.scope!=='all'||t.flag&&b.indexOf(t.flag)===-1){continue}match=XRegExp.exec(a,t.regex,c,'sticky');if(match){result={matchLength:match[0].length,output:t.handler.call(e,match,d,b),reparse:t.reparse};break}}return result}function setAstral(a){l.astral=a}function setNatives(a){RegExp.prototype.exec=(a?o:m).exec;RegExp.prototype.test=(a?o:m).test;String.prototype.match=(a?o:m).match;String.prototype.replace=(a?o:m).replace;String.prototype.split=(a?o:m).split;l.natives=a}function toObject(a){if(a==null){throw new TypeError('Cannot convert null or undefined to object');}return a}function XRegExp(a,b){var c={hasNamedCapture:false,captureNames:[]},scope=v,output='',pos=0,result,token,generated,appliedPattern,appliedFlags;if(XRegExp.isRegExp(a)){if(b!==undefined){throw new TypeError('Cannot supply flags when copying a RegExp');}return copyRegex(a)}a=a===undefined?'':String(a);b=b===undefined?'':String(b);if(XRegExp.isInstalled('astral')&&b.indexOf('A')===-1){b+='A'}if(!s[a]){s[a]={}}if(!s[a][b]){result=prepareFlags(a,b);appliedPattern=result.pattern;appliedFlags=result.flags;while(pos<appliedPattern.length){do{result=runTokens(appliedPattern,appliedFlags,pos,scope,c);if(result&&result.reparse){appliedPattern=appliedPattern.slice(0,pos)+result.output+appliedPattern.slice(pos+result.matchLength)}}while(result&&result.reparse);if(result){output+=result.output;pos+=result.matchLength||1}else{token=XRegExp.exec(appliedPattern,x[scope],pos,'sticky')[0];output+=token;pos+=token.length;if(token==='['&&scope===v){scope=w}else if(token===']'&&scope===w){scope=v}}}s[a][b]={pattern:m.replace.call(output,/\(\?:\)(?:[*+?]|\{\d+(?:,\d*)?})?\??(?=\(\?:\))|^\(\?:\)(?:[*+?]|\{\d+(?:,\d*)?})?\??|\(\?:\)(?:[*+?]|\{\d+(?:,\d*)?})?\??$/g,''),flags:m.replace.call(appliedFlags,/[^gimuy]+/g,''),captures:c.hasNamedCapture?c.captureNames:null}}generated=s[a][b];return augment(new RegExp(generated.pattern,generated.flags),generated.captures,a,b)};XRegExp.prototype=new RegExp();XRegExp.version='3.1.0-dev';XRegExp.addToken=function(a,b,c){c=c||{};var d=c.optionalFlags,i;if(c.flag){registerFlag(c.flag)}if(d){d=m.split.call(d,'');for(i=0;i<d.length;++i){registerFlag(d[i])}}u.push({regex:copyRegex(a,{addG:true,addY:B,isInternalOnly:true}),handler:b,scope:c.scope||v,flag:c.flag,reparse:c.reparse,leadChar:c.leadChar});XRegExp.cache.flush('patterns')};XRegExp.cache=function(a,b){if(!q[a]){q[a]={}}return q[a][b]||(q[a][b]=XRegExp(a,b))};XRegExp.cache.flush=function(a){if(a==='patterns'){s={}}else{q={}}};XRegExp.escape=function(a){return m.replace.call(toObject(a),/[-[\]{}()*+?.,\\^$|#\s]/g,'\\$&')};XRegExp.exec=function(a,b,c,d){var e='g',addY=false,match,r2;addY=B&&!!(d||b.sticky&&d!==false);if(addY){e+='y'}b[k]=b[k]||{};r2=b[k][e]||(b[k][e]=copyRegex(b,{addG:true,addY:addY,removeY:d===false,isInternalOnly:true}));r2.lastIndex=c=c||0;match=o.exec.call(r2,a);if(d&&match&&match.index!==c){match=null}if(b.global){b.lastIndex=match?r2.lastIndex:0}return match};XRegExp.forEach=function(a,b,c){var d=0,i=-1,match;while(match=XRegExp.exec(a,b,d)){c(match,++i,a,b);d=match.index+(match[0].length||1)}};XRegExp.globalize=function(a){return copyRegex(a,{addG:true})};XRegExp.install=function(a){a=prepareOptions(a);if(!l.astral&&a.astral){setAstral(true)}if(!l.natives&&a.natives){setNatives(true)}};XRegExp.isInstalled=function(a){return!!l[a]};XRegExp.isRegExp=function(a){return toString.call(a)==='[object RegExp]'};XRegExp.match=function(a,b,c){var d=b.global&&c!=='one'||c==='all',cacheKey=(d?'g':'')+(b.sticky?'y':'')||'noGY',result,r2;b[k]=b[k]||{};r2=b[k][cacheKey]||(b[k][cacheKey]=copyRegex(b,{addG:!!d,addY:!!b.sticky,removeG:c==='one',isInternalOnly:true}));result=m.match.call(toObject(a),r2);if(b.global){b.lastIndex=c==='one'&&result?result.index+result[0].length:0}return d?result||[]:result&&result[0]};XRegExp.matchChain=function(e,f){return function recurseChain(b,c){var d=f[c].regex?f[c]:{regex:f[c]},matches=[],addMatch=function addMatch(a){if(d.backref){if(!(a.hasOwnProperty(d.backref)||+d.backref<a.length)){throw new ReferenceError('Backreference to undefined group: '+d.backref);}matches.push(a[d.backref]||'')}else{matches.push(a[0])}},i;for(i=0;i<b.length;++i){XRegExp.forEach(b[i],d.regex,addMatch)}return c===f.length-1||!matches.length?matches:recurseChain(matches,c+1)}([e],0)};XRegExp.replace=function(a,b,c,d){var e=XRegExp.isRegExp(b),global=b.global&&d!=='one'||d==='all',cacheKey=(global?'g':'')+(b.sticky?'y':'')||'noGY',s2=b,result;if(e){b[k]=b[k]||{};s2=b[k][cacheKey]||(b[k][cacheKey]=copyRegex(b,{addG:!!global,addY:!!b.sticky,removeG:d==='one',isInternalOnly:true}))}else if(global){s2=new RegExp(XRegExp.escape(String(b)),'g')}result=o.replace.call(toObject(a),s2,c);if(e&&b.global){b.lastIndex=0}return result};XRegExp.replaceEach=function(a,b){var i,r;for(i=0;i<b.length;++i){r=b[i];a=XRegExp.replace(a,r[0],r[1],r[2])}return a};XRegExp.split=function(a,b,c){return o.split.call(toObject(a),b,c)};XRegExp.test=function(a,b,c,d){return!!XRegExp.exec(a,b,c,d)};XRegExp.uninstall=function(a){a=prepareOptions(a);if(l.astral&&a.astral){setAstral(false)}if(l.natives&&a.natives){setNatives(false)}};XRegExp.union=function(e,f){var g=/(\()(?!\?)|\\([1-9]\d*)|\\[\s\S]|\[(?:[^\\\]]|\\[\s\S])*]/g,output=[],numCaptures=0,numPriorCaptures,captureNames,pattern,rewrite=function rewrite(a,b,c){var d=captureNames[numCaptures-numPriorCaptures];if(b){++numCaptures;if(d){return'(?<'+d+'>'}}else if(c){return'\\'+(+c+numPriorCaptures)}return a},i;if(!(isType(e,'Array')&&e.length)){throw new TypeError('Must provide a nonempty array of patterns to merge');}for(i=0;i<e.length;++i){pattern=e[i];if(XRegExp.isRegExp(pattern)){numPriorCaptures=numCaptures;captureNames=pattern[k]&&pattern[k].captureNames||[];output.push(m.replace.call(XRegExp(pattern.source).source,g,rewrite))}else{output.push(XRegExp.escape(pattern))}}return XRegExp(output.join('|'),f)};o.exec=function(b){var c=this.lastIndex,match=m.exec.apply(this,arguments),name,r2,i;if(match){if(!z&&match.length>1&&indexOf(match,'')>-1){r2=copyRegex(this,{removeG:true,isInternalOnly:true});m.replace.call(String(b).slice(match.index),r2,function(){var a=arguments.length,i;for(i=1;i<a-2;++i){if(arguments[i]===undefined){match[i]=undefined}}})}if(this[k]&&this[k].captureNames){for(i=1;i<match.length;++i){name=this[k].captureNames[i-1];if(name){match[name]=match[i]}}}if(this.global&&!match[0].length&&this.lastIndex>match.index){this.lastIndex=match.index}}if(!this.global){this.lastIndex=c}return match};o.test=function(a){return!!o.exec.call(this,a)};o.match=function(a){var b;if(!XRegExp.isRegExp(a)){a=new RegExp(a)}else if(a.global){b=m.match.apply(this,arguments);a.lastIndex=0;return b}return o.exec.call(a,toObject(this))};o.replace=function(e,f){var g=XRegExp.isRegExp(e),origLastIndex,captureNames,result;if(g){if(e[k]){captureNames=e[k].captureNames}origLastIndex=e.lastIndex}else{e+=''}if(isType(f,'Function')){result=m.replace.call(String(this),e,function(){var a=arguments,i;if(captureNames){a[0]=new String(a[0]);for(i=0;i<captureNames.length;++i){if(captureNames[i]){a[0][captureNames[i]]=a[i+1]}}}if(g&&e.global){e.lastIndex=a[a.length-2]+a[0].length}return f.apply(undefined,a)})}else{result=m.replace.call(this==null?this:String(this),e,function(){var d=arguments;return m.replace.call(String(f),y,function(a,b,c){var n;if(b){n=+b;if(n<=d.length-3){return d[n]||''}n=captureNames?indexOf(captureNames,b):-1;if(n<0){throw new SyntaxError('Backreference to undefined group '+a);}return d[n+1]||''}if(c==='$'){return'$'}if(c==='&'||+c===0){return d[0]}if(c==='`'){return d[d.length-1].slice(0,d[d.length-2])}if(c==="'"){return d[d.length-1].slice(d[d.length-2]+d[0].length)}c=+c;if(!isNaN(c)){if(c>d.length-3){throw new SyntaxError('Backreference to undefined group '+a);}return d[c]||''}throw new SyntaxError('Invalid token '+a);})})}if(g){if(e.global){e.lastIndex=0}else{e.lastIndex=origLastIndex}}return result};o.split=function(b,c){if(!XRegExp.isRegExp(b)){return m.split.apply(this,arguments)}var d=String(this),output=[],origLastIndex=b.lastIndex,lastLastIndex=0,lastLength;c=(c===undefined?-1:c)>>>0;XRegExp.forEach(d,b,function(a){if(a.index+a[0].length>lastLastIndex){output.push(d.slice(lastLastIndex,a.index));if(a.length>1&&a.index<d.length){Array.prototype.push.apply(output,a.slice(1))}lastLength=a[0].length;lastLastIndex=a.index+lastLength}});if(lastLastIndex===d.length){if(!m.test.call(b,'')||lastLength){output.push('')}}else{output.push(d.slice(lastLastIndex))}b.lastIndex=origLastIndex;return output.length>c?output.slice(0,c):output};XRegExp.addToken(/\\([ABCE-RTUVXYZaeg-mopqyz]|c(?![A-Za-z])|u(?![\dA-Fa-f]{4}|{[\dA-Fa-f]+})|x(?![\dA-Fa-f]{2}))/,function(a,b){if(a[1]==='B'&&b===v){return a[0]}throw new SyntaxError('Invalid escape '+a[0]);},{scope:'all',leadChar:'\\'});XRegExp.addToken(/\\u{([\dA-Fa-f]+)}/,function(a,b,c){var d=dec(a[1]);if(d>0x10FFFF){throw new SyntaxError('Invalid Unicode code point '+a[0]);}if(d<=0xFFFF){return'\\u'+pad4(hex(d))}if(A&&c.indexOf('u')>-1){return a[0]}throw new SyntaxError('Cannot use Unicode code point above \\u{FFFF} without flag u');},{scope:'all',leadChar:'\\'});XRegExp.addToken(/\[(\^?)]/,function(a){return a[1]?'[\\s\\S]':'\\b\\B';},{leadChar:'['});XRegExp.addToken(/\(\?#[^)]*\)/,function(a,b,c){return isQuantifierNext(a.input,a.index+a[0].length,c)?'':'(?:)';},{leadChar:'('});XRegExp.addToken(/\s+|#.*/,function(a,b,c){return isQuantifierNext(a.input,a.index+a[0].length,c)?'':'(?:)';},{flag:'x'});XRegExp.addToken(/\./,function(){return'[\\s\\S]';},{flag:'s',leadChar:'.'});XRegExp.addToken(/\\k<([\w$]+)>/,function(a){var b=isNaN(a[1])?indexOf(this.captureNames,a[1])+1:+a[1],endIndex=a.index+a[0].length;if(!b||b>this.captureNames.length){throw new SyntaxError('Backreference to undefined group '+a[0]);}return'\\'+b+(endIndex===a.input.length||isNaN(a.input.charAt(endIndex))?'':'(?:)');},{leadChar:'\\'});XRegExp.addToken(/\\(\d+)/,function(a,b){if(!(b===v&&/^[1-9]/.test(a[1])&&+a[1]<=this.captureNames.length)&&a[1]!=='0'){throw new SyntaxError('Cannot use octal escape or backreference to undefined group '+a[0]);}return a[0];},{scope:'all',leadChar:'\\'});XRegExp.addToken(/\(\?P?<([\w$]+)>/,function(a){if(!isNaN(a[1])){throw new SyntaxError('Cannot use integer as capture name '+a[0]);}if(a[1]==='length'||a[1]==='__proto__'){throw new SyntaxError('Cannot use reserved word as capture name '+a[0]);}if(indexOf(this.captureNames,a[1])>-1){throw new SyntaxError('Cannot use same name for multiple groups '+a[0]);}this.captureNames.push(a[1]);this.hasNamedCapture=true;return'(';},{leadChar:'('});XRegExp.addToken(/\((?!\?)/,function(a,b,c){if(c.indexOf('n')>-1){return'(?:';}this.captureNames.push(null);return'(';},{optionalFlags:'n',leadChar:'('});h.exports=XRegExp;}),(function(b,c,d){'use strict';Object.defineProperty(c,"__esModule",{value:true});var e=d(6);Object.keys(e).forEach(function(a){if(a==="default"||a==="__esModule")return;Object.defineProperty(c,a,{enumerable:true,get:function get(){return e[a];}});});var f=d(7);Object.keys(f).forEach(function(a){if(a==="default"||a==="__esModule")return;Object.defineProperty(c,a,{enumerable:true,get:function get(){return f[a];}});});}),(function(d,e){"use strict";Object.defineProperty(e,"__esModule",{value:true});var f=function(){function defineProperties(a,b){for(var i=0;i<b.length;i++){var c=b[i];c.enumerable=c.enumerable||false;c.configurable=true;if("value"in c)c.writable=true;Object.defineProperty(a,c.key,c);}}return function(a,b,c){if(b)defineProperties(a.prototype,b);if(c)defineProperties(a,c);return a;};}();function _classCallCheck(a,b){if(!(a instanceof b)){throw new TypeError("Cannot call a class as a function");}}var g=e.Match=function(){function g(a,b,c){_classCallCheck(this,g);this.value=a;this.index=b;this.length=a.length;this.css=c;this.brushName=null;}f(g,[{key:"toString",value:function toString(){return this.value;}}]);return g;}();}),(function(d,e,f){'use strict';Object.defineProperty(e,"__esModule",{value:true});var g=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(a){return typeof a;}:function(a){return a&&typeof Symbol==="function"&&a.constructor===Symbol&&a!==Symbol.prototype?"symbol":typeof a;};e.applyRegexList=applyRegexList;var h=f(8);function applyRegexList(a,b){var c=[];b=b||[];for(var i=0,l=b.length;i<l;i++){if(g(b[i])==='object')c=c.concat((0,h.find)(a,b[i]));}c=(0,h.sort)(c);c=(0,h.removeNested)(c);c=(0,h.compact)(c);return c;}}),(function(g,h,k){'use strict';Object.defineProperty(h,"__esModule",{value:true});h.find=find;h.sort=sort;h.compact=compact;h.removeNested=removeNested;var m=k(6);var n=k(3);function find(c,d){function defaultAdd(a,b){return a[0];};var e=0,match=null,matches=[],process=d.func?d.func:defaultAdd,pos=0;while(match=n.XRegExp.exec(c,d.regex,pos)){var f=process(match,d);if(typeof f==='string')f=[new m.Match(f,match.index,d.css)];matches=matches.concat(f);pos=match.index+match[0].length;}return matches;};function sort(c){function sortMatchesCallback(a,b){if(a.index<b.index)return-1;else if(a.index>b.index)return 1;else{if(a.length<b.length)return-1;else if(a.length>b.length)return 1;}return 0;}return c.sort(sortMatchesCallback);}function compact(a){var b=[],i,l;for(i=0,l=a.length;i<l;i++){if(a[i])b.push(a[i]);}return b;}function removeNested(a){for(var i=0,l=a.length;i<l;i++){if(a[i]===null)continue;var b=a[i],itemIEndPos=b.index+b.length;for(var j=i+1,l=a.length;j<l&&a[i]!==null;j++){var c=a[j];if(c===null)continue;else if(c.index>itemIEndPos)break;else if(c.index==b.index&&c.length>b.length)a[i]=null;else if(c.index>=b.index&&c.index<itemIEndPos)a[j]=null;}}return a;}}),(function(f,g){'use strict';Object.defineProperty(g,"__esModule",{value:true});g.default=Renderer;function padNumber(a,b){var c=a.toString();while(c.length<b){c='0'+c;}return c;};function getLines(a){return a.split(/\r?\n/);}function getLinesToHighlight(a){var b={},linesToHighlight,l,i;linesToHighlight=a.highlight||[];if(typeof linesToHighlight.push!=='function')linesToHighlight=[linesToHighlight];for(i=0,l=linesToHighlight.length;i<l;i++){b[linesToHighlight[i]]=true;}return b;}function Renderer(a,b,c){var d=this;d.opts=c;d.code=a;d.matches=b;d.lines=getLines(a);d.linesToHighlight=getLinesToHighlight(c);}Renderer.prototype={wrapLinesWithCode:function wrapLinesWithCode(a,b){if(a==null||a.length==0||a=='\n'||b==null)return a;var c=this,results=[],lines,line,spaces,i,l;a=a.replace(/</g,'&lt;');a=a.replace(/ {2,}/g,function(m){spaces='';for(i=0,l=m.length;i<l-1;i++){spaces+=c.opts.space;}return spaces+' ';});lines=getLines(a);for(i=0,l=lines.length;i<l;i++){line=lines[i];spaces='';if(line.length>0){line=line.replace(/^(&nbsp;| )+/,function(s){spaces=s;return'';});line=line.length===0?spaces:spaces+'<code class="'+b+'">'+line+'</code>';}results.push(line);}return results.join('\n');},processUrls:function processUrls(b){var c=/(.*)((&gt;|&lt;).*)/,url=/\w+:\/\/[\w-.\/?%&=:@;#]*/g;return b.replace(url,function(m){var a='',match=null;if(match=c.exec(m)){m=match[1];a=match[2];}return'<a href="'+m+'">'+m+'</a>'+a;});},figureOutLineNumbers:function figureOutLineNumbers(a){var b=[],lines=this.lines,firstLine=parseInt(this.opts.firstLine||1),i,l;for(i=0,l=lines.length;i<l;i++){b.push(i+firstLine);}return b;},wrapLine:function wrapLine(a,b,c){var d=['line','number'+b,'index'+a,'alt'+(b%2==0?1:2).toString()];if(this.linesToHighlight[b])d.push('highlighted');if(b==0)d.push('break');return'<div class="'+d.join(' ')+'">'+c+'</div>';},renderLineNumbers:function renderLineNumbers(a,b){var c=this,opts=c.opts,html='',count=c.lines.length,firstLine=parseInt(opts.firstLine||1),pad=opts.padLineNumbers,lineNumber,i;if(pad==true)pad=(firstLine+count-1).toString().length;else if(isNaN(pad)==true)pad=0;for(i=0;i<count;i++){lineNumber=b?b[i]:firstLine+i;a=lineNumber==0?opts.space:padNumber(lineNumber,pad);html+=c.wrapLine(i,lineNumber,a);}return html;},getCodeLinesHtml:function getCodeLinesHtml(a,b){var c=this,opts=c.opts,lines=getLines(a),padLength=opts.padLineNumbers,firstLine=parseInt(opts.firstLine||1),brushName=opts.brush,a='';for(var i=0,l=lines.length;i<l;i++){var d=lines[i],indent=/^(&nbsp;|\s)+/.exec(d),spaces=null,lineNumber=b?b[i]:firstLine+i;;if(indent!=null){spaces=indent[0].toString();d=d.substr(spaces.length);spaces=spaces.replace(' ',opts.space);}if(d.length==0)d=opts.space;a+=c.wrapLine(i,lineNumber,(spaces!=null?'<code class="'+brushName+' spaces">'+spaces+'</code>':'')+d);}return a;},getTitleHtml:function getTitleHtml(a){return a?'<caption>'+a+'</caption>':'';},getMatchesHtml:function getMatchesHtml(c,d){function getBrushNameCss(a){var b=a?a.brushName||brushName:brushName;return b?b+' ':'';};var e=this,pos=0,result='',brushName=e.opts.brush||'',match,matchBrushName,i,l;for(i=0,l=d.length;i<l;i++){match=d[i];if(match===null||match.length===0)continue;matchBrushName=getBrushNameCss(match);result+=e.wrapLinesWithCode(c.substr(pos,match.index-pos),matchBrushName+'plain')+e.wrapLinesWithCode(match.value,matchBrushName+match.css);pos=match.index+match.length+(match.offset||0);}result+=e.wrapLinesWithCode(c.substr(pos),getBrushNameCss()+'plain');return result;},getHtml:function getHtml(){var a=this,opts=a.opts,code=a.code,matches=a.matches,classes=['syntaxhighlighter'],lineNumbers,gutter,html;if(opts.collapse===true)classes.push('collapsed');gutter=opts.gutter!==false;if(!gutter)classes.push('nogutter');classes.push(opts.className);classes.push(opts.brush);if(gutter)lineNumbers=a.figureOutLineNumbers(code);html=a.getMatchesHtml(code,matches);html=a.getCodeLinesHtml(html,lineNumbers);if(opts.autoLinks)html=a.processUrls(html);html='\n      <div class="'+classes.join(' ')+'">\n        <table border="0" cellpadding="0" cellspacing="0">\n          '+a.getTitleHtml(opts.title)+'\n          <tbody>\n            <tr>\n              '+(gutter?'<td class="gutter">'+a.renderLineNumbers(code)+'</td>':'')+'\n              <td class="code">\n                <div class="container">'+html+'</div>\n              </td>\n            </tr>\n          </tbody>\n        </table>\n      </div>\n    ';return html;}};}),(function(d,e){'use strict';function splitLines(a){return a.split(/\r?\n/);}function eachLine(a,b){var c=splitLines(a);for(var i=0,l=c.length;i<l;i++){c[i]=b(c[i],i);}return c.join('\n');}function guid(a){return(a||'')+Math.round(Math.random()*1000000).toString();}function merge(a,b){var c={},name;for(name in a){c[name]=a[name];}for(name in b){c[name]=b[name];}return c;}function trim(a){return a.replace(/^\s+|\s+$/g,'');}function toArray(a){return Array.prototype.slice.apply(a);}function toBoolean(a){var b={"true":true,"false":false}[a];return b==null?a:b;}d.exports={splitLines:splitLines,eachLine:eachLine,guid:guid,merge:merge,trim:trim,toArray:toArray,toBoolean:toBoolean};}),(function(d,e,f){'use strict';var g=f(12),bloggerMode=f(13),stripBrs=f(14),unindenter=f(15),retabber=f(16);d.exports=function(a,b){a=g(a,b);a=bloggerMode(a,b);a=stripBrs(a,b);a=unindenter.unindent(a,b);var c=b['tab-size'];a=b['smart-tabs']===true?retabber.smart(a,c):retabber.regular(a,c);return a;};}),(function(c,d){'use strict';c.exports=function(a,b){return a.replace(/^[ ]*[\n]+|[\n]*[ ]*$/g,'').replace(/\r/g,' ');};}),(function(d,e){'use strict';d.exports=function(a,b){var c=/<br\s*\/?>|&lt;br\s*\/?&gt;/gi;if(b['bloggerMode']===true)a=a.replace(c,'\n');return a;};}),(function(d,e){'use strict';d.exports=function(a,b){var c=/<br\s*\/?>|&lt;br\s*\/?&gt;/gi;if(b['stripBrs']===true)a=a.replace(c,'');return a;};}),(function(c,d){'use strict';function isEmpty(a){return(/^\s*$/.test(a));}c.exports={unindent:function unindent(a){var b=a.split(/\r?\n/),regex=/^\s*/,min=1000,line,matches,i,l;for(i=0,l=b.length;i<l&&min>0;i++){line=b[i];if(isEmpty(line))continue;matches=regex.exec(line);if(matches==null)return a;min=Math.min(matches[0].length,min);}if(min>0)for(i=0,l=b.length;i<l;i++){if(!isEmpty(b[i]))b[i]=b[i].substr(min);}return b.join('\n');}};}),(function(d,e){'use strict';var f='';for(var i=0;i<50;i++){f+='                    ';}function insertSpaces(a,b,c){return a.substr(0,b)+f.substr(0,c)+a.substr(b+1,a.length);}d.exports={smart:function smart(a,b){var c=a.split(/\r?\n/),tab='\t',line,pos,i,l;for(i=0,l=c.length;i<l;i++){line=c[i];if(line.indexOf(tab)===-1)continue;pos=0;while((pos=line.indexOf(tab))!==-1){line=insertSpaces(line,pos,b-pos%b);}c[i]=line;}return c.join('\n');},regular:function regular(a,b){return a.replace(/\t/g,f.substr(0,b));}};}),(function(g,h){'use strict';function getSyntaxHighlighterScriptTags(){var a=document.getElementsByTagName('script'),result=[];for(var i=0;i<a.length;i++){if(a[i].type=='text/syntaxhighlighter'||a[i].type=='syntaxhighlighter')result.push(a[i]);}return result;};function hasClass(a,b){return a.className.indexOf(b)!=-1;}function addClass(a,b){if(!hasClass(a,b))a.className+=' '+b;}function removeClass(a,b){a.className=a.className.replace(b,'');}function attachEvent(a,b,c,d){function handler(e){e=e||window.event;if(!e.target){e.target=e.srcElement;e.preventDefault=function(){this.returnValue=false;};}c.call(d||window,e);};if(a.attachEvent){a.attachEvent('on'+b,handler);}else{a.addEventListener(b,handler,false);}}function findElement(a,b,c){if(a==null)return null;var d=c!=true?a.childNodes:[a.parentNode],propertyToFind={'#':'id','.':'className'}[b.substr(0,1)]||'nodeName',expectedValue,found;expectedValue=propertyToFind!='nodeName'?b.substr(1):b.toUpperCase();if((a[propertyToFind]||'').indexOf(expectedValue)!=-1)return a;for(var i=0,l=d.length;d&&i<l&&found==null;i++){found=findElement(d[i],b,c);}return found;}function findParentElement(a,b){return findElement(a,b,true);}function popup(a,b,c,d,e){var x=(screen.width-c)/2,y=(screen.height-d)/2;e+=', left='+x+', top='+y+', width='+c+', height='+d;e=e.replace(/^,/,'');var f=window.open(a,b,e);f.focus();return f;}function getElementsByTagName(a){return document.getElementsByTagName(a);}function findElementsToHighlight(a){var b=getElementsByTagName(a['tagName']),scripts,i;if(a['useScriptTags']){scripts=getElementsByTagName('script');for(i=0;i<scripts.length;i++){if(scripts[i].type.match(/^(text\/)?syntaxhighlighter$/))b.push(scripts[i]);}}return b;}function create(a){return document.createElement(a);}function quickCodeHandler(e){var a=e.target,highlighterDiv=findParentElement(a,'.syntaxhighlighter'),container=findParentElement(a,'.container'),textarea=document.createElement('textarea'),highlighter;if(!container||!highlighterDiv||findElement(container,'textarea'))return;addClass(highlighterDiv,'source');var b=container.childNodes,code=[];for(var i=0,l=b.length;i<l;i++){code.push(b[i].innerText||b[i].textContent);}code=code.join('\r');code=code.replace(/\u00a0/g," ");textarea.readOnly=true;textarea.appendChild(document.createTextNode(code));container.appendChild(textarea);textarea.focus();textarea.select();attachEvent(textarea,'blur',function(e){textarea.parentNode.removeChild(textarea);removeClass(highlighterDiv,'source');});};g.exports={quickCodeHandler:quickCodeHandler,create:create,popup:popup,hasClass:hasClass,addClass:addClass,removeClass:removeClass,attachEvent:attachEvent,findElement:findElement,findParentElement:findParentElement,getSyntaxHighlighterScriptTags:getSyntaxHighlighterScriptTags,findElementsToHighlight:findElementsToHighlight};}),(function(a,b){'use strict';a.exports={space:'&nbsp;',useScriptTags:true,bloggerMode:false,stripBrs:false,tagName:'pre'};}),(function(a,b){'use strict';a.exports={'class-name':'','first-line':1,'pad-line-numbers':false,'highlight':null,'title':null,'smart-tabs':true,'tab-size':4,'gutter':true,'quick-code':true,'collapse':false,'auto-links':true,'unindent':true,'html-script':false};}),(function(k,m,n){(function(h){'use strict';var i=n(5).applyRegexList;function HtmlScript(e,f){var g,xmlBrush=new e();if(f==null)return;g=new f();if(g.htmlScript==null)throw new Error('Brush wasn\'t configured for html-script option: '+f.brushName);xmlBrush.regexList.push({regex:g.htmlScript.code,func:h});this.regexList=xmlBrush.regexList;function offsetMatches(a,b){for(var j=0,l=a.length;j<l;j++){a[j].index+=b}}function h(b,c){var d=b.code,results=[],regexList=g.regexList,offset=b.index+b.left.length,htmlScript=g.htmlScript,matches;function add(a){results=results.concat(a)}matches=i(d,regexList);offsetMatches(matches,offset);add(matches);if(htmlScript.left!=null&&b.left!=null){matches=i(b.left,[htmlScript.left]);offsetMatches(matches,b.index);add(matches)}if(htmlScript.right!=null&&b.right!=null){matches=i(b.right,[htmlScript.right]);offsetMatches(matches,b.index+b[0].lastIndexOf(b.right));add(matches)}for(var j=0,l=results.length;j<l;j++){results[j].brushName=f.brushName}return results}};k.exports=HtmlScript}.call(m,n(21)))}),(function(c,d){'use strict';var f=c.exports={};var g;var h;function defaultSetTimout(){throw new Error('setTimeout has not been defined');}function defaultClearTimeout(){throw new Error('clearTimeout has not been defined');}(function(){try{if(typeof setTimeout==='function'){g=setTimeout}else{g=defaultSetTimout}}catch(e){g=defaultSetTimout}try{if(typeof clearTimeout==='function'){h=clearTimeout}else{h=defaultClearTimeout}}catch(e){h=defaultClearTimeout}})();function runTimeout(a){if(g===setTimeout){return setTimeout(a,0)}if((g===defaultSetTimout||!g)&&setTimeout){g=setTimeout;return setTimeout(a,0)}try{return g(a,0)}catch(e){try{return g.call(null,a,0)}catch(e){return g.call(this,a,0)}}}function runClearTimeout(a){if(h===clearTimeout){return clearTimeout(a)}if((h===defaultClearTimeout||!h)&&clearTimeout){h=clearTimeout;return clearTimeout(a)}try{return h(a)}catch(e){try{return h.call(null,a)}catch(e){return h.call(this,a)}}}var j=[];var k=false;var l;var m=-1;function cleanUpNextTick(){if(!k||!l){return}k=false;if(l.length){j=l.concat(j)}else{m=-1}if(j.length){drainQueue()}}function drainQueue(){if(k){return}var a=runTimeout(cleanUpNextTick);k=true;var b=j.length;while(b){l=j;j=[];while(++m<b){if(l){l[m].run()}}m=-1;b=j.length}l=null;k=false;runClearTimeout(a)}f.nextTick=function(a){var b=new Array(arguments.length-1);if(arguments.length>1){for(var i=1;i<arguments.length;i++){b[i-1]=arguments[i]}}j.push(new Item(a,b));if(j.length===1&&!k){runTimeout(drainQueue)}};function Item(a,b){this.fun=a;this.array=b}Item.prototype.run=function(){this.fun.apply(null,this.array)};f.title='browser';f.browser=true;f.env={};f.argv=[];f.version='';f.versions={};function noop(){}f.on=noop;f.addListener=noop;f.once=noop;f.off=noop;f.removeListener=noop;f.removeAllListeners=noop;f.emit=noop;f.prependListener=noop;f.prependOnceListener=noop;f.listeners=function(a){return[]};f.binding=function(a){throw new Error('process.binding is not supported');};f.cwd=function(){return'/'};f.chdir=function(a){throw new Error('process.chdir is not supported');};f.umask=function(){return 0}}),(function(e,f,g){'use strict';var h=function(){function defineProperties(a,b){for(var i=0;i<b.length;i++){var c=b[i];c.enumerable=c.enumerable||false;c.configurable=true;if("value"in c)c.writable=true;Object.defineProperty(a,c.key,c)}}return function(a,b,c){if(b)defineProperties(a.prototype,b);if(c)defineProperties(a,c);return a}}();var j=g(9);var k=_interopRequireDefault(j);var l=g(3);var m=g(5);function _interopRequireDefault(a){return a&&a.__esModule?a:{default:a}}function _classCallCheck(a,b){if(!(a instanceof b)){throw new TypeError("Cannot call a class as a function");}}e.exports=function(){function BrushBase(){_classCallCheck(this,BrushBase)}h(BrushBase,[{key:'getKeywords',value:function getKeywords(a){var b=a.replace(/^\s+|\s+$/g,'').replace(/\s+/g,'|');return'\\b(?:'+b+')\\b'}},{key:'forHtmlScript',value:function forHtmlScript(a){var b={'end':a.right.source};if(a.eof){b.end='(?:(?:'+b.end+')|$)'}this.htmlScript={left:{regex:a.left,css:'script'},right:{regex:a.right,css:'script'},code:(0,l.XRegExp)("(?<left>"+a.left.source+")"+"(?<code>.*?)"+"(?<right>"+b.end+")","sgi")}}},{key:'getHtml',value:function getHtml(a){var b=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var c=(0,m.applyRegexList)(a,this.regexList);var d=new k.default(a,c,b);return d.getHtml()}}]);return BrushBase}()}),(function(d,e,f){'use strict';var g=f(22);var h=f(3).commonRegExp;function Brush(){var a='after before beginning continue copy each end every from return get global in local named of set some that the then times to where whose with without';var b='first second third fourth fifth sixth seventh eighth ninth tenth last front back middle';var c='activate add alias ask attachment boolean class constant delete duplicate empty exists id integer list make message modal modified new no pi properties quit real record remove rest result reveal reverse run running save string word yes';this.regexList=[{regex:/(--|#).*$/gm,css:'comments'},{regex:/\(\*(?:[\s\S]*?\(\*[\s\S]*?\*\))*[\s\S]*?\*\)/gm,css:'comments'},{regex:/"[\s\S]*?"/gm,css:'string'},{regex:/(?:,|:|¬|'s\b|\(|\)|\{|\}|«|\b\w*»)/g,css:'color1'},{regex:/(-)?(\d)+(\.(\d)?)?(E\+(\d)+)?/g,css:'color1'},{regex:/(?:&(amp;|gt;|lt;)?|=|� |>|<|≥|>=|≤|<=|\*|\+|-|\/|÷|\^)/g,css:'color2'},{regex:/\b(?:and|as|div|mod|not|or|return(?!\s&)(ing)?|equals|(is(n't| not)? )?equal( to)?|does(n't| not) equal|(is(n't| not)? )?(greater|less) than( or equal( to)?)?|(comes|does(n't| not) come) (after|before)|is(n't| not)?( in)? (back|front) of|is(n't| not)? behind|is(n't| not)?( (in|contained by))?|does(n't| not) contain|contain(s)?|(start|begin|end)(s)? with|((but|end) )?(consider|ignor)ing|prop(erty)?|(a )?ref(erence)?( to)?|repeat (until|while|with)|((end|exit) )?repeat|((else|end) )?if|else|(end )?(script|tell|try)|(on )?error|(put )?into|(of )?(it|me)|its|my|with (timeout( of)?|transaction)|end (timeout|transaction))\b/g,css:'keyword'},{regex:/\b\d+(st|nd|rd|th)\b/g,css:'keyword'},{regex:/\b(?:about|above|against|around|at|below|beneath|beside|between|by|(apart|aside) from|(instead|out) of|into|on(to)?|over|since|thr(ough|u)|under)\b/g,css:'color3'},{regex:/\b(?:adding folder items to|after receiving|clipboard info|set the clipboard to|(the )?clipboard|entire contents|document( (edited|file|nib name))?|file( (name|type))?|(info )?for|giving up after|(name )?extension|return(ed)?|second(?! item)(s)?|list (disks|folder)|(Unicode )?text|(disk )?item(s)?|((current|list) )?view|((container|key) )?window|case|diacriticals|hyphens|numeric strings|punctuation|white space|folder creation|application(s( folder)?| (processes|scripts position|support))?|((desktop )?(pictures )?|(documents|downloads|favorites|home|keychain|library|movies|music|public|scripts|sites|system|users|utilities|workflows) )folder|desktop|Folder Action scripts|font(s| panel)?|help|internet plugins|modem scripts|(system )?preferences|printer descriptions|scripting (additions|components)|shared (documents|libraries)|startup (disk|items)|temporary items|trash|on server|in AppleTalk zone|((as|long|short) )?user name|user (ID|locale)|(with )?password|in (bundle( with identifier)?|directory)|(close|open for) access|read|write( permission)?|(g|s)et eof|starting at|hidden( answer)?|open(ed| (location|untitled))?|error (handling|reporting)|administrator privileges|altering line endings|get volume settings|(alert|boot|input|mount|output|set) volume|output muted|(fax|random )?number|round(ing)?|up|down|toward zero|to nearest|as taught in school|system (attribute|info)|((AppleScript( Studio)?|system) )?version|(home )?directory|(IPv4|primary Ethernet) address|CPU (type|speed)|physical memory|time (stamp|to GMT)|replacing|ASCII (character|number)|localized string|from table|offset|summarize|beep|delay|say|(empty|multiple) selections allowed|(of|preferred) type|invisibles|showing( package contents)?|editable URL|(File|FTP|News|Media|Web) [Ss]ervers|Telnet hosts|Directory services|Remote applications|waiting until completion|saving( (in|to))?|path (for|to( (((current|frontmost) )?application|resource))?)|(background|RGB) color|(OK|cancel) button name|cancel button|button(s)?|cubic ((centi)?met(re|er)s|yards|feet|inches)|square ((kilo)?met(re|er)s|miles|yards|feet)|(centi|kilo)?met(re|er)s|miles|yards|feet|inches|lit(re|er)s|gallons|quarts|(kilo)?grams|ounces|pounds|degrees (Celsius|Fahrenheit|Kelvin)|print( (dialog|settings))?|clos(e(able)?|ing)|(de)?miniaturized|miniaturizable|zoom(ed|able)|attribute run|action (method|property|title)|phone|email|((start|end)ing|home) page|((birth|creation|current|custom|modification) )?date|((((phonetic )?(first|last|middle))|computer|host|maiden|related) |nick)?name|aim|icq|jabber|msn|yahoo|address(es)?|save addressbook|should enable action|city|country( code)?|formatte(r|d address)|(palette )?label|state|street|zip|AIM [Hh]andle(s)?|my card|select(ion| all)?|unsaved|(alpha )?value|entr(y|ies)|(ICQ|Jabber|MSN) handle|person|people|company|department|icon image|job title|note|organization|suffix|vcard|url|copies|collating|pages (across|down)|request print time|target( printer)?|((GUI Scripting|Script menu) )?enabled|show Computer scripts|(de)?activated|awake from nib|became (key|main)|call method|of (class|object)|center|clicked toolbar item|closed|for document|exposed|(can )?hide|idle|keyboard (down|up)|event( (number|type))?|launch(ed)?|load (image|movie|nib|sound)|owner|log|mouse (down|dragged|entered|exited|moved|up)|move|column|localization|resource|script|register|drag (info|types)|resigned (active|key|main)|resiz(e(d)?|able)|right mouse (down|dragged|up)|scroll wheel|(at )?index|should (close|open( untitled)?|quit( after last window closed)?|zoom)|((proposed|screen) )?bounds|show(n)?|behind|in front of|size (mode|to fit)|update(d| toolbar item)?|was (hidden|miniaturized)|will (become active|close|finish launching|hide|miniaturize|move|open|quit|(resign )?active|((maximum|minimum|proposed) )?size|show|zoom)|bundle|data source|movie|pasteboard|sound|tool(bar| tip)|(color|open|save) panel|coordinate system|frontmost|main( (bundle|menu|window))?|((services|(excluded from )?windows) )?menu|((executable|frameworks|resource|scripts|shared (frameworks|support)) )?path|(selected item )?identifier|data|content(s| view)?|character(s)?|click count|(command|control|option|shift) key down|context|delta (x|y|z)|key( code)?|location|pressure|unmodified characters|types|(first )?responder|playing|(allowed|selectable) identifiers|allows customization|(auto saves )?configuration|visible|image( name)?|menu form representation|tag|user(-| )defaults|associated file name|(auto|needs) display|current field editor|floating|has (resize indicator|shadow)|hides when deactivated|level|minimized (image|title)|opaque|position|release when closed|sheet|title(d)?)\b/g,css:'color4'},{regex:/\b(?:tracks|paragraph|text item(s)?)\b/g,css:'classes'},{regex:/\b(?:AppleScript|album|video kind|grouping|length|text item delimiters|quoted form|POSIX path(?= of))\b/g,css:'properties'},{regex:/\b(?:run|exists|count)\b/g,css:'commandNames'},{regex:/\b(?:POSIX (file|path))\b/g,css:'additionClasses'},{regex:/\b(?:message|with (data|icon( (caution|note|stop))?|parameter(s)?|prompt|properties|seed|title)|regexp|string result|using( delimiters)?|default (answer|button|color|country code|entr(y|ies)|identifiers|items|name|location|script editor))\b/g,css:'additionParameterNames'},{regex:/\b(?:display(ing| (alert|dialog|mode))?|choose( ((remote )?application|color|folder|from list|URL))?|(do( shell)?|load|run|store) script|re_compile|find text)\b/g,css:'additionCommandNames'},{regex:/\b(?:xxx)\b/g,css:'parameterNames'},{regex:/\b(?:true|false|none)\b/g,css:'enumeratedValues'},{regex:new RegExp(this.getKeywords(c),'gm'),css:'color3'},{regex:new RegExp(this.getKeywords(a),'gm'),css:'keyword'},{regex:new RegExp(this.getKeywords(b),'gm'),css:'keyword'}]};Brush.prototype=new g();Brush.aliases=['applescript'];d.exports=Brush}),(function(c,d,e){'use strict';var f=e(22);var g=e(3).commonRegExp;function Brush(){var a='class interface function package';var b='-Infinity ...rest Array as AS3 Boolean break case catch const continue Date decodeURI '+'decodeURIComponent default delete do dynamic each else encodeURI encodeURIComponent escape '+'extends false final finally flash_proxy for get if implements import in include Infinity '+'instanceof int internal is isFinite isNaN isXMLName label namespace NaN native new null '+'Null Number Object object_proxy override parseFloat parseInt private protected public '+'return set static String super switch this throw true try typeof uint undefined unescape '+'use void while with';this.regexList=[{regex:g.singleLineCComments,css:'comments'},{regex:g.multiLineCComments,css:'comments'},{regex:g.doubleQuotedString,css:'string'},{regex:g.singleQuotedString,css:'string'},{regex:/\b([\d]+(\.[\d]+)?|0x[a-f0-9]+)\b/gi,css:'value'},{regex:new RegExp(this.getKeywords(a),'gm'),css:'color3'},{regex:new RegExp(this.getKeywords(b),'gm'),css:'keyword'},{regex:new RegExp('var','gm'),css:'variable'},{regex:new RegExp('trace','gm'),css:'color1'}];this.forHtmlScript(g.scriptScriptTags)};Brush.prototype=new f();Brush.aliases=['actionscript3','as3'];c.exports=Brush}),(function(f,g,h){'use strict';var i=h(22);var j=h(3).commonRegExp;var k=h(3).XRegExp;var l=h(5).Match;function Brush(){function hereDocProcess(a,b){var c=[];if(a.here_doc!=null)c.push(new l(a.here_doc,a.index+a[0].indexOf(a.here_doc),'string'));if(a.full_tag!=null)c.push(new l(a.full_tag,a.index,'preprocessor'));if(a.end_tag!=null)c.push(new l(a.end_tag,a.index+a[0].lastIndexOf(a.end_tag),'preprocessor'));return c}var d='if fi then elif else for do done until while break continue case esac function return in eq ne ge le';var e='alias apropos awk basename base64 bash bc bg builtin bunzip2 bzcat bzip2 bzip2recover cal cat cd cfdisk chgrp chmod chown chroot'+'cksum clear cmp comm command cp cron crontab crypt csplit cut date dc dd ddrescue declare df '+'diff diff3 dig dir dircolors dirname dirs du echo egrep eject enable env ethtool eval '+'exec exit expand export expr false fdformat fdisk fg fgrep file find fmt fold format '+'free fsck ftp gawk gcc gdb getconf getopts grep groups gunzip gzcat gzip hash head history hostname id ifconfig '+'import install join kill less let ln local locate logname logout look lpc lpr lprint '+'lprintd lprintq lprm ls lsof make man mkdir mkfifo mkisofs mknod more mount mtools '+'mv nasm nc ndisasm netstat nice nl nohup nslookup objdump od open op passwd paste pathchk ping popd pr printcap '+'printenv printf ps pushd pwd quota quotacheck quotactl ram rcp read readonly renice '+'remsync rm rmdir rsync screen scp sdiff sed select seq set sftp shift shopt shutdown '+'sleep sort source split ssh strace strings su sudo sum symlink sync tail tar tee test time '+'times touch top traceroute trap tr true tsort tty type ulimit umask umount unalias '+'uname unexpand uniq units unset unshar useradd usermod users uuencode uudecode v vdir '+'vi watch wc whereis which who whoami Wget xargs xxd yes chsh zcat';this.regexList=[{regex:/^#!.*$/gm,css:'preprocessor bold'},{regex:/\/[\w-\/]+/gm,css:'plain'},{regex:j.singleLinePerlComments,css:'comments'},{regex:j.doubleQuotedString,css:'string'},{regex:j.singleQuotedString,css:'string'},{regex:new RegExp(this.getKeywords(d),'gm'),css:'keyword'},{regex:new RegExp(this.getKeywords(e),'gm'),css:'functions'},{regex:new k("(?<full_tag>(&lt;|<){2}(?<tag>\\w+)) .*$(?<here_doc>[\\s\\S]*)(?<end_tag>^\\k<tag>$)",'gm'),func:hereDocProcess}]}Brush.prototype=new i();Brush.aliases=['bash','shell','sh'];f.exports=Brush}),(function(d,e,f){'use strict';var g=f(22);var h=f(3).commonRegExp;function Brush(){var a='Abs ACos AddSOAPRequestHeader AddSOAPResponseHeader AjaxLink AjaxOnLoad ArrayAppend ArrayAvg ArrayClear ArrayDeleteAt '+'ArrayInsertAt ArrayIsDefined ArrayIsEmpty ArrayLen ArrayMax ArrayMin ArraySet ArraySort ArraySum ArraySwap ArrayToList '+'Asc ASin Atn BinaryDecode BinaryEncode BitAnd BitMaskClear BitMaskRead BitMaskSet BitNot BitOr BitSHLN BitSHRN BitXor '+'Ceiling CharsetDecode CharsetEncode Chr CJustify Compare CompareNoCase Cos CreateDate CreateDateTime CreateObject '+'CreateODBCDate CreateODBCDateTime CreateODBCTime CreateTime CreateTimeSpan CreateUUID DateAdd DateCompare DateConvert '+'DateDiff DateFormat DatePart Day DayOfWeek DayOfWeekAsString DayOfYear DaysInMonth DaysInYear DE DecimalFormat DecrementValue '+'Decrypt DecryptBinary DeleteClientVariable DeserializeJSON DirectoryExists DollarFormat DotNetToCFType Duplicate Encrypt '+'EncryptBinary Evaluate Exp ExpandPath FileClose FileCopy FileDelete FileExists FileIsEOF FileMove FileOpen FileRead '+'FileReadBinary FileReadLine FileSetAccessMode FileSetAttribute FileSetLastModified FileWrite Find FindNoCase FindOneOf '+'FirstDayOfMonth Fix FormatBaseN GenerateSecretKey GetAuthUser GetBaseTagData GetBaseTagList GetBaseTemplatePath '+'GetClientVariablesList GetComponentMetaData GetContextRoot GetCurrentTemplatePath GetDirectoryFromPath GetEncoding '+'GetException GetFileFromPath GetFileInfo GetFunctionList GetGatewayHelper GetHttpRequestData GetHttpTimeString '+'GetK2ServerDocCount GetK2ServerDocCountLimit GetLocale GetLocaleDisplayName GetLocalHostIP GetMetaData GetMetricData '+'GetPageContext GetPrinterInfo GetProfileSections GetProfileString GetReadableImageFormats GetSOAPRequest GetSOAPRequestHeader '+'GetSOAPResponse GetSOAPResponseHeader GetTempDirectory GetTempFile GetTemplatePath GetTickCount GetTimeZoneInfo GetToken '+'GetUserRoles GetWriteableImageFormats Hash Hour HTMLCodeFormat HTMLEditFormat IIf ImageAddBorder ImageBlur ImageClearRect '+'ImageCopy ImageCrop ImageDrawArc ImageDrawBeveledRect ImageDrawCubicCurve ImageDrawLine ImageDrawLines ImageDrawOval '+'ImageDrawPoint ImageDrawQuadraticCurve ImageDrawRect ImageDrawRoundRect ImageDrawText ImageFlip ImageGetBlob ImageGetBufferedImage '+'ImageGetEXIFTag ImageGetHeight ImageGetIPTCTag ImageGetWidth ImageGrayscale ImageInfo ImageNegative ImageNew ImageOverlay ImagePaste '+'ImageRead ImageReadBase64 ImageResize ImageRotate ImageRotateDrawingAxis ImageScaleToFit ImageSetAntialiasing ImageSetBackgroundColor '+'ImageSetDrawingColor ImageSetDrawingStroke ImageSetDrawingTransparency ImageSharpen ImageShear ImageShearDrawingAxis ImageTranslate '+'ImageTranslateDrawingAxis ImageWrite ImageWriteBase64 ImageXORDrawingMode IncrementValue InputBaseN Insert Int IsArray IsBinary '+'IsBoolean IsCustomFunction IsDate IsDDX IsDebugMode IsDefined IsImage IsImageFile IsInstanceOf IsJSON IsLeapYear IsLocalHost '+'IsNumeric IsNumericDate IsObject IsPDFFile IsPDFObject IsQuery IsSimpleValue IsSOAPRequest IsStruct IsUserInAnyRole IsUserInRole '+'IsUserLoggedIn IsValid IsWDDX IsXML IsXmlAttribute IsXmlDoc IsXmlElem IsXmlNode IsXmlRoot JavaCast JSStringFormat LCase Left Len '+'ListAppend ListChangeDelims ListContains ListContainsNoCase ListDeleteAt ListFind ListFindNoCase ListFirst ListGetAt ListInsertAt '+'ListLast ListLen ListPrepend ListQualify ListRest ListSetAt ListSort ListToArray ListValueCount ListValueCountNoCase LJustify Log '+'Log10 LSCurrencyFormat LSDateFormat LSEuroCurrencyFormat LSIsCurrency LSIsDate LSIsNumeric LSNumberFormat LSParseCurrency LSParseDateTime '+'LSParseEuroCurrency LSParseNumber LSTimeFormat LTrim Max Mid Min Minute Month MonthAsString Now NumberFormat ParagraphFormat ParseDateTime '+'Pi PrecisionEvaluate PreserveSingleQuotes Quarter QueryAddColumn QueryAddRow QueryConvertForGrid QueryNew QuerySetCell QuotedValueList Rand '+'Randomize RandRange REFind REFindNoCase ReleaseComObject REMatch REMatchNoCase RemoveChars RepeatString Replace ReplaceList ReplaceNoCase '+'REReplace REReplaceNoCase Reverse Right RJustify Round RTrim Second SendGatewayMessage SerializeJSON SetEncoding SetLocale SetProfileString '+'SetVariable Sgn Sin Sleep SpanExcluding SpanIncluding Sqr StripCR StructAppend StructClear StructCopy StructCount StructDelete StructFind '+'StructFindKey StructFindValue StructGet StructInsert StructIsEmpty StructKeyArray StructKeyExists StructKeyList StructKeyList StructNew '+'StructSort StructUpdate Tan TimeFormat ToBase64 ToBinary ToScript ToString Trim UCase URLDecode URLEncodedFormat URLSessionFormat Val '+'ValueList VerifyClient Week Wrap Wrap WriteOutput XmlChildPos XmlElemNew XmlFormat XmlGetNodeType XmlNew XmlParse XmlSearch XmlTransform '+'XmlValidate Year YesNoFormat';var b='cfabort cfajaximport cfajaxproxy cfapplet cfapplication cfargument cfassociate cfbreak cfcache cfcalendar '+'cfcase cfcatch cfchart cfchartdata cfchartseries cfcol cfcollection cfcomponent cfcontent cfcookie cfdbinfo '+'cfdefaultcase cfdirectory cfdiv cfdocument cfdocumentitem cfdocumentsection cfdump cfelse cfelseif cferror '+'cfexchangecalendar cfexchangeconnection cfexchangecontact cfexchangefilter cfexchangemail cfexchangetask '+'cfexecute cfexit cffeed cffile cfflush cfform cfformgroup cfformitem cfftp cffunction cfgrid cfgridcolumn '+'cfgridrow cfgridupdate cfheader cfhtmlhead cfhttp cfhttpparam cfif cfimage cfimport cfinclude cfindex '+'cfinput cfinsert cfinterface cfinvoke cfinvokeargument cflayout cflayoutarea cfldap cflocation cflock cflog '+'cflogin cfloginuser cflogout cfloop cfmail cfmailparam cfmailpart cfmenu cfmenuitem cfmodule cfNTauthenticate '+'cfobject cfobjectcache cfoutput cfparam cfpdf cfpdfform cfpdfformparam cfpdfparam cfpdfsubform cfpod cfpop '+'cfpresentation cfpresentationslide cfpresenter cfprint cfprocessingdirective cfprocparam cfprocresult '+'cfproperty cfquery cfqueryparam cfregistry cfreport cfreportparam cfrethrow cfreturn cfsavecontent cfschedule '+'cfscript cfsearch cfselect cfset cfsetting cfsilent cfslider cfsprydataset cfstoredproc cfswitch cftable '+'cftextarea cfthread cfthrow cftimer cftooltip cftrace cftransaction cftree cftreeitem cftry cfupdate cfwddx '+'cfwindow cfxml cfzip cfzipparam';var c='all and any between cross in join like not null or outer some';this.regexList=[{regex:new RegExp('--(.*)$','gm'),css:'comments'},{regex:h.xmlComments,css:'comments'},{regex:h.doubleQuotedString,css:'string'},{regex:h.singleQuotedString,css:'string'},{regex:new RegExp(this.getKeywords(a),'gmi'),css:'functions'},{regex:new RegExp(this.getKeywords(c),'gmi'),css:'color1'},{regex:new RegExp(this.getKeywords(b),'gmi'),css:'keyword'}]}Brush.prototype=new g();Brush.aliases=['coldfusion','cf'];d.exports=Brush}),(function(d,e,f){'use strict';var g=f(22);var h=f(3).commonRegExp;function Brush(){var a='ATOM BOOL BOOLEAN BYTE CHAR COLORREF DWORD DWORDLONG DWORD_PTR '+'DWORD32 DWORD64 FLOAT HACCEL HALF_PTR HANDLE HBITMAP HBRUSH '+'HCOLORSPACE HCONV HCONVLIST HCURSOR HDC HDDEDATA HDESK HDROP HDWP '+'HENHMETAFILE HFILE HFONT HGDIOBJ HGLOBAL HHOOK HICON HINSTANCE HKEY '+'HKL HLOCAL HMENU HMETAFILE HMODULE HMONITOR HPALETTE HPEN HRESULT '+'HRGN HRSRC HSZ HWINSTA HWND INT INT_PTR INT32 INT64 LANGID LCID LCTYPE '+'LGRPID LONG LONGLONG LONG_PTR LONG32 LONG64 LPARAM LPBOOL LPBYTE LPCOLORREF '+'LPCSTR LPCTSTR LPCVOID LPCWSTR LPDWORD LPHANDLE LPINT LPLONG LPSTR LPTSTR '+'LPVOID LPWORD LPWSTR LRESULT PBOOL PBOOLEAN PBYTE PCHAR PCSTR PCTSTR PCWSTR '+'PDWORDLONG PDWORD_PTR PDWORD32 PDWORD64 PFLOAT PHALF_PTR PHANDLE PHKEY PINT '+'PINT_PTR PINT32 PINT64 PLCID PLONG PLONGLONG PLONG_PTR PLONG32 PLONG64 POINTER_32 '+'POINTER_64 PSHORT PSIZE_T PSSIZE_T PSTR PTBYTE PTCHAR PTSTR PUCHAR PUHALF_PTR '+'PUINT PUINT_PTR PUINT32 PUINT64 PULONG PULONGLONG PULONG_PTR PULONG32 PULONG64 '+'PUSHORT PVOID PWCHAR PWORD PWSTR SC_HANDLE SC_LOCK SERVICE_STATUS_HANDLE SHORT '+'SIZE_T SSIZE_T TBYTE TCHAR UCHAR UHALF_PTR UINT UINT_PTR UINT32 UINT64 ULONG '+'ULONGLONG ULONG_PTR ULONG32 ULONG64 USHORT USN VOID WCHAR WORD WPARAM WPARAM WPARAM '+'char char16_t char32_t bool short int __int32 __int64 __int8 __int16 long float double __wchar_t '+'clock_t _complex _dev_t _diskfree_t div_t ldiv_t _exception _EXCEPTION_POINTERS '+'FILE _finddata_t _finddatai64_t _wfinddata_t _wfinddatai64_t __finddata64_t '+'__wfinddata64_t _FPIEEE_RECORD fpos_t _HEAPINFO _HFILE lconv intptr_t '+'jmp_buf mbstate_t _off_t _onexit_t _PNH ptrdiff_t _purecall_handler '+'sig_atomic_t size_t _stat __stat64 _stati64 terminate_function '+'time_t __time64_t _timeb __timeb64 tm uintptr_t _utimbuf '+'va_list wchar_t wctrans_t wctype_t wint_t signed';var b='alignas alignof auto break case catch class const constexpr decltype __finally __exception __try '+'const_cast continue private public protected __declspec '+'default delete deprecated dllexport dllimport do dynamic_cast '+'else enum explicit extern if for friend goto inline '+'mutable naked namespace new noinline noreturn nothrow noexcept nullptr '+'register reinterpret_cast return selectany '+'sizeof static static_cast static_assert struct switch template this '+'thread thread_local throw true false try typedef typeid typename union '+'using uuid virtual void volatile whcar_t while';var c='assert isalnum isalpha iscntrl isdigit isgraph islower isprint '+'ispunct isspace isupper isxdigit tolower toupper errno localeconv '+'setlocale acos asin atan atan2 ceil cos cosh exp fabs floor fmod '+'frexp ldexp log log10 modf pow sin sinh sqrt tan tanh jmp_buf '+'longjmp setjmp raise signal sig_atomic_t va_arg va_end va_start '+'clearerr fclose feof ferror fflush fgetc fgetpos fgets fopen '+'fprintf fputc fputs fread freopen fscanf fseek fsetpos ftell '+'fwrite getc getchar gets perror printf putc putchar puts remove '+'rename rewind scanf setbuf setvbuf sprintf sscanf tmpfile tmpnam '+'ungetc vfprintf vprintf vsprintf abort abs atexit atof atoi atol '+'bsearch calloc div exit free getenv labs ldiv malloc mblen mbstowcs '+'mbtowc qsort rand realloc srand strtod strtol strtoul system '+'wcstombs wctomb memchr memcmp memcpy memmove memset strcat strchr '+'strcmp strcoll strcpy strcspn strerror strlen strncat strncmp '+'strncpy strpbrk strrchr strspn strstr strtok strxfrm asctime '+'clock ctime difftime gmtime localtime mktime strftime time';this.regexList=[{regex:h.singleLineCComments,css:'comments'},{regex:h.multiLineCComments,css:'comments'},{regex:h.doubleQuotedString,css:'string'},{regex:h.singleQuotedString,css:'string'},{regex:/^ *#.*/gm,css:'preprocessor'},{regex:new RegExp(this.getKeywords(a),'gm'),css:'color1 bold'},{regex:new RegExp(this.getKeywords(c),'gm'),css:'functions bold'},{regex:new RegExp(this.getKeywords(b),'gm'),css:'keyword bold'}]};Brush.prototype=new g();Brush.aliases=['cpp','cc','c++','c','h','hpp','h++'];d.exports=Brush}),(function(e,f,g){'use strict';var h=g(22);var i=g(3).commonRegExp;var j=g(5).Match;function Brush(){var d='abstract as base bool break byte case catch char checked class const '+'continue decimal default delegate do double else enum event explicit volatile '+'extern false finally fixed float for foreach get goto if implicit in int '+'interface internal is lock long namespace new null object operator out '+'override params private protected public readonly ref return sbyte sealed set '+'short sizeof stackalloc static string struct switch this throw true try '+'typeof uint ulong unchecked unsafe ushort using virtual void while var '+'from group by into select let where orderby join on equals ascending descending';function fixComments(a,b){var c=a[0].indexOf("///")==0?'color1':'comments';return[new j(a[0],a.index,c)]}this.regexList=[{regex:i.singleLineCComments,func:fixComments},{regex:i.multiLineCComments,css:'comments'},{regex:/@"(?:[^"]|"")*"/g,css:'string'},{regex:i.doubleQuotedString,css:'string'},{regex:i.singleQuotedString,css:'string'},{regex:/^\s*#.*/gm,css:'preprocessor'},{regex:new RegExp(this.getKeywords(d),'gm'),css:'keyword'},{regex:/\bpartial(?=\s+(?:class|interface|struct)\b)/g,css:'keyword'},{regex:/\byield(?=\s+(?:return|break)\b)/g,css:'keyword'}];this.forHtmlScript(i.aspScriptTags)};Brush.prototype=new h();Brush.aliases=['c#','c-sharp','csharp'];e.exports=Brush}),(function(e,f,g){'use strict';var h=g(22);var i=g(3).commonRegExp;function Brush(){function getKeywordsCSS(a){return'\\b([a-z_]|)'+a.replace(/ /g,'(?=:)\\b|\\b([a-z_\\*]|\\*|)')+'(?=:)\\b'};function getValuesCSS(a){return'\\b'+a.replace(/ /g,'(?!-)(?!:)\\b|\\b()')+'\:\\b'};var b='ascent azimuth background-attachment background-color background-image background-position '+'background-repeat background baseline bbox border-collapse border-color border-spacing border-style border-top '+'border-right border-bottom border-left border-top-color border-right-color border-bottom-color border-left-color '+'border-top-style border-right-style border-bottom-style border-left-style border-top-width border-right-width '+'border-bottom-width border-left-width border-width border bottom cap-height caption-side centerline clear clip color '+'content counter-increment counter-reset cue-after cue-before cue cursor definition-src descent direction display '+'elevation empty-cells float font-size-adjust font-family font-size font-stretch font-style font-variant font-weight font '+'height left letter-spacing line-height list-style-image list-style-position list-style-type list-style margin-top '+'margin-right margin-bottom margin-left margin marker-offset marks mathline max-height max-width min-height min-width orphans '+'outline-color outline-style outline-width outline overflow padding-top padding-right padding-bottom padding-left padding page '+'page-break-after page-break-before page-break-inside pause pause-after pause-before pitch pitch-range play-during position '+'quotes right richness size slope src speak-header speak-numeral speak-punctuation speak speech-rate stemh stemv stress '+'table-layout text-align top text-decoration text-indent text-shadow text-transform unicode-bidi unicode-range units-per-em '+'vertical-align visibility voice-family volume white-space widows width widths word-spacing x-height z-index';var c='above absolute all always aqua armenian attr aural auto avoid baseline behind below bidi-override black blink block blue bold bolder '+'both bottom braille capitalize caption center center-left center-right circle close-quote code collapse compact condensed '+'continuous counter counters crop cross crosshair cursive dashed decimal decimal-leading-zero default digits disc dotted double '+'embed embossed e-resize expanded extra-condensed extra-expanded fantasy far-left far-right fast faster fixed format fuchsia '+'gray green groove handheld hebrew help hidden hide high higher icon inline-table inline inset inside invert italic '+'justify landscape large larger left-side left leftwards level lighter lime line-through list-item local loud lower-alpha '+'lowercase lower-greek lower-latin lower-roman lower low ltr marker maroon medium message-box middle mix move narrower '+'navy ne-resize no-close-quote none no-open-quote no-repeat normal nowrap n-resize nw-resize oblique olive once open-quote outset '+'outside overline pointer portrait pre print projection purple red relative repeat repeat-x repeat-y rgb ridge right right-side '+'rightwards rtl run-in screen scroll semi-condensed semi-expanded separate se-resize show silent silver slower slow '+'small small-caps small-caption smaller soft solid speech spell-out square s-resize static status-bar sub super sw-resize '+'table-caption table-cell table-column table-column-group table-footer-group table-header-group table-row table-row-group teal '+'text-bottom text-top thick thin top transparent tty tv ultra-condensed ultra-expanded underline upper-alpha uppercase upper-latin '+'upper-roman url visible wait white wider w-resize x-fast x-high x-large x-loud x-low x-slow x-small x-soft xx-large xx-small yellow';var d='[mM]onospace [tT]ahoma [vV]erdana [aA]rial [hH]elvetica [sS]ans-serif [sS]erif [cC]ourier mono sans serif';this.regexList=[{regex:i.multiLineCComments,css:'comments'},{regex:i.doubleQuotedString,css:'string'},{regex:i.singleQuotedString,css:'string'},{regex:/\#[a-fA-F0-9]{3,6}/g,css:'value'},{regex:/(-?\d+)(\.\d+)?(px|em|pt|\:|\%|)/g,css:'value'},{regex:/!important/g,css:'color3'},{regex:new RegExp(getKeywordsCSS(b),'gm'),css:'keyword'},{regex:new RegExp(getValuesCSS(c),'g'),css:'value'},{regex:new RegExp(this.getKeywords(d),'g'),css:'color1'}];this.forHtmlScript({left:/(&lt;|<)\s*style.*?(&gt;|>)/gi,right:/(&lt;|<)\/\s*style\s*(&gt;|>)/gi})};Brush.prototype=new h();Brush.aliases=['css'];e.exports=Brush}),(function(b,c,d){'use strict';var e=d(22);var f=d(3).commonRegExp;function Brush(){var a='abs addr and ansichar ansistring array as asm begin boolean byte cardinal '+'case char class comp const constructor currency destructor div do double '+'downto else end except exports extended false file finalization finally '+'for function goto if implementation in inherited int64 initialization '+'integer interface is label library longint longword mod nil not object '+'of on or packed pansichar pansistring pchar pcurrency pdatetime pextended '+'pint64 pointer private procedure program property pshortstring pstring '+'pvariant pwidechar pwidestring protected public published raise real real48 '+'record repeat set shl shortint shortstring shr single smallint string then '+'threadvar to true try type unit until uses val var varirnt while widechar '+'widestring with word write writeln xor';this.regexList=[{regex:/\(\*[\s\S]*?\*\)/gm,css:'comments'},{regex:/{(?!\$)[\s\S]*?}/gm,css:'comments'},{regex:f.singleLineCComments,css:'comments'},{regex:f.singleQuotedString,css:'string'},{regex:/\{\$[a-zA-Z]+ .+\}/g,css:'color1'},{regex:/\b[\d\.]+\b/g,css:'value'},{regex:/\$[a-zA-Z0-9]+\b/g,css:'value'},{regex:new RegExp(this.getKeywords(a),'gmi'),css:'keyword'}]};Brush.prototype=new e();Brush.aliases=['delphi','pascal','pas'];b.exports=Brush}),(function(a,b,c){'use strict';var d=c(22);var e=c(3).commonRegExp;function Brush(){this.regexList=[{regex:/^\+\+\+ .*$/gm,css:'color2'},{regex:/^\-\-\- .*$/gm,css:'color2'},{regex:/^\s.*$/gm,css:'color1'},{regex:/^@@.*@@.*$/gm,css:'variable'},{regex:/^\+.*$/gm,css:'string'},{regex:/^\-.*$/gm,css:'color3'}]};Brush.prototype=new d();Brush.aliases=['diff','patch'];a.exports=Brush}),(function(b,c,d){'use strict';var e=d(22);var f=d(3).commonRegExp;function Brush(){var a='after and andalso band begin bnot bor bsl bsr bxor '+'case catch cond div end fun if let not of or orelse '+'query receive rem try when xor'+' module export import define';this.regexList=[{regex:new RegExp("[A-Z][A-Za-z0-9_]+",'g'),css:'constants'},{regex:new RegExp("\\%.+",'gm'),css:'comments'},{regex:new RegExp("\\?[A-Za-z0-9_]+",'g'),css:'preprocessor'},{regex:new RegExp("[a-z0-9_]+:[a-z0-9_]+",'g'),css:'functions'},{regex:f.doubleQuotedString,css:'string'},{regex:f.singleQuotedString,css:'string'},{regex:new RegExp(this.getKeywords(a),'gm'),css:'keyword'}]};Brush.prototype=new e();Brush.aliases=['erl','erlang'];b.exports=Brush}),(function(e,f,g){'use strict';var h=g(22);var i=g(3).commonRegExp;function Brush(){var a='as assert break case catch class continue def default do else extends finally '+'if in implements import instanceof interface new package property return switch '+'throw throws try while public protected private static';var b='void boolean byte char short int long float double';var c='null';var d='allProperties count get size '+'collect each eachProperty eachPropertyName eachWithIndex find findAll '+'findIndexOf grep inject max min reverseEach sort '+'asImmutable asSynchronized flatten intersect join pop reverse subMap toList '+'padRight padLeft contains eachMatch toCharacter toLong toUrl tokenize '+'eachFile eachFileRecurse eachB yte eachLine readBytes readLine getText '+'splitEachLine withReader append encodeBase64 decodeBase64 filterLine '+'transformChar transformLine withOutputStream withPrintWriter withStream '+'withStreams withWriter withWriterAppend write writeLine '+'dump inspect invokeMethod print println step times upto use waitForOrKill '+'getText';this.regexList=[{regex:i.singleLineCComments,css:'comments'},{regex:i.multiLineCComments,css:'comments'},{regex:i.doubleQuotedString,css:'string'},{regex:i.singleQuotedString,css:'string'},{regex:/""".*"""/g,css:'string'},{regex:new RegExp('\\b([\\d]+(\\.[\\d]+)?|0x[a-f0-9]+)\\b','gi'),css:'value'},{regex:new RegExp(this.getKeywords(a),'gm'),css:'keyword'},{regex:new RegExp(this.getKeywords(b),'gm'),css:'color1'},{regex:new RegExp(this.getKeywords(c),'gm'),css:'constants'},{regex:new RegExp(this.getKeywords(d),'gm'),css:'functions'}];this.forHtmlScript(i.aspScriptTags)}Brush.prototype=new h();Brush.aliases=['groovy'];e.exports=Brush}),(function(e,f,g){'use strict';var h=g(22);var j=g(3).commonRegExp;function Brush(){var a='class interface package macro enum typedef extends implements dynamic in for if while else do try switch case catch';var b='return break continue new throw cast using import function public private inline static untyped callback true false null Int Float String Void Std Bool Dynamic Array Vector';this.regexList=[{regex:j.singleLineCComments,css:'comments'},{regex:j.multiLineCComments,css:'comments'},{regex:j.doubleQuotedString,css:'string'},{regex:j.singleQuotedString,css:'string'},{regex:/\b([\d]+(\.[\d]+)?|0x[a-f0-9]+)\b/gi,css:'value'},{regex:new RegExp(this.getKeywords(a),'gm'),css:'color3'},{regex:new RegExp(this.getKeywords(b),'gm'),css:'keyword'},{regex:new RegExp('var','gm'),css:'variable'},{regex:new RegExp('trace','gm'),css:'color1'},{regex:new RegExp('#if','gm'),css:'comments'},{regex:new RegExp('#elseif','gm'),css:'comments'},{regex:new RegExp('#end','gm'),css:'comments'},{regex:new RegExp('#error','gm'),css:'comments'}];var c=["debug","error","cpp","js","neko","php","flash","flash8","flash9","flash10","flash10","mobile","desktop","web","ios","android","iphone"];var i;var d=c.length;for(i=0;i<=d-1;i++){this.regexList.push({regex:new RegExp(c[i],'gm'),css:'comments'});this.regexList.push({regex:new RegExp('!'+c[i],'gm'),css:'comments'})}this.forHtmlScript(j.scriptScriptTags)};Brush.prototype=new h();Brush.aliases=['haxe','hx'];e.exports=Brush}),(function(b,c,d){'use strict';var e=d(22);var f=d(3).commonRegExp;function Brush(){var a='abstract assert boolean break byte case catch char class const '+'continue default do double else enum extends '+'false final finally float for goto if implements import '+'instanceof int interface long native new null '+'package private protected public return '+'short static strictfp super switch synchronized this throw throws true '+'transient try void volatile while';this.regexList=[{regex:f.singleLineCComments,css:'comments'},{regex:/\/\*([^\*][\s\S]*?)?\*\//gm,css:'comments'},{regex:/\/\*(?!\*\/)\*[\s\S]*?\*\//gm,css:'preprocessor'},{regex:f.doubleQuotedString,css:'string'},{regex:f.singleQuotedString,css:'string'},{regex:/\b([\d]+(\.[\d]+)?f?|[\d]+l?|0x[a-f0-9]+)\b/gi,css:'value'},{regex:/(?!\@interface\b)\@[\$\w]+\b/g,css:'color1'},{regex:/\@interface\b/g,css:'color2'},{regex:new RegExp(this.getKeywords(a),'gm'),css:'keyword'}];this.forHtmlScript({left:/(&lt;|<)%[@!=]?/g,right:/%(&gt;|>)/g})};Brush.prototype=new e();Brush.aliases=['java'];b.exports=Brush}),(function(c,d,e){'use strict';var f=e(22);var g=e(3).commonRegExp;function Brush(){var a='Boolean Byte Character Double Duration '+'Float Integer Long Number Short String Void';var b='abstract after and as assert at before bind bound break catch class '+'continue def delete else exclusive extends false finally first for from '+'function if import in indexof init insert instanceof into inverse last '+'lazy mixin mod nativearray new not null on or override package postinit '+'protected public public-init public-read replace return reverse sizeof '+'step super then this throw true try tween typeof var where while with '+'attribute let private readonly static trigger';this.regexList=[{regex:g.singleLineCComments,css:'comments'},{regex:g.multiLineCComments,css:'comments'},{regex:g.singleQuotedString,css:'string'},{regex:g.doubleQuotedString,css:'string'},{regex:/(-?\.?)(\b(\d*\.?\d+|\d+\.?\d*)(e[+-]?\d+)?|0x[a-f\d]+)\b\.?/gi,css:'color2'},{regex:new RegExp(this.getKeywords(a),'gm'),css:'variable'},{regex:new RegExp(this.getKeywords(b),'gm'),css:'keyword'}];this.forHtmlScript(g.aspScriptTags)};Brush.prototype=new f();Brush.aliases=['jfx','javafx'];c.exports=Brush}),(function(b,c,d){'use strict';var e=d(22);var f=d(3).commonRegExp;function Brush(){var a='break case catch class continue '+'default delete do else enum export extends false  '+'for from as function if implements import in instanceof '+'interface let new null package private protected '+'static return super switch '+'this throw true try typeof var while with yield';this.regexList=[{regex:f.multiLineDoubleQuotedString,css:'string'},{regex:f.multiLineSingleQuotedString,css:'string'},{regex:f.singleLineCComments,css:'comments'},{regex:f.multiLineCComments,css:'comments'},{regex:/\s*#.*/gm,css:'preprocessor'},{regex:new RegExp(this.getKeywords(a),'gm'),css:'keyword'}];this.forHtmlScript(f.scriptScriptTags)}Brush.prototype=new e();Brush.aliases=['js','jscript','javascript','json'];b.exports=Brush}),(function(c,d,e){'use strict';var f=e(22);var g=e(3).commonRegExp;function Brush(){var a='abs accept alarm atan2 bind binmode chdir chmod chomp chop chown chr '+'chroot close closedir connect cos crypt defined delete each endgrent '+'endhostent endnetent endprotoent endpwent endservent eof exec exists '+'exp fcntl fileno flock fork format formline getc getgrent getgrgid '+'getgrnam gethostbyaddr gethostbyname gethostent getlogin getnetbyaddr '+'getnetbyname getnetent getpeername getpgrp getppid getpriority '+'getprotobyname getprotobynumber getprotoent getpwent getpwnam getpwuid '+'getservbyname getservbyport getservent getsockname getsockopt glob '+'gmtime grep hex index int ioctl join keys kill lc lcfirst length link '+'listen localtime lock log lstat map mkdir msgctl msgget msgrcv msgsnd '+'oct open opendir ord pack pipe pop pos print printf prototype push '+'quotemeta rand read readdir readline readlink readpipe recv rename '+'reset reverse rewinddir rindex rmdir scalar seek seekdir select semctl '+'semget semop send setgrent sethostent setnetent setpgrp setpriority '+'setprotoent setpwent setservent setsockopt shift shmctl shmget shmread '+'shmwrite shutdown sin sleep socket socketpair sort splice split sprintf '+'sqrt srand stat study substr symlink syscall sysopen sysread sysseek '+'system syswrite tell telldir time times tr truncate uc ucfirst umask '+'undef unlink unpack unshift utime values vec wait waitpid warn write '+'say';var b='bless caller continue dbmclose dbmopen die do dump else elsif eval exit '+'for foreach goto if import last local my next no our package redo ref '+'require return sub tie tied unless untie until use wantarray while '+'given when default '+'try catch finally '+'has extends with before after around override augment';this.regexList=[{regex:/(<<|&lt;&lt;)((\w+)|(['"])(.+?)\4)[\s\S]+?\n\3\5\n/g,css:'string'},{regex:/#.*$/gm,css:'comments'},{regex:/^#!.*\n/g,css:'preprocessor'},{regex:/-?\w+(?=\s*=(>|&gt;))/g,css:'string'},{regex:/\bq[qwxr]?\([\s\S]*?\)/g,css:'string'},{regex:/\bq[qwxr]?\{[\s\S]*?\}/g,css:'string'},{regex:/\bq[qwxr]?\[[\s\S]*?\]/g,css:'string'},{regex:/\bq[qwxr]?(<|&lt;)[\s\S]*?(>|&gt;)/g,css:'string'},{regex:/\bq[qwxr]?([^\w({<[])[\s\S]*?\1/g,css:'string'},{regex:g.doubleQuotedString,css:'string'},{regex:g.singleQuotedString,css:'string'},{regex:/(?:&amp;|[$@%*]|\$#)\$?[a-zA-Z_](\w+|::)*/g,css:'variable'},{regex:/\b__(?:END|DATA)__\b[\s\S]*$/g,css:'comments'},{regex:/(^|\n)=\w[\s\S]*?(\n=cut\s*(?=\n)|$)/g,css:'comments'},{regex:new RegExp(this.getKeywords(a),'gm'),css:'functions'},{regex:new RegExp(this.getKeywords(b),'gm'),css:'keyword'}];this.forHtmlScript(g.phpScriptTags)}Brush.prototype=new f();Brush.aliases=['perl','Perl','pl'];c.exports=Brush}),(function(d,e,f){'use strict';Object.defineProperty(e,"__esModule",{value:true});var g=function(){function defineProperties(a,b){for(var i=0;i<b.length;i++){var c=b[i];c.enumerable=c.enumerable||false;c.configurable=true;if("value"in c)c.writable=true;Object.defineProperty(a,c.key,c)}}return function(a,b,c){if(b)defineProperties(a.prototype,b);if(c)defineProperties(a,c);return a}}();var h=f(22);var j=_interopRequireDefault(h);var k=f(3);function _interopRequireDefault(a){return a&&a.__esModule?a:{default:a}}function _classCallCheck(a,b){if(!(a instanceof b)){throw new TypeError("Cannot call a class as a function");}}function _possibleConstructorReturn(a,b){if(!a){throw new ReferenceError("this hasn't been initialised - super() hasn't been called");}return b&&(typeof b==="object"||typeof b==="function")?b:a}function _inherits(a,b){if(typeof b!=="function"&&b!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof b);}a.prototype=Object.create(b&&b.prototype,{constructor:{value:a,enumerable:false,writable:true,configurable:true}});if(b)Object.setPrototypeOf?Object.setPrototypeOf(a,b):a.__proto__=b}var l='abs acos acosh addcslashes addslashes '+'array_change_key_case array_chunk array_combine array_count_values array_diff '+'array_diff_assoc array_diff_key array_diff_uassoc array_diff_ukey array_fill '+'array_filter array_flip array_intersect array_intersect_assoc array_intersect_key '+'array_intersect_uassoc array_intersect_ukey array_key_exists array_keys array_map '+'array_merge array_merge_recursive array_multisort array_pad array_pop array_product '+'array_push array_rand array_reduce array_reverse array_search array_shift '+'array_slice array_splice array_sum array_udiff array_udiff_assoc '+'array_udiff_uassoc array_uintersect array_uintersect_assoc '+'array_uintersect_uassoc array_unique array_unshift array_values array_walk '+'array_walk_recursive atan atan2 atanh base64_decode base64_encode base_convert '+'basename bcadd bccomp bcdiv bcmod bcmul bindec bindtextdomain bzclose bzcompress '+'bzdecompress bzerrno bzerror bzerrstr bzflush bzopen bzread bzwrite ceil chdir '+'checkdate checkdnsrr chgrp chmod chop chown chr chroot chunk_split class_exists '+'closedir closelog copy cos cosh count count_chars date decbin dechex decoct '+'deg2rad delete ebcdic2ascii echo empty end ereg ereg_replace eregi eregi_replace error_log '+'error_reporting escapeshellarg escapeshellcmd eval exec exit exp explode extension_loaded '+'feof fflush fgetc fgetcsv fgets fgetss file_exists file_get_contents file_put_contents '+'fileatime filectime filegroup fileinode filemtime fileowner fileperms filesize filetype '+'floatval flock floor flush fmod fnmatch fopen fpassthru fprintf fputcsv fputs fread fscanf '+'fseek fsockopen fstat ftell ftok getallheaders getcwd getdate getenv gethostbyaddr gethostbyname '+'gethostbynamel getimagesize getlastmod getmxrr getmygid getmyinode getmypid getmyuid getopt '+'getprotobyname getprotobynumber getrandmax getrusage getservbyname getservbyport gettext '+'gettimeofday gettype glob gmdate gmmktime ini_alter ini_get ini_get_all ini_restore ini_set '+'interface_exists intval ip2long is_a is_array is_bool is_callable is_dir is_double '+'is_executable is_file is_finite is_float is_infinite is_int is_integer is_link is_long '+'is_nan is_null is_numeric is_object is_readable is_real is_resource is_scalar is_soap_fault '+'is_string is_subclass_of is_uploaded_file is_writable is_writeable mkdir mktime nl2br '+'parse_ini_file parse_str parse_url passthru pathinfo print readlink realpath rewind rewinddir rmdir '+'round str_ireplace str_pad str_repeat str_replace str_rot13 str_shuffle str_split '+'str_word_count strcasecmp strchr strcmp strcoll strcspn strftime strip_tags stripcslashes '+'stripos stripslashes stristr strlen strnatcasecmp strnatcmp strncasecmp strncmp strpbrk '+'strpos strptime strrchr strrev strripos strrpos strspn strstr strtok strtolower strtotime '+'strtoupper strtr strval substr substr_compare';var m='abstract and array as break case catch cfunction class clone const continue declare default die do '+'else elseif enddeclare endfor endforeach endif endswitch endwhile extends final finally for foreach '+'function global goto if implements include include_once interface instanceof insteadof namespace new '+'old_function or private protected public return require require_once static switch '+'trait throw try use const while xor yield ';var n='__FILE__ __LINE__ __METHOD__ __FUNCTION__ __CLASS__';var o=function(b){_inherits(o,b);g(o,null,[{key:'aliases',get:function get(){return['php']}}]);function o(){_classCallCheck(this,o);var a=_possibleConstructorReturn(this,(o.__proto__||Object.getPrototypeOf(o)).call(this));a.regexList=[{regex:k.commonRegExp.singleLineCComments,css:'comments'},{regex:k.commonRegExp.multiLineCComments,css:'comments'},{regex:k.commonRegExp.doubleQuotedString,css:'string'},{regex:k.commonRegExp.singleQuotedString,css:'string'},{regex:/\$\w+/g,css:'variable'},{regex:new RegExp(a.getKeywords(l),'gmi'),css:'functions'},{regex:new RegExp(a.getKeywords(n),'gmi'),css:'constants'},{regex:new RegExp(a.getKeywords(m),'gm'),css:'keyword'}];a.forHtmlScript(k.commonRegExp.phpScriptTags);return a}return o}(j.default);e.default=o}),(function(a,b,c){'use strict';var d=c(22);var e=c(3).commonRegExp;function Brush(){this.regexList=[]};Brush.prototype=new d();Brush.aliases=['text','plain'];a.exports=Brush}),(function(e,f,g){'use strict';var h=g(22);var i=g(3).commonRegExp;function Brush(){var a='while validateset validaterange validatepattern validatelength validatecount '+'until trap switch return ref process param parameter in if global: '+'function foreach for finally filter end elseif else dynamicparam do default '+'continue cmdletbinding break begin alias \\? % #script #private #local #global '+'mandatory parametersetname position valuefrompipeline '+'valuefrompipelinebypropertyname valuefromremainingarguments helpmessage ';var b=' and as band bnot bor bxor casesensitive ccontains ceq cge cgt cle '+'clike clt cmatch cne cnotcontains cnotlike cnotmatch contains '+'creplace eq exact f file ge gt icontains ieq ige igt ile ilike ilt '+'imatch ine inotcontains inotlike inotmatch ireplace is isnot le like '+'lt match ne not notcontains notlike notmatch or regex replace wildcard';var c='write where wait use update unregister undo trace test tee take suspend '+'stop start split sort skip show set send select scroll resume restore '+'restart resolve resize reset rename remove register receive read push '+'pop ping out new move measure limit join invoke import group get format '+'foreach export expand exit enter enable disconnect disable debug cxnew '+'copy convertto convertfrom convert connect complete compare clear '+'checkpoint aggregate add';var d=' component description example externalhelp forwardhelpcategory forwardhelptargetname forwardhelptargetname functionality inputs link notes outputs parameter remotehelprunspace role synopsis';this.regexList=[{regex:new RegExp('^\\s*#[#\\s]*\\.('+this.getKeywords(d)+').*$','gim'),css:'preprocessor help bold'},{regex:i.singleLinePerlComments,css:'comments'},{regex:/(&lt;|<)#[\s\S]*?#(&gt;|>)/gm,css:'comments here'},{regex:new RegExp('@"\\n[\\s\\S]*?\\n"@','gm'),css:'script string here'},{regex:new RegExp("@'\\n[\\s\\S]*?\\n'@",'gm'),css:'script string single here'},{regex:new RegExp('"(?:\\$\\([^\\)]*\\)|[^"]|`"|"")*[^`]"','g'),css:'string'},{regex:new RegExp("'(?:[^']|'')*'",'g'),css:'string single'},{regex:new RegExp('[\\$|@|@@](?:(?:global|script|private|env):)?[A-Z0-9_]+','gi'),css:'variable'},{regex:new RegExp('(?:\\b'+c.replace(/ /g,'\\b|\\b')+')-[a-zA-Z_][a-zA-Z0-9_]*','gmi'),css:'functions'},{regex:new RegExp(this.getKeywords(a),'gmi'),css:'keyword'},{regex:new RegExp('-'+this.getKeywords(b),'gmi'),css:'operator value'},{regex:new RegExp('\\[[A-Z_\\[][A-Z0-9_. `,\\[\\]]*\\]','gi'),css:'constants'},{regex:new RegExp('\\s+-(?!'+this.getKeywords(b)+')[a-zA-Z_][a-zA-Z0-9_]*','gmi'),css:'color1'}]};Brush.prototype=new h();Brush.aliases=['powershell','ps','posh'];e.exports=Brush}),(function(d,e,f){'use strict';var g=f(22);var h=f(3).commonRegExp;function Brush(){var a='and assert break class continue def del elif else '+'except exec finally for from global if import in is '+'lambda not or pass raise return try yield while';var b='__import__ abs all any apply basestring bin bool buffer callable '+'chr classmethod cmp coerce compile complex delattr dict dir '+'divmod enumerate eval execfile file filter float format frozenset '+'getattr globals hasattr hash help hex id input int intern '+'isinstance issubclass iter len list locals long map max min next '+'object oct open ord pow print property range raw_input reduce '+'reload repr reversed round set setattr slice sorted staticmethod '+'str sum super tuple type type unichr unicode vars xrange zip';var c='None True False self cls class_';this.regexList=[{regex:h.singleLinePerlComments,css:'comments'},{regex:/^\s*@\w+/gm,css:'decorator'},{regex:/(['\"]{3})([^\1])*?\1/gm,css:'comments'},{regex:/"(?!")(?:\.|\\\"|[^\""\n])*"/gm,css:'string'},{regex:/'(?!')(?:\.|(\\\')|[^\''\n])*'/gm,css:'string'},{regex:/\+|\-|\*|\/|\%|=|==/gm,css:'keyword'},{regex:/\b\d+\.?\w*/g,css:'value'},{regex:new RegExp(this.getKeywords(b),'gmi'),css:'functions'},{regex:new RegExp(this.getKeywords(a),'gm'),css:'keyword'},{regex:new RegExp(this.getKeywords(c),'gm'),css:'color1'}];this.forHtmlScript(h.aspScriptTags)};Brush.prototype=new g();Brush.aliases=['py','python'];d.exports=Brush}),(function(c,d,e){'use strict';var f=e(22);var g=e(3).commonRegExp;function Brush(){var a='alias and BEGIN begin break case class def define_method defined do each else elsif '+'END end ensure false for if in module new next nil not or raise redo rescue retry return '+'self super then throw true undef unless until when while yield';var b='Array Bignum Binding Class Continuation Dir Exception FalseClass File::Stat File Fixnum Fload '+'Hash Integer IO MatchData Method Module NilClass Numeric Object Proc Range Regexp String Struct::TMS Symbol '+'ThreadGroup Thread Time TrueClass';this.regexList=[{regex:g.singleLinePerlComments,css:'comments'},{regex:g.doubleQuotedString,css:'string'},{regex:g.singleQuotedString,css:'string'},{regex:/\b[A-Z0-9_]+\b/g,css:'constants'},{regex:/:[a-z][A-Za-z0-9_]*/g,css:'color2'},{regex:/(\$|@@|@)\w+/g,css:'variable bold'},{regex:new RegExp(this.getKeywords(a),'gm'),css:'keyword'},{regex:new RegExp(this.getKeywords(b),'gm'),css:'color1'}];this.forHtmlScript(g.aspScriptTags)};Brush.prototype=new f();Brush.aliases=['ruby','rails','ror','rb'];c.exports=Brush}),(function(h,i,j){'use strict';var k=j(22);var l=j(3).commonRegExp;function Brush(){function getKeywordsCSS(a){return'\\b([a-z_]|)'+a.replace(/ /g,'(?=:)\\b|\\b([a-z_\\*]|\\*|)')+'(?=:)\\b'};function getValuesCSS(a){return'\\b'+a.replace(/ /g,'(?!-)(?!:)\\b|\\b()')+'\:\\b'};function getKeywordsPrependedBy(a,b){return'(?:'+a.replace(/^\s+|\s+$/g,'').replace(/\s+/g,'|'+b+'\\b').replace(/^/,b+'\\b')+')\\b'}var c='ascent azimuth background-attachment background-color background-image background-position '+'background-repeat background baseline bbox border-collapse border-color border-spacing border-style border-top '+'border-right border-bottom border-left border-top-color border-right-color border-bottom-color border-left-color '+'border-top-style border-right-style border-bottom-style border-left-style border-top-width border-right-width '+'border-bottom-width border-left-width border-width border bottom cap-height caption-side centerline clear clip color '+'content counter-increment counter-reset cue-after cue-before cue cursor definition-src descent direction display '+'elevation empty-cells float font-size-adjust font-family font-size font-stretch font-style font-variant font-weight font '+'height left letter-spacing line-height list-style-image list-style-position list-style-type list-style margin-top '+'margin-right margin-bottom margin-left margin marker-offset marks mathline max-height max-width min-height min-width orphans '+'outline-color outline-style outline-width outline overflow padding-top padding-right padding-bottom padding-left padding page '+'page-break-after page-break-before page-break-inside pause pause-after pause-before pitch pitch-range play-during position '+'quotes right richness size slope src speak-header speak-numeral speak-punctuation speak speech-rate stemh stemv stress '+'table-layout text-align top text-decoration text-indent text-shadow text-transform unicode-bidi unicode-range units-per-em '+'vertical-align visibility voice-family volume white-space widows width widths word-spacing x-height z-index zoom';var d='above absolute all always aqua armenian attr aural auto avoid baseline behind below bidi-override black blink block blue bold bolder '+'both bottom braille capitalize caption center center-left center-right circle close-quote code collapse compact condensed '+'continuous counter counters crop cross crosshair cursive dashed decimal decimal-leading-zero digits disc dotted double '+'embed embossed e-resize expanded extra-condensed extra-expanded fantasy far-left far-right fast faster fixed format fuchsia '+'gray green groove handheld hebrew help hidden hide high higher icon inline-table inline inset inside invert italic '+'justify landscape large larger left-side left leftwards level lighter lime line-through list-item local loud lower-alpha '+'lowercase lower-greek lower-latin lower-roman lower low ltr marker maroon medium message-box middle mix move narrower '+'navy ne-resize no-close-quote none no-open-quote no-repeat normal nowrap n-resize nw-resize oblique olive once open-quote outset '+'outside overline pointer portrait pre print projection purple red relative repeat repeat-x repeat-y rgb ridge right right-side '+'rightwards rtl run-in screen scroll semi-condensed semi-expanded separate se-resize show silent silver slower slow '+'small small-caps small-caption smaller soft solid speech spell-out square s-resize static status-bar sub super sw-resize '+'table-caption table-cell table-column table-column-group table-footer-group table-header-group table-row table-row-group teal '+'text-bottom text-top thick thin top transparent tty tv ultra-condensed ultra-expanded underline upper-alpha uppercase upper-latin '+'upper-roman url visible wait white wider w-resize x-fast x-high x-large x-loud x-low x-slow x-small x-soft xx-large xx-small yellow';var e='[mM]onospace [tT]ahoma [vV]erdana [aA]rial [hH]elvetica [sS]ans-serif [sS]erif [cC]ourier mono sans serif';var f='important default';var g='import extend debug warn if else for while mixin function include content media';var r=l;this.regexList=[{regex:r.multiLineCComments,css:'comments'},{regex:r.singleLineCComments,css:'comments'},{regex:r.doubleQuotedString,css:'string'},{regex:r.singleQuotedString,css:'string'},{regex:/\#[a-fA-F0-9]{3,6}/g,css:'value'},{regex:/\b(-?\d+)(\.\d+)?(px|em|rem|pt|\:|\%|)\b/g,css:'value'},{regex:/\$[\w-]+/g,css:'variable'},{regex:new RegExp(getKeywordsPrependedBy(f,'!'),'g'),css:'color3'},{regex:new RegExp(getKeywordsPrependedBy(g,'@'),'g'),css:'preprocessor'},{regex:new RegExp(getKeywordsCSS(c),'gm'),css:'keyword'},{regex:new RegExp(getValuesCSS(d),'g'),css:'value'},{regex:new RegExp(this.getKeywords(e),'g'),css:'color1'}]};Brush.prototype=new k();Brush.aliases=['sass','scss'];h.exports=Brush}),(function(c,d,e){'use strict';var f=e(22);var g=e(3).commonRegExp;function Brush(){var a='val sealed case def true trait implicit forSome import match object null finally super '+'override try lazy for var catch throw type extends class while with new final yield abstract '+'else do if return protected private this package false';var b='[_:=><%#@]+';this.regexList=[{regex:g.singleLineCComments,css:'comments'},{regex:g.multiLineCComments,css:'comments'},{regex:g.multiLineSingleQuotedString,css:'string'},{regex:g.multiLineDoubleQuotedString,css:'string'},{regex:g.singleQuotedString,css:'string'},{regex:/0x[a-f0-9]+|\d+(\.\d+)?/gi,css:'value'},{regex:new RegExp(this.getKeywords(a),'gm'),css:'keyword'},{regex:new RegExp(b,'gm'),css:'keyword'}]}Brush.prototype=new f();Brush.aliases=['scala'];c.exports=Brush}),(function(d,e,f){'use strict';var g=f(22);var h=f(3).commonRegExp;function Brush(){var a='abs avg case cast coalesce convert count current_timestamp '+'current_user day isnull left lower month nullif replace right '+'session_user space substring sum system_user upper user year';var b='absolute action add after alter as asc at authorization begin bigint '+'binary bit by cascade char character check checkpoint close collate '+'column commit committed connect connection constraint contains continue '+'create cube current current_date current_time cursor database date '+'deallocate dec decimal declare default delete desc distinct double drop '+'dynamic else end end-exec escape except exec execute false fetch first '+'float for force foreign forward free from full function global goto grant '+'group grouping having hour ignore index inner insensitive insert instead '+'int integer intersect into is isolation key last level load local max min '+'minute modify move name national nchar next no numeric of off on only '+'open option order out output partial password precision prepare primary '+'prior privileges procedure public read real references relative repeatable '+'restrict return returns revoke rollback rollup rows rule schema scroll '+'second section select sequence serializable set size smallint static '+'statistics table temp temporary then time timestamp to top transaction '+'translation trigger true truncate uncommitted union unique update values '+'varchar varying view when where with work';var c='all and any between cross in join like not null or outer some';this.regexList=[{regex:/--(.*)$/gm,css:'comments'},{regex:/\/\*([^\*][\s\S]*?)?\*\//gm,css:'comments'},{regex:h.multiLineDoubleQuotedString,css:'string'},{regex:h.multiLineSingleQuotedString,css:'string'},{regex:new RegExp(this.getKeywords(a),'gmi'),css:'color2'},{regex:new RegExp(this.getKeywords(c),'gmi'),css:'color1'},{regex:new RegExp(this.getKeywords(b),'gmi'),css:'keyword'}]};Brush.prototype=new g();Brush.aliases=['sql'];d.exports=Brush}),(function(h,i,j){'use strict';var k=j(22);var l=j(3).commonRegExp;var m=j(5).Match;function Brush(){function getKeywordsPrependedBy(a,b){return'(?:'+a.replace(/^\s+|\s+$/g,'').replace(/\s+/g,'|'+b+'\\b').replace(/^/,b+'\\b')+')\\b'}function multiLineCCommentsAdd(a,b){var c=a[0],result=[],pos=0,matchStart=0,level=0;while(pos<c.length-1){var d=c.substr(pos,2);if(level==0){if(d=="/*"){matchStart=pos;level++;pos+=2}else{pos++}}else{if(d=="/*"){level++;pos+=2}else if(d=="*/"){level--;if(level==0){result.push(new m(c.substring(matchStart,pos+2),matchStart+a.index,b.css))}pos+=2}else{pos++}}}return result}function stringAdd(a,b){var c=a[0],result=[],pos=0,matchStart=0,level=0;while(pos<c.length-1){if(level==0){if(c.substr(pos,2)=="\\("){result.push(new m(c.substring(matchStart,pos+2),matchStart+a.index,b.css));level++;pos+=2}else{pos++}}else{if(c[pos]=="("){level++}if(c[pos]==")"){level--;if(level==0){matchStart=pos}}pos++}}if(level==0){result.push(new m(c.substring(matchStart,c.length),matchStart+a.index,b.css))}return result};var e='AbsoluteValuable Any AnyClass Array ArrayBound ArrayBuffer ArrayBufferType ArrayLiteralConvertible ArrayType AutoreleasingUnsafePointer BidirectionalIndex Bit BitwiseOperations Bool C CBool CChar CChar16 CChar32 CConstPointer CConstVoidPointer CDouble CFloat CInt CLong CLongLong CMutablePointer CMutableVoidPointer COpaquePointer CShort CSignedChar CString CUnsignedChar CUnsignedInt CUnsignedLong CUnsignedLongLong CUnsignedShort CVaListPointer CVarArg CWideChar Character CharacterLiteralConvertible Collection CollectionOfOne Comparable ContiguousArray ContiguousArrayBuffer DebugPrintable Dictionary DictionaryGenerator DictionaryIndex DictionaryLiteralConvertible Double EmptyCollection EmptyGenerator EnumerateGenerator Equatable ExtendedGraphemeClusterLiteralConvertible ExtendedGraphemeClusterType ExtensibleCollection FilterCollectionView FilterCollectionViewIndex FilterGenerator FilterSequenceView Float Float32 Float64 Float80 FloatLiteralConvertible FloatLiteralType FloatingPointClassification FloatingPointNumber ForwardIndex Generator GeneratorOf GeneratorOfOne GeneratorSequence Hashable HeapBuffer HeapBufferStorage HeapBufferStorageBase ImplicitlyUnwrappedOptional IndexingGenerator Int Int16 Int32 Int64 Int8 IntEncoder IntMax Integer IntegerArithmetic IntegerLiteralConvertible IntegerLiteralType Less LifetimeManager LogicValue MapCollectionView MapSequenceGenerator MapSequenceView MaxBuiltinFloatType MaxBuiltinIntegerType Mirror MirrorDisposition MutableCollection MutableSliceable ObjectIdentifier OnHeap Optional OutputStream PermutationGenerator Printable QuickLookObject RandomAccessIndex Range RangeGenerator RawByte RawOptionSet RawRepresentable Reflectable Repeat ReverseIndex ReverseRange ReverseRangeGenerator ReverseView Sequence SequenceOf SignedInteger SignedNumber Sink SinkOf Slice SliceBuffer Sliceable StaticString Streamable StridedRangeGenerator String StringElement StringInterpolationConvertible StringLiteralConvertible StringLiteralType UInt UInt16 UInt32 UInt64 UInt8 UIntMax UTF16 UTF32 UTF8 UWord UnicodeCodec UnicodeScalar Unmanaged UnsafeArray UnsafePointer UnsignedInteger Void Word Zip2 ZipGenerator2 abs advance alignof alignofValue assert bridgeFromObjectiveC bridgeFromObjectiveCUnconditional bridgeToObjectiveC bridgeToObjectiveCUnconditional c contains count countElements countLeadingZeros debugPrint debugPrintln distance dropFirst dropLast dump encodeBitsAsWords enumerate equal false filter find getBridgedObjectiveCType getVaList indices insertionSort isBridgedToObjectiveC isBridgedVerbatimToObjectiveC isUniquelyReferenced join lexicographicalCompare map max maxElement min minElement nil numericCast partition posix print println quickSort reduce reflect reinterpretCast reverse roundUpToAlignment sizeof sizeofValue sort split startsWith strideof strideofValue swap swift toString transcode true underestimateCount unsafeReflect withExtendedLifetime withObjectAtPlusZero withUnsafePointer withUnsafePointerToObject withUnsafePointers withVaList';var f='as break case class continue default deinit do dynamicType else enum '+'extension fallthrough for func if import in init is let new protocol '+'return self Self static struct subscript super switch Type typealias '+'var where while __COLUMN__ __FILE__ __FUNCTION__ __LINE__ associativity '+'didSet get infix inout left mutating none nonmutating operator override '+'postfix precedence prefix right set unowned unowned(safe) unowned(unsafe) weak willSet';var g='assignment class_protocol exported final lazy noreturn NSCopying NSManaged objc optional required auto_closure noreturn IBAction IBDesignable IBInspectable IBOutlet infix prefix postfix';this.regexList=[{regex:new RegExp('\&[a-z]+;','gi'),css:'plain'},{regex:l.singleLineCComments,css:'comments'},{regex:new RegExp('\\/\\*[\\s\\S]*\\*\\/','g'),css:'comments',func:multiLineCCommentsAdd},{regex:l.doubleQuotedString,css:'string',func:stringAdd},{regex:new RegExp('\\b([\\d_]+(\\.[\\de_]+)?|0x[a-f0-9_]+(\\.[a-f0-9p_]+)?|0b[01_]+|0o[0-7_]+)\\b','gi'),css:'value'},{regex:new RegExp(this.getKeywords(f),'gm'),css:'keyword'},{regex:new RegExp(getKeywordsPrependedBy(g,'@'),'gm'),css:'color1'},{regex:new RegExp(this.getKeywords(e),'gm'),css:'color2'},{regex:new RegExp('\\b([a-zA-Z_][a-zA-Z0-9_]*)\\b','gi'),css:'variable'}]};Brush.prototype=new k();Brush.aliases=['swift'];h.exports=Brush}),(function(a,b,c){'use strict';var d=c(22);var e=c(3).commonRegExp;function Brush(){this.regexList=[{regex:new RegExp('^1..\\d+','gm'),css:'plain bold italic'},{regex:new RegExp('^ok( \\d+)?','gm'),css:'keyword'},{regex:new RegExp('^not ok( \\d+)?','gm'),css:'color3 bold'},{regex:new RegExp('(?!^\\s*)#.*$','gm'),css:'variable bold'},{regex:new RegExp('^#.*$','gm'),css:'comments bold'},{regex:new RegExp('^(?!(not )?ok)[^1].*$','gm'),css:'comments'},{regex:e.doubleQuotedString,css:'string'},{regex:e.singleQuotedString,css:'string'}]}Brush.prototype=new d();Brush.aliases=['tap','Tap','TAP'];a.exports=Brush}),(function(b,c,d){'use strict';var e=d(22);var f=d(3).commonRegExp;function Brush(){var a='break case catch class continue '+'default delete do else enum export extends false  '+'for function if implements import in instanceof '+'interface let new null package private protected '+'static return super switch '+'this throw true try typeof var while with yield'+' any bool declare get module never number public readonly set string';this.regexList=[{regex:f.multiLineDoubleQuotedString,css:'string'},{regex:f.multiLineSingleQuotedString,css:'string'},{regex:f.singleLineCComments,css:'comments'},{regex:f.multiLineCComments,css:'comments'},{regex:new RegExp(this.getKeywords(a),'gm'),css:'keyword'}];this.forHtmlScript(f.scriptScriptTags)};Brush.prototype=new e();Brush.aliases=['ts','typescript'];b.exports=Brush}),(function(b,c,d){'use strict';var e=d(22);var f=d(3).commonRegExp;function Brush(){var a='AddHandler AddressOf AndAlso Alias And Ansi As Assembly Auto '+'Boolean ByRef Byte ByVal Call Case Catch CBool CByte CChar CDate '+'CDec CDbl Char CInt Class CLng CObj Const CShort CSng CStr CType '+'Date Decimal Declare Default Delegate Dim DirectCast Do Double Each '+'Else ElseIf End Enum Erase Error Event Exit False Finally For Friend '+'Function Get GetType GoSub GoTo Handles If Implements Imports In '+'Inherits Integer Interface Is Let Lib Like Long Loop Me Mod Module '+'MustInherit MustOverride MyBase MyClass Namespace New Next Not Nothing '+'NotInheritable NotOverridable Object On Option Optional Or OrElse '+'Overloads Overridable Overrides ParamArray Preserve Private Property '+'Protected Public RaiseEvent ReadOnly ReDim REM RemoveHandler Resume '+'Return Select Set Shadows Shared Short Single Static Step Stop String '+'Structure Sub SyncLock Then Throw To True Try TypeOf Unicode Until '+'Variant When While With WithEvents WriteOnly Xor';this.regexList=[{regex:/'.*$/gm,css:'comments'},{regex:f.doubleQuotedString,css:'string'},{regex:/^\s*#.*$/gm,css:'preprocessor'},{regex:new RegExp(this.getKeywords(a),'gm'),css:'keyword'}];this.forHtmlScript(f.aspScriptTags)};Brush.prototype=new e();Brush.aliases=['vb','vbnet'];b.exports=Brush}),(function(e,f,g){'use strict';var h=g(22);var i=g(3).commonRegExp;var j=g(3).XRegExp;var k=g(5).Match;function Brush(){function process(a,b){var c=a[0],tag=j.exec(c,j('(&lt;|<)[\\s\\/\\?!]*(?<name>[:\\w-\\.]+)','xg')),result=[];if(a.attributes!=null){var d,pos=0,regex=j('(?<name> [\\w:.-]+)'+'\\s*=\\s*'+'(?<value> ".*?"|\'.*?\'|\\w+)','xg');while((d=j.exec(c,regex,pos))!=null){result.push(new k(d.name,a.index+d.index,'color1'));result.push(new k(d.value,a.index+d.index+d[0].indexOf(d.value),'string'));pos=d.index+d[0].length}}if(tag!=null)result.push(new k(tag.name,a.index+tag[0].indexOf(tag.name),'keyword'));return result}this.regexList=[{regex:j('(\\&lt;|<)\\!\\[[\\w\\s]*?\\[(.|\\s)*?\\]\\](\\&gt;|>)','gm'),css:'color2'},{regex:i.xmlComments,css:'comments'},{regex:j('(&lt;|<)[\\s\\/\\?!]*(\\w+)(?<attributes>.*?)[\\s\\/\\?]*(&gt;|>)','sg'),func:process}]};Brush.prototype=new h();Brush.aliases=['xml','xhtml','xslt','html','plist'];e.exports=Brush}),(function(c,d,e){'use strict';var f=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(a){return typeof a}:function(a){return a&&typeof Symbol==="function"&&a.constructor===Symbol&&a!==Symbol.prototype?"symbol":typeof a};!function(a,b){if(true)c.exports=b();else if(typeof define=='function'&&f(define.amd)=='object')define(b);else this[a]=b()}('domready',function(){var b=[],_listener,doc=document,hack=doc.documentElement.doScroll,domContentLoaded='DOMContentLoaded',loaded=(hack?/^loaded|^c/:/^loaded|^i|^c/).test(doc.readyState);if(!loaded)doc.addEventListener(domContentLoaded,_listener=function listener(){doc.removeEventListener(domContentLoaded,_listener);loaded=1;while(_listener=b.shift()){_listener()}});return function(a){loaded?setTimeout(a,0):b.push(a)}})}),(function(d,e){'use strict';Object.defineProperty(e,"__esModule",{value:true});var f=e.string=function f(b){return b.replace(/^([A-Z])/g,function(_,a){return a.toLowerCase()}).replace(/([A-Z])/g,function(_,a){return'-'+a.toLowerCase()})};var g=e.object=function g(b){var c={};Object.keys(b).forEach(function(a){return c[f(a)]=b[a]});return c}})]);
