<?php

use Dev4Press\Plugin\GDBBX\Basic\Cache;
use Dev4Press\Plugin\GDBBX\Basic\Loader;
use Dev4Press\Plugin\GDBBX\Basic\Feed;
use Dev4Press\Plugin\GDBBX\Basic\Forum;
use Dev4Press\Plugin\GDBBX\Basic\Mailer;
use Dev4Press\Plugin\GDBBX\Basic\Roles;
use Dev4Press\Plugin\GDBBX\Basic\Signs;
use Dev4Press\Plugin\GDBBX\Basic\User;
use Dev4Press\Plugin\GDBBX\Basic\Wizard;
use Dev4Press\Plugin\GDBBX\Features\CannedReplies;
use Dev4Press\Plugin\GDBBX\Features\ForumIndex;
use Dev4Press\Plugin\GDBBX\Features\LockForums;
use Dev4Press\Plugin\GDBBX\Features\PrivateReplies;
use Dev4Press\Plugin\GDBBX\Features\PrivateTopics;
use Dev4Press\Plugin\GDBBX\Features\Profiles;
use Dev4Press\Plugin\GDBBX\Features\Quote;
use Dev4Press\Plugin\GDBBX\Features\Report;
use Dev4Press\Plugin\GDBBX\Features\Signatures;
use Dev4Press\Plugin\GDBBX\Features\Thanks;

if (!defined('ABSPATH')) {
    exit;
}

/** @return Cache */
function gdbbx_cache() : Cache {
    return Cache::instance();
}

/** @return Roles */
function gdbbx_roles() : Roles {
    return Roles::instance();
}

/** @return Signs */
function gdbbx_signs() : Signs {
    return Signs::instance();
}

/** @return Feed */
function gdbbx_feed() : Feed {
	return Feed::instance();
}

/** @return Mailer */
function gdbbx_mailer() : Mailer {
    return Mailer::instance();
}

/**
 * @param positive-int $id
 *
 * @return Forum
 */
function gdbbx_forum($id = 0) : Forum {
    return Forum::instance($id);
}

/**
 * @param positive-int $id
 *
 * @return User
 */
function gdbbx_user($id = 0) : User {
    return User::instance($id);
}

/** @return Wizard */
function gdbbx_wizard() : Wizard {
	return Wizard::instance();
}

/** @return bool|\Dev4Press\Plugin\GDBBX\Features\Signatures */
function gdbbx_signature() {
    return Loader::instance()->is_enabled('signatures') ? Signatures::instance() : false;
}

/** @return bool|\Dev4Press\Plugin\GDBBX\Features\Quote */
function gdbbx_quote() {
    return Loader::instance()->is_enabled('quote') ? Quote::instance() : false;
}

/** @return bool|\Dev4Press\Plugin\GDBBX\Features\Report */
function gdbbx_report() {
    return Loader::instance()->is_enabled('report') ? Report::instance() : false;
}

/** @return bool|\Dev4Press\Plugin\GDBBX\Features\Profiles */
function gdbbx_user_profiles() {
    return Loader::instance()->is_enabled('profiles') ? Profiles::instance() : false;
}

/** @return bool|\Dev4Press\Plugin\GDBBX\Features\ForumIndex */
function gdbbx_forum_index() {
    return Loader::instance()->is_enabled('forum-index') ? ForumIndex::instance() : false;
}

/** @return bool|\Dev4Press\Plugin\GDBBX\Features\LockForums */
function gdbbx_lock_forums() {
    return Loader::instance()->is_enabled('lock-forums') ? LockForums::instance() : false;
}

/** @return bool|\Dev4Press\Plugin\GDBBX\Features\PrivateTopics */
function gdbbx_private_topics() {
    return Loader::instance()->is_enabled('private-topics') ? PrivateTopics::instance() : false;
}

/** @return bool|\Dev4Press\Plugin\GDBBX\Features\PrivateReplies */
function gdbbx_private_replies() {
    return Loader::instance()->is_enabled('private-replies') ? PrivateReplies::instance() : false;
}

/** @return bool|\Dev4Press\Plugin\GDBBX\Features\Thanks */
function gdbbx_say_thanks() {
    return Loader::instance()->is_enabled('thanks') ? Thanks::instance() : false;
}

/** @return bool|\Dev4Press\Plugin\GDBBX\Features\CannedReplies */
function gdbbx_canned_replies() {
    return Loader::instance()->is_enabled('canned-replies') ? CannedReplies::instance() : false;
}
