<?php

use Dev4Press\Plugin\GDBBX\Basic\bbPress;
use Dev4Press\Plugin\GDBBX\Basic\Loader;
use Dev4Press\Plugin\GDBBX\Basic\Enqueue;
use Dev4Press\Plugin\GDBBX\Basic\Feed;
use Dev4Press\Plugin\GDBBX\Basic\Navigation;
use Dev4Press\Plugin\GDBBX\Basic\Requests;
use Dev4Press\Plugin\GDBBX\Basic\Search;
use Dev4Press\Plugin\GDBBX\Basic\Template;
use Dev4Press\Plugin\GDBBX\Basic\Widgets;

if (!defined('ABSPATH')) { exit; }

class gdbbx_core_loader {
    public $svg_icon = 'data:image/svg+xml;base64,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';

    public $buddypress = false;
    public $debug = false;

    public $modules = array();
    public $objects = array();

    public $is_search = false;
    public $is_feed = false;

    function __construct() {
        add_action('plugins_loaded', array($this, 'core'));
        add_action('template_redirect', array($this, 'template_redirect'), 7);
        add_action('gdbbx_plugin_settings_loaded', array($this, 'early'));
    }

    public function core() {
        $this->debug = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG;
        $this->buddypress = gdbbx_has_buddypress();

        if (GDBBX_WPV < 50) {
            add_action('admin_notices', array($this, 'system_requirements_problem'));
        }

        if (gdbbx_has_bbpress()) {
            add_action('bbp_init', array($this, 'load'), 1);
            add_action('bbp_init', array($this, 'init'), 2);
            add_action('bbp_feed', array($this, 'feed'), 5);

            add_action('bbp_ready', array($this, 'ready'));
        } else {
            add_action('admin_notices', array($this, 'bbpress_requirements_problem'));
        }
    }

    public function deactivate() {
        deactivate_plugins('gd-bbpress-toolbox/gd-bbpress-toolbox.php', false);
    }

    public function early() {
        if (!gdbbx_has_bbpress()) {
            return;
        }

        Loader::instance()->run_early();
    }

    public function load() {
        if (function_exists('bbp_is_search')) {
            $this->is_search = bbp_is_search();
        }

        bbPress::instance();
        Requests::instance();
        Feed::instance();
        Search::instance();

        Loader::instance()->run_global();

        if (is_admin()) {
            Loader::instance()->run_admin();
        } else {
            Loader::instance()->run_frontend();
        }

        $this->modules();

        Widgets::instance();
        Enqueue::instance();
        Template::instance();
        Navigation::instance();
    }

    public function init() {
        do_action('gdbbx_init');
    }

    public function feed() {
        $this->is_feed = true;

	    do_action('gdbbx_feed');
    }

    public function ready() {
        do_action('gdbbx_core');
    }

    public function template_redirect() {
        do_action('gdbbx_template');
    }

    public function modules() {
        require_once(GDBBX_PATH.'modules/attachments/load.php');
        $this->modules['attachments'] = 'loaded';

        if (!D4P_CRON) {
            require_once(GDBBX_PATH.'modules/features/mod.tracking.php');
            $this->modules['tracking'] = new gdbbx_mod_tracking();

            require_once(GDBBX_PATH.'modules/features/mod.online.php');
            $this->modules['online'] = new gdbbx_mod_online();
        }

        if (gdbbx()->get('bbcodes_active', 'tools')) {
            require_once(GDBBX_PATH.'modules/bbcodes/load.php');
            $this->modules['bbcodes'] = new gdbbx_mod_bbcodes();

            if (!is_admin() && gdbbx()->get('bbcodes_toolbar_active', 'tools') && !bbp_use_wp_editor()) {
                require_once(GDBBX_PATH.'modules/bbcodes/toolbar.php');
                $this->modules['bbcodes_toolbar'] = new gdbbx_mod_bbcodes_toolbar();
            }
        }

        if ($this->buddypress) {
            require_once(GDBBX_PATH.'modules/buddypress/load.php');
            $this->modules['buddypress'] = new gdbbx_mod_buddypress();
        }
    }

    public function system_requirements_problem() {
        ?>

        <div class="notice notice-error">
            <p><?php _e("GD bbPress Toolbox Pro requires WordPress 5.0 or newer. Plugin will now be disabled. To use this plugin, upgrade WordPress to 5.0 or newer version.", "gd-bbpress-toolbox"); ?></p>
        </div>

        <?php

        $this->deactivate();
    }

    public function bbpress_requirements_problem() {
        ?>

        <div class="notice notice-error">
            <p><?php _e("GD bbPress Toolbox Pro requires bbPress plugin for WordPress version 2.6.2 or newer. Plugin will now be disabled. To use this plugin, make sure you are using bbPress 2.6.2 or newer version.", "gd-bbpress-toolbox"); ?></p>
        </div>

        <?php

        $this->deactivate();
    }
}
