{extends file="layouts/main.tpl"}

{block name=contents}
<style>
{literal}
    #showSpin {
        display:none;
    }
{/literal}
</style>
<div class="section-headline-wrap">
    <div class="section-headline">
        <h2>{$post->forum_title|truncate:50}</h2>
        <p><a href="{$url.main}" style="color:#fff;">Home</a><span class="separator">/</span><a href="{$url.main}forum" style="color:#fff;">{$app.name} Forums</a><span class="separator">/</span><a href="{$url.main}forum/category/{$post->fcat_slug}" style="color:#fff;"><span class="current-section">{$post->fcat_name}</span></a></p>
    </div>
</div>

<div class="section-wrap">
    <div class="section">

        <!-- CONTENT -->
        <div class="content left">
            {$form_alert}
            <!-- THREAD -->
            <div class="thread">
                <!-- THREAD TITLE -->
                <div class="thread-title">
                    <p class="text-header">{$post->forum_title}</p>
                </div>
                <!-- /THREAD TITLE -->

                <!-- COMMENTS -->
                <div class="comment-list">
                    <div id="get-contents">
                        {if $url_4 < 2}
                        <!-- COMMENT -->
                        <div class="comment-wrap">
                            <!-- USER AVATAR -->
                            <a href="{$url.main}{$post->user_username}">
                                <figure class="user-avatar medium">
                                    <img src="{$u_photo}{$post->user_avater}" alt="">
                                </figure>
                            </a>
                            <!-- /USER AVATAR -->
                            <div class="comment">
                                <p class="text-header">{$post->user_firstname} {$post->user_lastname}</p>
                                <p class="timestamp">{Carbon\Carbon::parse($post->fourm_created_at)->diffForHumans(['options' => Carbon\Carbon::ONE_DAY_WORDS])}</p>
                                {if $post->forum_user_id eq $usr.myid}
                                <a href="{$url.main}forum/edit/{$post->forum_slug}" class="reply">Edit</a>
                                <form action="{$url.main}forum/del_forum" method="post" onsubmit="return confirm('Are you sure you want to Delete?');">
                                    {$csrf_token}
                                    <input type="hidden" name="del" value="{$post->forum_id}">
                                    <a onclick="this.closest('form').submit();return false;" href="javascript:void(0);" class="report">Delete</a>
                                </form>
                                {/if}
                                <p>{nl2br(auto_link($post->forum_body))}</p>
                            </div>
                        </div>
                        <!-- /COMMENT -->
                        {/if}

                        {if $replies}
                        <!-- LINE SEPARATOR -->
                        {foreach from=$replies item=$rp}
                        <hr class="line-separator">
                        <!-- /LINE SEPARATOR -->

                        <!-- COMMENT -->
                        <div class="comment-wrap" id="grab{$rp->fr_id}">
                            <!-- USER AVATAR -->
                            <a href="{$url.main}{$rp->user_username}">
                                <figure class="user-avatar medium">
                                    <img src="{$u_photo}{$rp->user_avater}" alt="">
                                </figure>
                            </a>
                            <!-- /USER AVATAR -->
                            <div class="comment">
                                <p class="text-header">{$rp->user_firstname} {$rp->user_lastname}</p>
                                <p class="timestamp">{Carbon\Carbon::parse($rp->fr_created_at)->diffForHumans(['options' => Carbon\Carbon::ONE_DAY_WORDS])}</p>
                                {if $rp->fr_user_id eq $usr.myid}
                                <a href="{$url.main}/forum/edit-reply/{$rp->	fr_id}" class="reply">Edit</a>
                                <a href="javascript:void(0);" id="rmv-{$rp->fr_id}" class="report">Delete</a>
                                {/if}
                                <p id="cmt{$rp->fr_id}">{nl2br(auto_link($rp->fr_comment))}</p>
                            </div>
                        </div>
                        {/foreach}
                        {/if}
                    </div>
                    <!-- /LINE SEPARATOR -->
                    <center id="showSpin"><i class="fa fa-spinner fa-spin" style="margin-top:60px;"></i></center>

                    <!-- PAGER -->
                    {include file="inc/pager/index.tpl"}
                    <!-- /PAGER -->

                    <div class="clearfix"></div>

                    <!-- LINE SEPARATOR -->
                    <hr class="line-separator">
                    <!-- /LINE SEPARATOR -->
                    {if $is_login}
                    <h3>Leave a Comment</h3>

                    <!-- COMMENT REPLY -->
                    <div class="comment-wrap comment-reply">
                        <!-- USER AVATAR -->
                        <a href="javascript:void(0);">
                            <figure class="user-avatar medium">
                                <img src="{$u_photo}{$usr.avater}" alt="">
                            </figure>
                        </a>
                        <!-- /USER AVATAR -->

                        <!-- COMMENT REPLY FORM -->
                        <form class="comment-reply-form" id="postCmt" method="post">
                            {$csrf_token}
                            <textarea name="treply" placeholder="Write your comment here..." required></textarea>
                            <button type="submit" id="treply-btn" class="button primary">Post Comment</button>
                        </form>
                        <!-- /COMMENT REPLY FORM -->
                    </div>
                    <!-- /COMMENT REPLY -->
                    {/if}
                </div>
                <!-- /COMMENTS -->
            </div>
            <!-- /THREAD -->
        </div>
        <!-- /CONTENT -->
        {include file="inc/body/sidebar.tpl"}
    </div>
</div>
{/block}

{block name=reply_js}
<script>
{literal}
    $(document).ready(function() {
        $('#postCmt').on('submit', function(e) {
            e.preventDefault();

            $(document).ajaxStart(function() {
                $('#showSpin').show();
                $('#treply-btn').fadeOut();
            });

            $.ajax({
                url: '{/literal}{$url.main}forum/post_new_reply/{$post->forum_id}{literal}',
                method: 'POST',
                processData: false,
                cache: false,
                contentType: false,
                data: new FormData(this),
                success: function(data)
                {
                    $('form').trigger('reset');
                    $('#get-contents').append(data);
                }
            });

            $(document).ajaxComplete(function() {
                $('#showSpin').hide();
                $('#treply-btn').fadeIn();
            });
        });
    });
{/literal}
</script>

{if $replies}
    {foreach from=$replies item=$rp}
        <script>
            {literal}
                $(document).ready(function() {
                    $('#rmv-{/literal}{$rp->fr_id}{literal}').on('click', function() {
                        $(document).ajaxStart(function() {
                            $('#cmt{/literal}{$rp->fr_id}{literal}').html('<center><i class="fa fa-spinner fa-spin"></i></center>');
                        });

                        $.ajax({
                            url: '{/literal}{$url.main}forum/remove_reply/{$rp->fr_id}{literal}',
                            method: 'GET',
                            success: function(data)
                            {
                                if(data === 'done')
                                {
                                    $('#grab{/literal}{$rp->fr_id}{literal}').remove();
                                }
                            }
                        });
                    });
                });
            {/literal}
        </script>
    {/foreach}
{/if}
{/block}