{extends file="layouts/main.tpl"}

{block name=contents}
<div class="section-headline-wrap">
    <div class="section-headline">
        <h2>{$cats->fcat_name}</h2>
        <p><a href="{$url.main}" style="color:#fff;">Home</a><span class="separator">/</span><span class="current-section">{$app.name} Forums</span></p>
    </div>
</div>

<div class="section-wrap">
	<div class="section">
        <div class="content left">
            <!-- FORUM -->
            <div class="forum">
                <!-- FORUM HEADER -->
                <div class="forum-header">
                    <div class="forum-title">
                        <p class="text-header small">Forum</p>
                    </div>
                    <div class="forum-replies">
                        <p class="text-header small">Replies</p>
                    </div>
                    <div class="forum-lastpost">
                        <p class="text-header small">Last Post</p>
                    </div>
                </div>
                <!-- /FORUM HEADER -->

                <!-- FORUM SECTION -->
                <div class="forum-subsection">
                    <p class="text-header">Search result: {$search}</p>
                </div>
                <!-- /FORUM SECTION -->

                {if $results}
                <!-- THREAD LIST -->
                <div class="thread-list">
                    {foreach from=$results item=$forum}
                    <!-- THREAD LIST ITEM -->
                    <div class="thread-list-item">
                        <figure class="user-avatar small">
                            <img src="{$u_photo}{$forum->user_avater}" alt="">
                        </figure>
                        <div class="forum-title">
                            <p class="text-header title">
                                <a href="{$url.main}forum/topic/{$forum->forum_slug}">{$forum->forum_title}</a>
                            </p>
                        </div>

                        <div class="forum-replies">
                            <p class="replies">{$forum->total_reply}</p>
                        </div>

                        <div class="forum-lastpost">
                            {if $forum->last_reply}
                            <p class="lastpost">{Carbon\Carbon::parse($forum->last_reply->fr_created_at)->diffForHumans(['options' => 'Carbon\Carbon::ONE_DAY_WORDS'])} by <span>{$forum->last_reply->user_username|ucfirst}</span></p>
                            {else}
                            <p class="lastpost">{Carbon\Carbon::parse($forum->fourm_created_at)->diffForHumans(['options' => 'Carbon\Carbon::ONE_DAY_WORDS'])} by <span>{$forum->user_username|ucfirst}</span></p>
                            {/if}
                        </div>
                    </div>
                    <!-- /THREAD LIST ITEM -->
                    {/foreach}

                </div>
                <!-- /THREAD LIST -->
                {else}
                    <center><b>No result found!</b></center>
                {/if}
            </div>
            <!-- /FORUM -->

            <!-- PAGER -->
            {include file="inc/pager/index.tpl"}
            <!-- /PAGER -->
        </div>

        {include file="inc/body/sidebar.tpl"}
    </div>
</div>
{/block}