{extends file="layouts/credit.tpl"}

{block name=contents}

<section class="section--padding2 bgcolor">

<div class="shortcode_wrapper">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="shortcode_module_title">
                    <div class="dashboard__title">
                        <h3>Choose Credit Package</h3>
                    </div>
                </div>
            </div>
        </div>

        {if $packs}
        <div class="container">
            <div class="row">

                {foreach from=$packs item=$pack}
                <div class="col-xs-12 col-sm-6 col-md-3 col-lg-3">
                    <div class="panels text-center price-panels panels-{$pack->pack_color}">
                        <div class="panels-heading">
                        <h3>{$pack->pack_name}</h3>
                        </div>
                        <div class="panels-body">
                        <p class="lead big-lead"><strong>{$app.currency} {$pack->pack_price}</strong></p>
                        </div>
                        <ul class="list-group">
                        <li class="list-group-item"><i class="fa fa-check text-success"></i> INstantly Credited</li>
                        <li class="list-group-item"><i class="fa fa-check  text-success"></i> No Extra Charges</li>
                        </ul>
                        <div class="panels-footer">
                        <a href="#buyCredit{$pack->pack_id}" data-toggle="modal" class="btn btn-lg btn-block btn-{if $pack->pack_color eq 'grey'}default{elseif $pack->pack_color eq 'blue'}primary{elseif $pack->pack_color eq 'red'}danger{elseif $pack->pack_color eq 'green'}success{/if}">BUY NOW!</a>
                        </div>
                    </div>
                </div>
                {/foreach}

                


            </div>
        </div>
        {/if}
        <hr>
    </div>
</div>

{if $packs}
    {foreach from=$packs item=$pack}
        <div class="modal fade rating_modal" id="buyCredit{$pack->pack_id}" tabindex="-1" role="dialog" aria-labelledby="rating_modal">
        <div class="modal-dialog modalg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h3 class="modal-title" id="rating_modal">Payment Methods</h3>
                    <h5 class="text-center text-info">Select Prefered Payment Method</h5>
                </div>
                <!-- end /.modal-header -->

                <div class="modal-body">
                        
                    <div class="row">
                        {if $paypal->pg_status eq 1}
                        <div class="{if $stripe->sg_status != 1}col-md-12 col-xs-12 col-sm-12{else}col-md-6 col-xs-6 col-sm-6{/if}">
                            <center><div id="paypal-button{$pack->pack_id}"></div></center>
                        </div>
                        {/if}

                        {if $stripe->sg_status eq 1}
                        <div class="{if $paypal->pg_status != 1}col-md-12 col-xs-12 col-sm-12{else}col-md-6 col-xs-6 col-sm-6{/if}">
                            <div id="buynow{$pack->pack_id}">
                                <button class="btn btn-primary btn-block btn--round btn-lg stripe-button" id="payButton{$pack->pack_id}">Pay With Stripe</button>
                                <input type="hidden" id="payProcess{$pack->pack_id}" value="0"/>
                            </div>
                        </div>
                        {/if}

                        <div class="col-md-12 text-center">
                            <div id="paymentDetails{$pack->pack_id}" style="display: none;">
                                <p class="aligncenter green bigger" text-center>Your payment was successful.</p>
                                <h4 class="text-center">Payment Information</h4>
                                <p>
                                Order ID: <span class="text-center" id="orderID{$pack->pack_id}">&#x3C;ORDER_ID&#x3E;</span><br/>
                                Transaction ID: <span class="text-center" id="txnID{$pack->pack_id}">&#x3C;TX_ID&#x3E;</span><br/>
                                </p>
                                <a href="{$url.main}buy-credit" type="button" class="btn btn-Primary btn-block btn-lg">Click Here If Not Redirected</a>
                            </div>
                        </div>

                        {if $btc->btc_status eq 1}
                        <div class="col-md-12 col-sm-12 col-xs-12 col-12">
                            <center>
                            {* <p><strong><small>{$app.currency}{$btc->btc_tax} Tax Charges</small></strong></p> *}
                            <a href="javascript:void(0);" id="btc{$pack->pack_id}"><img src="{$url.main}static/pay/btc.png" style="height:100px" alt=""></a>
                            <span style="display:none;" id="btcWait{$pack->pack_id}"><i style="padding:50px;" class="fa fa-spinner fa-spin"></i></span>
                            <span id="btcReport{$pack->pack_id}"></span>
                            </center>
                        </div>
                        {/if}

                    </div>
                </div>
                <!-- end /.modal-body -->
                <div class="modal-footer">
                    <button type="button" class="btn btn--round modal_close" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>


    <script src="https://www.paypalobjects.com/api/checkout.js"></script>

        <script>
        {literal}
        paypal.Button.render({
            // Configure environment
            env: '{/literal}{$env}{literal}',
            client: {
                sandbox: '{/literal}{$sandbox}{literal}',
                production: '{/literal}{$production}{literal}'
            },
            // Customize button (optional)
            locale: 'en_US',
            style: {
                size: 'responsive',
                color: 'gold',
                shape: 'pill',
                label: 'buynow',
                tagline: 'true',
                fundingicons: 'true',
            },
            // Set up a payment
            payment: function (data, actions) {
                return actions.payment.create({
                transactions: [
                    {
                        amount: { total: '{/literal}{$pack->pack_price}', currency: '{$app.currency_code}{literal}' },
                        item_list: {
                            items: [
                                {
                                name: '{/literal}{$pack->pack_name} Credit Package',
                                description: 'Purchase {$pack->pack_name} Credit Package',
                                quantity: '1',
                                price: '{$pack->pack_price}',
                                currency: '{$app.currency_code}' {literal}
                                }
                            ]
                        }
                    }
                ]
            });
            },
            // Execute the payment
            onAuthorize: function (data, actions) {
                return actions.payment.execute()
                .then(function () {
                    // Show a confirmation message to the buyer
                    //window.alert('Thank you for your purchase!');
                    
                    // Redirect to the payment process page
                    window.location = "{/literal}{$url.main}{literal}checkout/process_credit_purchase?paymentID="+data.paymentID+"&token="+data.paymentToken+"&payerID="+data.payerID+"&itd={/literal}{$pack->pack_id}{literal}&pay_method=paypal";
                });
            }
        }, '#paypal-button{/literal}{$pack->pack_id}{literal}');
        {/literal}
        </script>

        <script type="text/javascript">

        $("#paypal-button{$pack->pack_id}").trigger('click');

        </script>

        <script>
        {literal}
            
        var handler = StripeCheckout.configure({
            key: '{/literal}{$publishable_key}',
            image: '{$app.logo}{literal}',
            locale: 'auto',
            token: function(token) {
                // You can access the token ID with `token.id`.
                // Get the token ID to your server-side code for use.
                
                $('#paymentDetails{/literal}{$pack->pack_id}').hide();
                $('#payProcess{$pack->pack_id}{literal}').val(1);
                $.ajax({
                    url: '{/literal}{$url.main}checkout/stripe_process_purchase_credit{literal}',
                    type: 'POST',
                    data: {_token: '{/literal}{$csrf_value}', item_id: {$pack->pack_id}{literal}, stripeToken: token.id, stripeEmail: token.email, itemName: '{/literal}{$pack->pack_name}', itemPrice: {$pack->pack_price}{'00'}, currency: '{$app.currency_code|strtolower}{literal}'},
                    dataType: "json",
                    beforeSend: function(){
                        $('#payButton{/literal}{$pack->pack_id}').prop('disabled', true);
                        $('#payButton{$pack->pack_id}{literal}').html('Please wait...');
                    },
                    success: function(data){
                        $('#payProcess{/literal}{$pack->pack_id}{literal}').val(0);
                        if(data.status == 1){
                            $('#buynow{/literal}{$pack->pack_id}{literal}').hide();
                            $('#txnEmail{/literal}{$pack->pack_id}{literal}').html(token.email);
                            $('#orderID{/literal}{$pack->pack_id}{literal}').html(data.txnData.id);
                            $('#txnID{/literal}{$pack->pack_id}{literal}').html(data.txnData.balance_transaction);
                            $('#paymentDetails{/literal}{$pack->pack_id}{literal}').show();
                        }else {
                            $('#payButton{/literal}{$pack->pack_id}{literal}').prop('disabled', false);
                            $('#payButton{/literal}{$pack->pack_id}{literal}').html('Buy Now');
                            alert('Some problem occurred, please try again.');
                        }
                    },
                    error: function(data) {
                        $('#payProcess{/literal}{$pack->pack_id}{literal}').val(0);
                        $('#payButton{/literal}{$pack->pack_id}{literal}').prop('disabled', false);
                        $('#payButton{/literal}{$pack->pack_id}{literal}').html('Buy Now');
                        alert('Some problem occurred, please try again but paid.');
                    }
                });
            }
        });

        var stripe_closed = function(){
            var processing = $('#payProcess{/literal}{$pack->pack_id}{literal}').val();
            if (processing == 0){
                $('#payButton{/literal}{$pack->pack_id}{literal}').prop('disabled', false);
                $('#payButton{/literal}{$pack->pack_id}{literal}').html('Pay With Stripe');
            }
        };

        var eventTggr = document.getElementById('payButton{/literal}{$pack->pack_id}{literal}');
        if(eventTggr){
            eventTggr.addEventListener('click', function(e) {
                $('#payButton{/literal}{$pack->pack_id}{literal}').prop('disabled', true);
                $('#payButton{/literal}{$pack->pack_id}{literal}').html('Please wait...');
                
                // Open Checkout with further options:
                handler.open({
                    name: '{/literal}{$app.name}',
                    description: 'Purchase {$pack->pack_name} Credit Package From {$app.name}',
                    amount: {$pack->pack_price}{'00'},
                    currency: '{$app.currency_code|strtolower}{literal}',
                    closed:	stripe_closed
                });
                e.preventDefault();
            });
        }

        // Close Checkout on page navigation:
        window.addEventListener('popstate', function() {
        handler.close();
        });


        {/literal}

        </script>


    {/foreach}
{/if}
    
{/block}


{block name=credit_style}
{literal}
    <style>
        .big-lead {
            font-size: 30px;
            color: #fff;
        }

        .price-panels,
        .price-panels > .panels-heading {
            -webkit-transition: all .3s ease;
            -moz-transition: all .3s ease;
            -o-transition: all .3s ease;
            transition: all .3s ease;
        }

        .price-panels:hover {
            box-shadow: 0 0 30px rgba(0,0,0, .2);
        }
        .price-panels:hover > .panels-heading {
            box-shadow: 0 0 30px rgba(0,0,0, .2) inset;
        }

        .price-panels > .panels-heading {
            color: white;
            text-shadow: 0 3px 0 rgba(50,50,50, .6);
            border-radius: 0;
            box-shadow: 0 5px 0 rgba(50,50,50, .2) inset;
        }
        .price-panels > .panels-body {
            color: white;
            text-shadow: 0 3px 0 rgba(50,50,50, .3);
        }
        .price-panels > .list-group {
            font-weight: 600;
        }
        .price-panels > .panels-footer {
            box-shadow: 0 3px 0 rgba(0,0,0, .3);
        }

        .panels-grey > .panels-heading {
            background-color: #6d6d6d;
            border-color: #b7b7b7;
        }
        .panels-grey > .panels-body {
            background-color: #808080;
        }

        .panels-blue > .panels-heading {
            background-color: #608bb4;
            border-color: #78aee1;
        }
        .panels-blue > .panels-body {
            background-color: #73a3d4;
        }

        .panels-green > .panels-heading {
            background-color: #57ac57;
            border-color: #71df71;
        }
        .panels-green > .panels-body {
            background-color: #65c965;
        }

        .panels-red > .panels-heading {
            background-color: #d04e50;
            border-color: #ff6062;
        }
        .panels-red > .panels-body {
            background-color: #ef5a5c;
        }
    </style>
{/literal}
{/block}

{block name=stripe_js}
<script src="https://checkout.stripe.com/checkout.js"></script>
{/block}

{block name=process_btc_creadt}
{if $packs}
    {foreach from=$packs item=$pack}
<script>
    {literal}
        $(document).ready(function() {
            $('#btc{/literal}{$pack->pack_id}{literal}').on('click', function()
            {
                $(this).hide();
                $('#btcWait{/literal}{$pack->pack_id}{literal}').fadeIn('slow');
                var item = {/literal}{$pack->pack_id}{literal};

                $.ajax({
                    url: '/checkout/prepare_credit_btc_txn',
                    method: 'POST',
                    data: {item:item},
                    success: function(data)
                    {
                        $('#btcReport{/literal}{$pack->pack_id}{literal}').html(data);
                    }
                });
            });
        });
    {/literal}
</script>
{/foreach}
{/if}
    
{/block}