{extends file="layouts/admin.tpl"}

{block name=contents}
<div class="grid simple">
    <div class="grid-title">
        <h4>Credit System</h4>
    </div>
    <div class="grid-body">
        {$form_alert}
        <div class="row">
            <div class="col-md-4">
                <form action="{$url.admin}/create_new_credit_pack" method="post" autocomplete="off">
                    {$csrf_token}
                    <div class="form-group">
                        <label for="pack_name">Package Name:</label>
                        <input id="pack_name" class="form-control" type="text" name="pack_name" required>
                    </div>

                    <div class="form-group">
                        <label for="pack_price">Package Price</label>
                        <input id="pack_price" class="form-control" type="number" name="pack_price" required>
                    </div>

                    <div class="form-group">
                        <label for="pack_color">Package Color</label>
                        <select id="pack_color" class="form-control" name="pack_color" required>
                            <option>Select Color</option>
                            <option value="grey">Grey</option>
                            <option value="blue">Blue</option>
                            <option value="green">Green</option>
                            <option value="red">Red</option>
                        </select>
                    </div>

                    <button type="submit" name="submit" class="btn btn-success btn-block">Create New Package</button>
                </form>
            </div>
            <div class="col-md-8">
                {if $credits}
                {assign var="i" value=1}
                <table class="table table-light table-striped table-responsive">
                    <thead class="thead-light">
                        <tr>
                            <th>#</th>
                            <th>Pack Name</th>
                            <th>Pack Price</th>
                            <th>Pack Colour</th>
                            <th>Pack Created</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach from=$credits item=$credit}
                        <tr>
                            <td>{$i++}</td>
                            <td>{$credit->pack_name}</td>
                            <td>{$app.currency} {$credit->pack_price}</td>
                            <td>{$credit->pack_color}</td>
                            <td>{Carbon\Carbon::parse($credit->pack_created_at)->toFormattedDateString()}</td>
                            <td>
                                <form action="{$url.admin}/delete_credit_pack/{$credit->pack_id}" onsubmit="return confirm('Are you sure you want to delte?');" method="post">
                                    {$csrf_token}
                                    <button type="submit" name="submit" type="submit" class="btn btn-danger">Delete</button>
                                </form>
                            </td>
                        </tr>
                        {/foreach}
                    </tbody>
                </table>
                {else}
                <div class="alert alert-warning">No pack available yet!</div>
                {/if}
            </div>
        </div>
    </div>
</div>
{/block}