{extends file="layouts/admin.tpl"}

{block name=contents}

{$form_alert}
<div class="grid simple">
    <div class="grid-title">
        <h3 class="text-center">Bitcoin Gateway Infomations</h3>
        <h5 class="text-center text-danger"><strong>How To Set Up?</strong></h5>
    </div>
    <div class="grid-body">
    <p>
        <ol class="text-primary">
            <li>Create an account at: http://coinpayment.net</li>
            <li>Create or login you account</li>
            <li>Go to Account setting and get the marchant id and ipn Secret</li>
            <li>Go the coin settings and allow BTC</li>
            <li>Go to API key and get you API keys</li>
        </ol>
    </p>
    <hr>
        <form action="{$url.admin}/update_bitcoin_gateway" method="post" class="validate">
            {$csrf_token}
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="api_key">Bitcoin Public Key</label>
                        <input id="api_key" class="form-control" type="text" value="{$btc->btc_public_key}" name="public_key" required>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="api_secret_key">Bitcoin Private/Secrete key</label>
                        <input id="api_secret_key" class="form-control" type="text" value="{$btc->btc_private_key}" name="secret_key" required>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="marchant_id">Marchant ID</label>
                        <input id="marchant_id" class="form-control" type="text" value="{$btc->btc_machant_id}" name="marchant_id" required>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label for="wallet_addr">Wallet Address</label>
                        <input id="wallet_addr" class="form-control" type="text" value="{$btc->btc_wallet_addr}" name="wallet_addr">
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="tax_charges">Tax Charges</label>
                        <input id="tax_charges" class="form-control" type="number" value="{$btc->btc_tax}" name="btc_tax">
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="form-group">
                        <label for="api_secret_key">IPN Secret Key</label>
                        <input id="api_secret_key" class="form-control" type="password" value="{$btc->btc_ipn_secret}" name="ipn_secret" required>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="allow">Accept Bitcoin</label>
                        <select id="allow" class="form-control" name="btc_status">
                            <option value="1" {if $btc->btc_status eq 1}selected{/if}>Accept</option>
                            <option value="0" {if $btc->btc_status eq 0}selected{/if}>Disabled</option>
                        </select>
                    </div>
                </div>
                
                <div class="col-md-12">
                    <button type="submit" name="submit" class="btn btn-info btn-block">Save</button>
                </div>
                
            </div>
        </form>
    </div>
</div>
    
{/block}