{extends file="layouts/admin.tpl"}

{block name=contents}

<div class="grid simple">
    <div class="grid-title">
        <h4 class="text-primary">Available Forum Topics</h4>
    </div>
    <div class="grid-body">
        {$form_alert}
        <div class="">
            <table class="table table-bordered table-condensed" id="example">
                <thead>
                    <tr>
                        <th style="width:1%">
                        <div class="checkbox check-default" style="margin-right:auto;margin-left:auto;">
                        <input type="checkbox" value="1" id="checkbox0">
                        <label for="checkbox0"></label>
                        </div>
                        </th>
                        <th>#</th>
                        <th>Author</th>
                        <th>Topic Name</th>
                        <th>Topic Category</th>
                        <th>Replies</th>
                        <th>Created Date</th>
                        <th>Actions</th>
                        <th>Delete</th>
                        
                    </tr>
                </thead>
                <tbody>
                    {if $forums}
                    {assign var="i" value="1"}
                    {foreach from=$forums item=$forum}
                    <tr>
                        <td class="v-align-middle">
                        <div class="checkbox check-default">
                        <input type="checkbox" value="3" id="checkbox{$forum->forum_id}">
                        <label for="checkbox{$forum->forum_id}"></label>
                        </div>
                        </td>
                        <td>{$i++}</td>
                        <td><img src="{$u_photo}{$forum->user_avater}" width="35px" alt="Profile Pic" data-toggle="tooltip" data-placement="top" title="{$forum->user_firstname} {$forum->user_lastname} ({$forum->user_username})"></td>
                        <td>{$forum->forum_title}</td>
                        <td>{$forum->fcat_name}</td>
                        <td><a href="{$url.admin}/forum/comments/{$forum->forum_id}"><span class="badge badge-info">{$forum->tot}</span></a></td>
                        <td>{Carbon\Carbon::parse($forum->fourm_created_at)->toFormattedDateString()}</td>
                        <td><a href="{$url.admin}/forum/edit-topic/{$forum->forum_slug}"><span class="badge badge-primary">Edit</span></a></td>
                        <td>
                            <form action="{$url.admin}/remove_forum_topic/{$forum->forum_id}" method="post" onsubmit="return confirm('Are you sure? If you delte all item and category relate wil be remove.');">
                                {$csrf_token}
                                <button type="submit" name="submit" class="btn btn-danger btn-sm">Delete</button>
                            </form>
                        </td>
                    </tr>
                    {/foreach}
                    {/if}
                </tbody>
            </table>
        </div>
    </div>
</div>
    
{/block}

{block name=data_table_css}
<link href="{$asset}/plugins/bootstrap-select2/select2.css" rel="stylesheet" type="text/css" media="screen" />
<link href="{$asset}/plugins/jquery-datatable/css/jquery.dataTables.css" rel="stylesheet" type="text/css" />
 <link href="{$asset}/plugins/datatables-responsive/css/datatables.responsive.css" rel="stylesheet" type="text/css" media="screen" />
{/block}

{block name=data_table_js}
<script src="{$asset}/plugins/bootstrap-select2/select2.min.js" type="text/javascript"></script>
<script src="{$asset}/plugins/jquery-datatable/js/jquery.dataTables.min.js" type="text/javascript"></script>
<script src="{$asset}/plugins/jquery-datatable/extra/js/dataTables.tableTools.min.js" type="text/javascript"></script>
<script type="text/javascript" src="{$asset}/plugins/datatables-responsive/js/datatables.responsive.js"></script>
<script type="text/javascript" src="{$asset}/plugins/datatables-responsive/js/lodash.min.js"></script>

<script src="{$asset}/js/datatables.js" type="text/javascript"></script>
{/block}