{extends file="layouts/admin.tpl"}

{block name=contents}
<div class="grid simple">
    <div class="grid-title">
        <h4 class="text-primary">Modify: {$edit->forum_title}</h4>
    </div>
    <div class="grid-body">
        {$form_alert}
        <form action="{$url.admin}/update_forum_topic/{$edit->forum_id}/{$edit->forum_slug}" method="POST">
            {$csrf_token}
            <div class="row">
                <div class="col-md-8">
                    <div class="form-group">
                        <label for="title">Topic Name</label>
                        <input id="title" class="form-control" type="text" name="title" value="{$edit->forum_title}" required>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="form-group">
                        <label for="category">Category</label>
                        <select id="category" class="form-control" name="category" required>
                            <option>Select Category</option>
                            {if $cats}
                                {foreach from=$cats item=$cat}
                                    <option value="{$cat->fcat_id}" {if $cat->fcat_id eq $edit->forum_cat_id}selected{/if}>{$cat->fcat_name}</option>
                                {/foreach}
                            {/if}
                        </select>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="form-group">
                        <label for="comments">Comments</label>
                        <textarea id="comments" class="form-control" name="comments" rows="10">{$edit->forum_body}</textarea>
                    </div>
                </div>

                <div class="col-md-12">
                    <button type="submit" name="submit" class="btn btn-success btn-block">Update Forum</button>
                </div>
            </div>
        </form>
    </div>
</div>
{/block}