{extends file="layouts/admin.tpl"}

{block name=contents}
<div class="grid simple">
    <div class="grid-title">
        <h4>Credit System</h4>
    </div>
    <div class="grid-body">
        {$form_alert}
        <div class="row">
            <div class="col-md-4">
                <form action="{$url.admin}/create_new_forum_category" method="post" autocomplete="off">
                    {$csrf_token}
                    <div class="form-group">
                        <label for="pack_name">Category Name:</label>
                        <input id="pack_name" class="form-control" type="text" name="cat_name" required>
                    </div>

                    <div class="form-group">
                        <label for="forum_descrip">Description</label>
                        <textarea id="forum_descrip" class="form-control" name="cat_descrip" rows="3"></textarea>
                    </div>

                    <button type="submit" name="submit" class="btn btn-success btn-block">Create New Category</button>
                </form>
            </div>
            <div class="col-md-8">
                {if $fcats}
                {assign var="i" value=1}
                <table class="table table-light table-striped table-responsive">
                    <thead class="thead-light">
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Status</th>
                            <th>Description</th>
                            <th>Posts</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach from=$fcats item=$fcat}
                        <tr>
                            <td>{$i++}</td>
                            <td>{$fcat->fcat_name}</td>
                            <td>
                                {if $fcat->fcat_status eq 1}
                                    <span class="badge badge-success">Active</span>
                                    {else}
                                        <span class="badge badge-danger">DeActive</span>
                                {/if}
                            </td>
                            <td>{$fcat->fcat_descrip}</td>
                            <td>0</td>
                            <td>
                                <form action="{$url.admin}/delete_fcat/{$fcat->fcat_id}" onsubmit="return confirm('Are you sure you want to delte?');" method="post">
                                    {$csrf_token}
                                    <button type="submit" name="submit" type="submit" class="btn btn-danger">Delete</button>
                                </form>
                            </td>
                        </tr>
                        {/foreach}
                    </tbody>
                </table>
                {else}
                <div class="alert alert-warning">No available forum category yet</div>
                {/if}
            </div>
        </div>
    </div>
</div>
{/block}