<?php
defined('BASEPATH') OR exit('This page does not exist');
use Carbon\Carbon;
use JasonGrimes\Paginator;
defined('BASEPATH') OR exit('This page does not exist');

class Forum extends CI_Controller {

    public function __construct()
    {
        parent:: __construct();

        $intended = current_url();
        $this->session->set_userdata('intend', $intended);

        if($this->auths->userLogged())
        {
            $this->auths->userLoggedInfo();
        }
    }

    /*
    =================================================
    * Page view section
    ==================================================
    */

    //* Forum board page
    public function index()
    {
        //* Get forum boards
        $boards = $this->Forum_model->getForumBoards();
        $this->smarty->view('public/index.tpl', compact(
            'boards'
        ));
    }

    //* Create new topic
    public function create_new_topic()
    {
        if(! $this->auths->userLogged())
        {
            redirect('auth/login');
            exit();
        }

        $boards = $this->Forum_model->getForumBoards();
        $this->smarty->view('public/create.tpl', compact(
            'boards'
        ));
    }

    //* Single forum
    public function single($slug = NULL)
    {
        if(! $slug)
        {
            redirect('error_404');
            exit();
        }
        if($post = $this->Forum_model->getSinglePost($slug))
        {
            //* Get post replies
            $totalItems = $this->Forum_model->getTotalReply($post->forum_id);
            $itemsPerPage = 8;
            $currentPage = $this->uri->segment(4) ? $this->uri->segment(4) : 1;
            if($currentPage > 1)
            {
                $offset = $itemsPerPage * $currentPage - $itemsPerPage;
            }
            else
            {
                $offset = 0;
            }
            $urlPattern = base_url().'forum/topic/'.$slug.'/(:num)';
            $replies = $this->Forum_model->getForumReply($post->forum_id, $offset);
            $pages = new Paginator($totalItems, $itemsPerPage, $currentPage, $urlPattern);
            $this->smarty->view('public/single.tpl', compact(
                'post',
                'replies',
                'pages'
            ));
        }
        else
        {
            redirect('error_404');
            exit();
        }
    }

    //* Edit of forum
    public function edit_forum($slug)
    {
        if(! $this->auths->userLogged())
        {
            redirect('auth/login');
            exit();
        }

        $uid = $this->session->userdata('uids');

        //* Get forum infomations
        if($post = $this->Forum_model->getSinglePost($slug))
        {
            if($post->forum_user_id === $uid)
            {
                $this->smarty->view('public/edit.tpl', compact(
                    'post'
                ));
            }
            else
            {
                redirect('error_404');
                exit();
            }
        }
        else
        {
            redirect('error_404');
            exit();
        }
    }

    //* Editing forum reply
    public function edit_forum_reply($id)
    {
        //* Get reply contents
        $reply = $this->Forum_model->getReplyContents($id);

        if($reply->fr_user_id === $this->session->userdata('uids'))
        {
            $this->smarty->view('public/edit_reply.tpl', compact(
                'reply'
            ));
        }
    }

    //* Forum category section
    public function category($slug = NULL)
    {
        if(! $slug)
        {
            redirect('error_404');
            exit();
        }

        if($cats = $this->Forum_model->getForumCatBySlug($slug))
        {
            $totalItems = $this->Forum_model->getTotalTopicByCatSlug($cats->fcat_id);
            $itemsPerPage = 10;
            $currentPage = $this->uri->segment(4) ? $this->uri->segment(4) : 1;
            if($currentPage > 1)
            {
                $offset = $itemsPerPage * $currentPage - $itemsPerPage;
            }
            else
            {
                $offset = 0;
            }
            $urlPattern = base_url().'forum/category/'.$slug.'/(:num)';
            $forums = $this->Forum_model->getForumByCat($cats->fcat_id, $offset);
            $pages = new Paginator($totalItems, $itemsPerPage, $currentPage, $urlPattern);
            $this->smarty->view('public/category.tpl', compact(
                'cats',
                'forums',
                'pages'
            ));
        }
    }

    //* Search forum
    public function search()
    {
        $search = $this->input->get('search');
        $totalItems = $this->Forum_model->getTotalSearch($search);
        $itemsPerPage = 10;
        $currentPage = $this->uri->segment(3) ? $this->uri->segment(3) : 1;
        if($currentPage > 1)
        {
            $offset = $itemsPerPage * $currentPage - $itemsPerPage;
        }
        else
        {
            $offset = 0;
        }
        $urlPattern = base_url().'forum/search?'.$search.'/(:num)';

        $results = $this->Forum_model->getSearch($search, $offset);
        $pages = new Paginator($totalItems, $itemsPerPage, $currentPage, $urlPattern);
        $this->smarty->view('public/search.tpl', compact(
            'search',
            'results',
            'pages'
        ));
    }

    /*
    =================================================
    * Page view section ends here
    ==================================================
    */

    /*
    ====================================================
    * Creating of data
    ====================================================
    */

    //* Create new forum topic
    public function create_topic()
    {
        if(! isset($_POST['submit']))
        {
            redirect('error_404');
            exit();
        }

        //* Validate input requet
        $this->form_validation->set_rules('topic', 'Topic Name', 'trim|required|min_length[3]|max_length[100]|xss_clean|strip_tags', array(
            'required' => '%s is can not be blank',
            'min_length' => '%s must be at least 3 characters',
            'max_length' => '%s must not be greater thatn 100 characters'
        ));
        
        $this->form_validation->set_rules('comments', 'Comments', 'trim|required|xss_clean|strip_tags');
        
        //* Check for validation
        
        if ($this->form_validation->run() == FALSE) {
            $errors = array(
                'error' => validation_errors('<div class="error-alert" align="center">','</div>')
            );

            $this->session->set_flashdata($errors);
            redirect('forum/create-topic');
        } else {
            
            $data = array(
                'forum_user_id' => $this->session->userdata('uids'),
                'forum_cat_id' => $this->input->post('category'),
                'forum_title' => $this->input->post('topic'),
                'forum_body' => $this->input->post('comments'),
                'forum_slug' => url_title($this->input->post('topic'), 'dash', true) . '-' . time() . $this->session->userdata('uids')
            );

            if($id = $this->Forum_model->createNewTopic($data))
            {
                $this->session->set_flashdata('error', '<div class="success-alert" align="center">New topic has been created!</div>');

                //* Retrieve last crated forum
                $forum = $this->Forum_model->getLastCreatedForum($id);

                //* Do redirection
                redirect('forum/topic/'.$forum);
            }
        }
        
    }

    //* Create new thrend reply
    public function post_new_reply($id)
    {
        if($this->input->is_ajax_request())
        {
            //* VAlidate the input request
            $this->form_validation->set_rules('treply', 'Comments', 'trim|required|xss_clean|strip_tags');
            
            
            if ($this->form_validation->run() == TRUE) {
                
                $data = array(
                    'fr_forum_id' => $id,
                    'fr_user_id' => $this->session->userdata('uids'),
                    'fr_comment' => $this->input->post('treply')
                );

                $last_id = $this->Forum_model->createNewForumReply($data);

                 //* Get user info
                 $u_info = $this->Account_model->getUserRaterInfo($this->session->userdata('uids'));
                 //* Get the item information
                 $forum = $this->Forum_model->getForumReplyTo($id);
                 //* Let send notification email to author
                 $site_info = $this->Settings_model->getApllicationInfo();
                 $template = array(
                     'username' => $u_info->user_username,
                     'email' => $u_info->user_email,
                     'firstname' => $u_info->user_firstname,
                     'lastname' => $u_info->user_lastname,
                     'sitename' => $site_info->set_site_name,
                     'sitelogo' => base_url() . 'static/website/site-logo/' . $site_info->set_site_logo,
                     'main_url' => base_url(),
                     'forum_url' => base_url().'forum/topic/'. $forum->forum_slug,
                     'forum_name' => $forum->forum_title,
                     'user_avater' => base_url('static/profile/users/'.$u_info->user_avater)
                 );
                 
                 $send_welcome_email = $this->Email_model->getEmailTempsToSend($id = 10);
                 $template['send_msg'] = $send_welcome_email;
                 $messages = $this->parser->parse('mails/welcome/send', $template, true);

                 //* Email for forum aurhtor
                 if($forum->forum_user_id != $this->session->userdata('uids'))
                 {
                    $email_set = $this->Settings_model->getSmtpDetails();
                    if ($email_set->smtp_type == 'ssl') {
                        $config['protocol']  = 'smtp';
                        $config['smtp_host'] = $email_set->smtp_type . '://' . $email_set->smtp_host;
                        $config['smtp_port'] = $email_set->smtp_port;
                        $config['smtp_user'] = $email_set->smtp_username;
                        $config['smtp_pass'] = $email_set->smtp_password;
                        $config['mailtype']  = 'html';
                        $config['charset']   = 'utf-8';
                        $config['newline'] = '\n';
                    } else {
                        $config['protocol']  = 'smtp';
                        $config['smtp_host'] = $email_set->smtp_host;
                        $config['smtp_port'] = $email_set->smtp_port;
                        $config['smtp_user'] = $email_set->smtp_username;
                        $config['smtp_pass'] = $email_set->smtp_password;
                        $config['mailtype']  = 'html';
                        $config['charset']   = 'utf-8';
                        $config['newline'] = '\n';
                    }

                    $this->email->initialize($config);
                    $this->email->set_mailtype("html");
                    $this->email->set_newline("\r\n");
                    $this->email->from($email_set->smtp_default_email, $email_set->smtp_display_name);
                    $this->email->to($forum->user_email);
                    $this->email->subject($u_info->user_username.' reply to a Forum topic');
                    $this->email->message($messages);
                    $this->email->send();
                 }

                 //* Message for replyers
                 $my_id = $this->session->userdata('uids');
                 $a_id = $forum->forum_user_id;
                 $id = $forum->forum_id;
                 if($others = $this->Forum_model->getForumCommenters($id,$my_id, $a_id))
                 {
                    foreach($others as $other)
                    {
                        $email_set = $this->Settings_model->getSmtpDetails();
                        if ($email_set->smtp_type == 'ssl') {
                            $config['protocol']  = 'smtp';
                            $config['smtp_host'] = $email_set->smtp_type . '://' . $email_set->smtp_host;
                            $config['smtp_port'] = $email_set->smtp_port;
                            $config['smtp_user'] = $email_set->smtp_username;
                            $config['smtp_pass'] = $email_set->smtp_password;
                            $config['mailtype']  = 'html';
                            $config['charset']   = 'utf-8';
                            $config['newline'] = '\n';
                        } else {
                            $config['protocol']  = 'smtp';
                            $config['smtp_host'] = $email_set->smtp_host;
                            $config['smtp_port'] = $email_set->smtp_port;
                            $config['smtp_user'] = $email_set->smtp_username;
                            $config['smtp_pass'] = $email_set->smtp_password;
                            $config['mailtype']  = 'html';
                            $config['charset']   = 'utf-8';
                            $config['newline'] = '\n';
                        }

                        $this->email->initialize($config);
                        $this->email->set_mailtype("html");
                        $this->email->set_newline("\r\n");
                        $this->email->from($email_set->smtp_default_email, $email_set->smtp_display_name);
                        $this->email->to($other->user_email);
                        $this->email->subject($u_info->user_username.' reply to a Forum topic');
                        $this->email->message($messages);
                        $this->email->send();
                    }
                 }


                $time = new Carbon();

                //* Get last forum reply
                $reply = $this->Forum_model->getForumLastReply($last_id);

                echo '
                <hr class="line-separator">
                <div class="comment-wrap">
                    <a href="javascript:void(0);">
                        <figure class="user-avatar medium">
                            <img src="'.base_url('static/profile/users').'/'.$reply->user_avater.'" alt="">
                        </figure>
                    </a>
                    <div class="comment">
                        <p class="text-header">'.$reply->user_firstname.' '.$reply->user_lastname.'</p>
                        <p class="timestamp">'.$time->parse($reply->fr_created_at)->diffForHumans().'</p>
                        <a href="javascript:void(0);" class="reply">Edit</a>
                        <a href="javascript:void(0);" class="report">Delete</a>
                        <p>'.nl2br(auto_link($reply->fr_comment)).'</p>
                    </div>
                </div>
                ';
            }
            
        }
        else
        {
            redirect('error_404');
            exit();
        }
    }

    /*
    ======================================================
    * Creating of data ends here
    =====================================================
    */

    /*
    =================================================
    * Updating of data
    =================================================
    */

    //* Update forum post
    public function update_topic($slug,$id,$uid)
    {
        if($uid != $this->session->userdata('uids'))
        {
            redirect('error_404');
            exit();
        }
        //* Validate input
        $this->form_validation->set_rules('comments', 'Comments', 'trim|required|xss_clean|strip_tags');
        
        if ($this->form_validation->run() == FALSE) {
            $errors = array(
                'error' => validation_errors('<div class="error-alert">','</div>')
            );
            $this->session->set_flashdata($errors);
            redirect('forum/edit/'.$slug);
        } else {
            $data = array(
                'forum_body' => $this->input->post('comments')
            );

            //* Update the data
            if($this->Forum_model->updateUserForum($data, $id))
            {
                $this->session->set_flashdata('error', '<div class="success-alert" align="center">Updated Complete</div>');
                redirect('forum/topic/'.$slug);
            }
        }
        
    }

    //* Update forum reply
    public function update_reply($id)
    {
        if(! isset($_POST['submit']))
        {
            redirect('error_404');
            exit();
        }

        //* Validate the input request
        $this->form_validation->set_rules('comments', 'comments', 'trim|required|xss_clean|strip_tags');
        
        //* check validations
        
        if ($this->form_validation->run() == FALSE) {
            $errors = array(
                'error' => validation_errors('<div class="error-alert" align="center">','</div>')
            );

            $this->session->set_flashdata($errors);
            redirect('forum/edit-reply/'.$id);
        } else {
            $data = array(
                'fr_comment' => $this->input->post('comments')
            );
            if($this->Forum_model->updateForumReply($data, $id))
            {
                $this->session->set_flashdata('error', '<div class="success-alert">Comment updated!</div>');
                redirect('forum');
            }
        }
        
    }

    /*
    =================================================
    * Updating of data ends here
    =================================================
    */

    /*
    =================================================
    * Deleting of data
    =================================================
    */

    //* User delete forum post
    public function del_forum()
    {
        $id = $this->input->post('del');
        
        if($this->Forum_model->deleteForum($id))
        {
            $this->session->set_flashdata('error', '<div class="error-alert" align="center">Action Complete!</div>');
            redirect('forum');
        }
    }

    //* Removing forum reply
    public function remove_reply($id)
    {
        if($this->input->is_ajax_request())
        {
            if($this->Forum_model->removeReply($id))
            {
                echo 'done';
            }
        }
        else
        {
            redirect('error_404');
            exit();
        }
    }

    /*
    =================================================
    * Deleting of data ends
    =================================================
    */
}